
class CKNGMoreBlood {

	var attackAction 						: W3Action_Attack;
	var weaponId							: SItemUniqueId;
	var actorAttacker 						: CActor;
	var playerAttacker						: CR4Player;
	var npc 								: CNewNPC;
	var bloodTrailParam 					: CBloodTrailEffect;
	var showMoreBloodOnlyOnCriticalHits		: bool;
	
		
	public function Init(act : W3DamageAction, isCriticalHit : bool) {
		
		showMoreBloodOnlyOnCriticalHits = false;
				
		iWantMoreBlood(act, isCriticalHit);

	}
			
	public function iWantMoreBlood(act : W3DamageAction, isCriticalHit : bool) {
		
	attackAction 		= (W3Action_Attack)act;
 	weaponId 			= attackAction.GetWeaponId();
	actorAttacker		= (CActor)act.attacker;
	playerAttacker 		= (CR4Player)act.attacker;
	npc 				= (CNewNPC)act.victim;
				

		if(actorAttacker == GetWitcherPlayer() && npc.isAttackableByPlayer && act.DealsPhysicalOrSilverDamage() && !attackAction.IsParried() && !attackAction.IsCountered() && (!showMoreBloodOnlyOnCriticalHits || isCriticalHit)) {
		
			if ( attackAction.IsActionRanged() || thePlayer.IsWeaponHeld('fist') || attackAction.WasDodged()) {
		
				return;
		
				} else { 
														
				bloodTrailParam = (CBloodTrailEffect)actorAttacker.GetGameplayEntityParam( 'CBloodTrailEffect' );
				
				thePlayer.inv.PlayItemEffect(weaponId, 'blood_trail_horseriding');
							
				//impactBlood();
					
				}
		
			}
				
		}
		
	public function impactBlood() {
		
		var weaponEntity : CEntity;		
		var weaponSlotMatrix : Matrix;
		var bloodFxPos : Vector;
		var bloodFxRot : EulerAngles;
		var tempEntity : CEntity;
		
			weaponEntity = thePlayer.GetInventory().GetItemEntityUnsafe(thePlayer.GetInventory().GetItemFromSlot('r_weapon'));
			weaponEntity.CalcEntitySlotMatrix('blood_fx_point', weaponSlotMatrix);
			
			bloodFxPos = MatrixGetTranslation(weaponSlotMatrix);
			bloodFxRot = weaponEntity.GetWorldRotation();
			
			tempEntity = theGame.CreateEntity( (CEntityTemplate)LoadResource('finisher_blood'), bloodFxPos, bloodFxRot);
			tempEntity.PlayEffect('crawl_blood');
								
		}
	}
	
