local assets =
{
	Asset("ANIM", "anim/ak47.zip"),
	Asset("ANIM", "anim/swap_ak47.zip"),
    Asset("ATLAS", "images/inventoryimages/ak47.xml"),
	
}

local prefabs = 
{
    "fire_projectile", 
	"akclip",
}

local function onattack_ak47(inst, owner, target)
	owner.components.inventory:ConsumeByName("akclip", 1)
	target:AddTag("akclip_hit")

	if owner and owner.components.inventory and owner.components.inventory:Has("akclip", 1) then
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.AK47_DAMAGE)
    inst.components.weapon:SetRange(13)
    inst.components.weapon:SetOnAttack(onattack_ak47)
    inst.components.weapon:SetProjectile("fire_projectile")
	else
  	if owner and owner.components.inventory and not owner.components.inventory:Has("akclip", 1) then
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(5)
    inst.components.weapon:SetRange(0)
    inst.components.weapon:SetOnAttack(onattack_ak47)
	end
	end
	--[[
	if target:HasTag("dpclip_hit") and target.components.health:IsDead() then
	SpawnPrefab("dpclip").Transform:SetPosition(target.Transform:GetWorldPosition())
	end
	]]
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_ak47", "swap_ak47")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
    if owner and owner.components.inventory and not owner.components.inventory:Has("akclip", 1) then
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(5)
    inst.components.weapon:SetRange(0)
    inst.components.weapon:SetOnAttack(onattack_ak47)
	end
	if owner and owner.components.inventory and owner.components.inventory:Has("akclip", 1) then
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.AK47_DAMAGE)
    inst.components.weapon:SetRange(13)
    inst.components.weapon:SetOnAttack(onattack_ak47)
    inst.components.weapon:SetProjectile("fire_projectile")
	end
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end


local function fn(Sim)

	local inst = CreateEntity()
	local minimap = inst.entity:AddMiniMapEntity()
	

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("ak47")
    inst.AnimState:SetBuild("ak47")
    inst.AnimState:PlayAnimation("idle")
	inst:AddTag("ak47") 
    
	
	inst:AddTag("firestaff")
    inst:AddTag("rangedfireweapon")
	
	 if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()
  
	
	minimap:SetIcon("ak47.tex")
	
	inst:AddComponent("weapon")
    inst.components.weapon:SetOnAttack(onattack_ak47)
	inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/ak47.xml"
 
    inst:AddComponent("equippable")
	
	
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	MakeHauntableLaunch(inst)
	
 
 
    return inst
end

STRINGS.NAMES.AK47 = "Sturmgewehr 44"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AK47 = "Well built"
STRINGS.RECIPE_DESC.AK47 = "Powerful assualt riffle"


return Prefab("common/inventory/ak47", fn, assets)