local assets=
{ 
    Asset("ANIM", "anim/combatar.zip"), 
    Asset("ANIM", "anim/ground_combatar.zip"), 

    Asset("ATLAS", "images/inventoryimages/combatar.xml"),
    Asset("IMAGE", "images/inventoryimages/combatar.tex"),
}

local prefabs = 
{
}
   
    local function OnBlocked(owner, data)
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_scalemail")
    
    end


local function fn(colour)

    local function OnEquip(inst, owner) 
        --owner.AnimState:OverrideSymbol("swap_object", "swap_wands", "purplestaff")
    owner.AnimState:OverrideSymbol("swap_body", "combatar", "swap_body")

    inst:ListenForEvent("blocked", OnBlocked, owner)
    inst:ListenForEvent("attacked", OnBlocked, owner)
    local MaxHP = owner.components.health.maxhealth
    local currentHP = owner.components.health.currenthealth

if owner.components.health ~= nil and MaxHP ~= currentHP then
    owner.components.health:StartRegen(TUNING.HPREGEN,2, true)
else
     owner.components.health:StopRegen()
end

    end

    local function OnUnequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
    owner.components.health:StopRegen()
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
    inst:RemoveEventCallback("attacked", OnBlocked, owner)
    end



    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("ground_combatar")
    anim:SetBuild("ground_combatar")
    anim:PlayAnimation("idle")

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "combatar"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/combatar.xml"
    

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    return inst
end

STRINGS.NAMES.COMBATAR = "Combat Armor"
STRINGS.RECIPE_DESC.COMBATAR = "This armor Heals you over time once attacked"

return  Prefab("common/inventory/combatar", fn, assets, prefabs)