local assets =
{
	Asset("ANIM", "anim/deagle.zip"),
	Asset("ANIM", "anim/swap_deagle.zip"),
    Asset("ATLAS", "images/inventoryimages/deagle.xml"),
	
}

local prefabs = 
{
    "fire_projectile", 
	"deagleclip",
}

local function onattack_deagle(inst, owner, target)
	owner.components.inventory:ConsumeByName("deagleclip", 1)
	target:AddTag("deagleclip_hit")

	if owner and owner.components.inventory and owner.components.inventory:Has("deagleclip", 1) then
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.DEAGLE_DAMAGE)
    inst.components.weapon:SetRange(13)
    inst.components.weapon:SetOnAttack(onattack_deagle)
    inst.components.weapon:SetProjectile("fire_projectile")
	else
  	if owner and owner.components.inventory and not owner.components.inventory:Has("deagleclip", 1) then
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(5)
    inst.components.weapon:SetRange(0)
    inst.components.weapon:SetOnAttack(onattack_deagle)
	end
	end
	--[[
	if target:HasTag("dpclip_hit") and target.components.health:IsDead() then
	SpawnPrefab("dpclip").Transform:SetPosition(target.Transform:GetWorldPosition())
	end
	]]
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_deagle", "swap_deagle")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
    if owner and owner.components.inventory and not owner.components.inventory:Has("deagleclip", 1) then
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(5)
    inst.components.weapon:SetRange(0)
    inst.components.weapon:SetOnAttack(onattack_deagle)
	end
	if owner and owner.components.inventory and owner.components.inventory:Has("deagleclip", 1) then
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.DEAGLE_DAMAGE)
    inst.components.weapon:SetRange(13)
    inst.components.weapon:SetOnAttack(onattack_deagle)
    inst.components.weapon:SetProjectile("fire_projectile")
	end
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end


local function fn(Sim)

	local inst = CreateEntity()
	local minimap = inst.entity:AddMiniMapEntity()
	

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("deagle")
    inst.AnimState:SetBuild("deagle")
    inst.AnimState:PlayAnimation("idle")
	inst:AddTag("deagle") 
    
	
	inst:AddTag("firestaff")
    inst:AddTag("rangedfireweapon")
	
	 if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()
  
	
	minimap:SetIcon("deagle.tex")
	
	inst:AddComponent("weapon")
    inst.components.weapon:SetOnAttack(onattack_deagle)
	inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/deagle.xml"
 
    inst:AddComponent("equippable")
	
	
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	MakeHauntableLaunch(inst)
	
 
 
    return inst
end

STRINGS.NAMES.DEAGLE = "Luger P08"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.DEAGLE = "Very reliable Pistol."
STRINGS.RECIPE_DESC.DEAGLE = "Lets get shooting"


return Prefab("common/inventory/deagle", fn, assets)