local assets=
{
	Asset("ANIM", "anim/deagleclip.zip"),
	Asset("ATLAS", "images/inventoryimages/deagleclip.xml"),
    Asset("IMAGE", "images/inventoryimages/deagleclip.tex"),
}

local prefabs =
{

}


local function fncommon(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)
	
    
	inst.entity:SetPristine()
	
    if not TheWorld.ismastersim then
        return inst
    end
	
    inst:AddComponent("stackable")	 
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	
    inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/deagleclip.xml"

	return inst
end
local function fndeagleclip(Sim)
	local inst = fncommon(Sim)
	    
    inst.AnimState:SetBank("deagleclip")--("bullet")
    inst.AnimState:SetBuild("deagleclip")
    inst.AnimState:PlayAnimation("idle")    
    
    if not TheWorld.ismastersim then
        return inst
    end
	
	return inst
end

STRINGS.NAMES.DEAGLECLIP = "Luger P08 Clip"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.DEAGLECLIP = "Used for the Luger P08"
STRINGS.RECIPE_DESC.DEAGLECLIP = "Reload the Luger P08"
return Prefab( "common/inventory/deagleclip", fndeagleclip, assets)
