local assets =
{
	Asset("ANIM", "anim/glock.zip"),
	Asset("ANIM", "anim/swap_glock.zip"),
    Asset("ATLAS", "images/inventoryimages/glock.xml"),
	
}

local prefabs = 
{
    "fire_projectile", 
	"glockclip",
}

local function onattack_glock(inst, owner, target)
	owner.components.inventory:ConsumeByName("glockclip", 1)
	target:AddTag("glockclip_hit")

	if owner and owner.components.inventory and owner.components.inventory:Has("glockclip", 1) then
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.GLOCK_DAMAGE)
    inst.components.weapon:SetRange(13)
    inst.components.weapon:SetOnAttack(onattack_glock)
    inst.components.weapon:SetProjectile("fire_projectile")
	else
  	if owner and owner.components.inventory and not owner.components.inventory:Has("glockclip", 1) then
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(5)
    inst.components.weapon:SetRange(0)
    inst.components.weapon:SetOnAttack(onattack_glock)
	end
	end
	--[[
	if target:HasTag("dpclip_hit") and target.components.health:IsDead() then
	SpawnPrefab("dpclip").Transform:SetPosition(target.Transform:GetWorldPosition())
	end
	]]
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_glock", "swap_glock")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
    if owner and owner.components.inventory and not owner.components.inventory:Has("glockclip", 1) then
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(5)
    inst.components.weapon:SetRange(0)
    inst.components.weapon:SetOnAttack(onattack_glock)
	end
	if owner and owner.components.inventory and owner.components.inventory:Has("glockclip", 1) then
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.GLOCK_DAMAGE)
    inst.components.weapon:SetRange(13)
    inst.components.weapon:SetOnAttack(onattack_glock)
    inst.components.weapon:SetProjectile("fire_projectile")
	end
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end


local function fn(Sim)

	local inst = CreateEntity()
	local minimap = inst.entity:AddMiniMapEntity()
	

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("glock")
    inst.AnimState:SetBuild("glock")
    inst.AnimState:PlayAnimation("idle")
	inst:AddTag("glock") 
    
	
	inst:AddTag("firestaff")
    inst:AddTag("rangedfireweapon")
	
	 if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()
  
	
	minimap:SetIcon("glock.tex")
	
	inst:AddComponent("weapon")
    inst.components.weapon:SetOnAttack(onattack_glock)
	inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/glock.xml"
 
    inst:AddComponent("equippable")
	
	
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	MakeHauntableLaunch(inst)
	
 
 
    return inst
end

STRINGS.NAMES.GLOCK = "Walther P38"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GLOCK = "A late model of the P38 Walther"
STRINGS.RECIPE_DESC.GLOCK = "Not bad!"


return Prefab("common/inventory/glock", fn, assets)