local assets=
{
	Asset("ANIM", "anim/glockclip.zip"),
	Asset("ATLAS", "images/inventoryimages/glockclip.xml"),
    Asset("IMAGE", "images/inventoryimages/glockclip.tex"),
}

local prefabs =
{

}


local function fncommon(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)
	
    
	inst.entity:SetPristine()
	
    if not TheWorld.ismastersim then
        return inst
    end
	
    inst:AddComponent("stackable")	 
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	
    inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/glockclip.xml"

	return inst
end
local function fnglockclip(Sim)
	local inst = fncommon(Sim)
	    
    inst.AnimState:SetBank("glockclip")--("bullet")
    inst.AnimState:SetBuild("glockclip")
    inst.AnimState:PlayAnimation("idle")    
    
    if not TheWorld.ismastersim then
        return inst
    end
	
	return inst
end

STRINGS.NAMES.GLOCKCLIP = "Walther P38 Clip"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GLOCKCLIP = "Used fro the P38 Walther"
STRINGS.RECIPE_DESC.GLOCKCLIP = "Reload the P38 Walther"
return Prefab( "common/inventory/glockclip", fnglockclip, assets)
