local assets=
{
    Asset("ANIM", "anim/knife.zip"),
    Asset("ANIM", "anim/swap_knife.zip"),
 
    Asset("ATLAS", "images/inventoryimages/knife.xml"),
    Asset("IMAGE", "images/inventoryimages/knife.tex"),
}

local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_knife", "swap_knife")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end
 
    local function OnUnequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end
 local function fn()
	local inst = CreateEntity()
	
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
     
    inst.AnimState:SetBank("knife")
    inst.AnimState:SetBuild("knife")
    inst.AnimState:PlayAnimation("idle")
 
 if not TheWorld.ismastersim then
        return inst
    end
 
    inst.entity:SetPristine()
    
    inst:AddTag("sharp")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.KNIFE_DAMAGE)
	inst.components.weapon:SetRange(1.5, 1.5)
	
	inst:AddComponent("tool")
	inst.components.tool:SetAction(ACTIONS.CHOP, 1)
    
 
    inst:AddComponent("inspectable")
	
     
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "knife"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/knife.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	inst.components.inventoryitem.keepondeath = true

    return inst
end
   STRINGS.NAMES.KNIFE = "Combat Knife"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.KNIFE = "Military Grade Knife"
STRINGS.RECIPE_DESC.KNIFE = "Powerful combat Knife"

return  Prefab("common/inventory/knife", fn, assets, prefabs)
