local gameVersion = tonumber(string.sub(getCore():getVersionNumber(), 0, 2))

local function ShowXP(player, skill, level)
	local perk = PerkFactory.getPerk(Perks.FromString(tostring(skill)))
	
	if perk ~= nil then
		if gameVersion > 40 then
			if player:isNPC() == false then -- Super Survivor compatibility. Otherwise player spams nearby survivor skill gains.
				if perkName ~= "Strength" then
					player:Say(perk:getName() .. string.format(" +%.1f", tostring(level)))
				end
			end
		else
			local perkName = perk:getName()
			
			if perkName ~= "Strength" then
				local parentPerk = perk:getParent()
				local parentName = ""
				
				if parentPerk == Perks.BladeParent or parentPerk == Perks.BluntParent then
					parentName = string.sub(tostring(parentPerk), 0, 5) .. " "
				end
				
				player:Say(parentName .. perkName .. string.format(" +%.1f", tostring(level)))
			end
		end
	end
end

Events.AddXP.Add(ShowXP)