/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.typeUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeUtilsKt {
    @NotNull
    public static final KotlinBuiltIns getBuiltIns(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        KotlinBuiltIns kotlinBuiltIns = $receiver.getConstructor().getBuiltIns();
        Intrinsics.checkExpressionValueIsNotNull(kotlinBuiltIns, "constructor.builtIns");
        return kotlinBuiltIns;
    }

    @NotNull
    public static final KotlinType makeNullable(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TypeUtils.makeNullable($receiver);
    }

    @NotNull
    public static final KotlinType makeNotNullable(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TypeUtils.makeNotNullable($receiver);
    }

    public static final boolean isAnyOrNullableAny(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isAnyOrNullableAny($receiver);
    }

    public static final boolean isTypeParameter(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TypeUtils.isTypeParameter($receiver);
    }

    public static final boolean isSubtypeOf(@NotNull KotlinType $receiver, @NotNull KotlinType superType) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(superType, "superType");
        return KotlinTypeChecker.DEFAULT.isSubtypeOf($receiver, superType);
    }

    @NotNull
    public static final KotlinType replaceAnnotations(@NotNull KotlinType $receiver, @NotNull Annotations newAnnotations) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(newAnnotations, "newAnnotations");
        if ($receiver.getAnnotations().isEmpty() && newAnnotations.isEmpty()) {
            return $receiver;
        }
        return $receiver.unwrap().replaceAnnotations(newAnnotations);
    }

    @NotNull
    public static final TypeProjection createProjection(@NotNull KotlinType type2, @NotNull Variance projectionKind, @Nullable TypeParameterDescriptor typeParameterDescriptor) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull((Object)projectionKind, "projectionKind");
        TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
        return new TypeProjectionImpl(Intrinsics.areEqual((Object)(typeParameterDescriptor2 != null ? typeParameterDescriptor2.getVariance() : null), (Object)projectionKind) ? Variance.INVARIANT : projectionKind, type2);
    }

    @NotNull
    public static final TypeProjection asTypeProjection(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new TypeProjectionImpl($receiver);
    }

    @NotNull
    public static final KotlinType replaceArgumentsWithStarProjections(@NotNull KotlinType $receiver) {
        UnwrappedType unwrappedType;
        UnwrappedType unwrapped;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        UnwrappedType unwrappedType2 = unwrapped = $receiver.unwrap();
        if (unwrappedType2 instanceof FlexibleType) {
            unwrappedType = KotlinTypeFactory.flexibleType(TypeUtilsKt.replaceArgumentsWithStarProjections(((FlexibleType)unwrapped).getLowerBound()), TypeUtilsKt.replaceArgumentsWithStarProjections(((FlexibleType)unwrapped).getUpperBound()));
        } else if (unwrappedType2 instanceof SimpleType) {
            unwrappedType = TypeUtilsKt.replaceArgumentsWithStarProjections((SimpleType)unwrapped);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return TypeWithEnhancementKt.inheritEnhancement(unwrappedType, unwrapped);
    }

    /*
     * WARNING - void declaration
     */
    private static final SimpleType replaceArgumentsWithStarProjections(@NotNull SimpleType $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        if ($receiver.getConstructor().getParameters().isEmpty() || $receiver.getConstructor().getDeclarationDescriptor() == null) {
            return $receiver;
        }
        List<TypeParameterDescriptor> list = $receiver.getConstructor().getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "constructor.parameters");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            StarProjectionImpl starProjectionImpl = new StarProjectionImpl((TypeParameterDescriptor)p1);
            collection.add(starProjectionImpl);
        }
        List newArguments = (List)destination$iv$iv;
        return TypeSubstitutionKt.replace$default($receiver, newArguments, null, 2, null);
    }
}

