/*
 * Decompiled with CFR 0.152.
 */
package net.hegedus.binocular.handlers;

import net.hegedus.binocular.items.BinocularItem;
import net.hegedus.binocular.proxy.ClientProxy;
import net.hegedus.binocular.renderer.GuiOverlayScreen;
import net.hegedus.binocular.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ZoomKeyHandler {
    private Minecraft mc;
    private BinocularItem tavcso;
    private boolean bZoomIn = false;
    private boolean bZoomOut = false;
    private boolean bZoomReset = false;
    private boolean bNightV = false;
    private boolean bZoomLock = false;
    private boolean bWayPoints = false;
    private boolean bQuickInfo = false;
    private float zoomStep = 0.01f;
    private float zoomMin = 0.015f;
    private float zoomMax = 1.5f;
    private float zoomReset = 0.25f;
    public static final int ZOOM_IN = 0;
    public static final int ZOOM_OUT = 1;
    public static final int ZOOM_RESET = 2;
    public static final int NIGHT_VISION = 3;
    public static final int ZOOM_LOCK = 4;
    public static final int WAY_POINTS = 5;
    public static final int QUICK_INFO = 6;

    public void init() {
        this.mc = Minecraft.func_71410_x();
        this.tavcso = Utils.getBinocularItem(this.mc);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        this.init();
        if (this.mc.field_71415_G && this.tavcso != null) {
            Utils.initConfig();
            KeyBinding[] keyBindings = ClientProxy.keyBindings;
            this.bZoomIn = keyBindings[0].func_151468_f();
            this.bZoomOut = keyBindings[1].func_151468_f();
            this.bZoomReset = keyBindings[2].func_151468_f();
            this.bNightV = keyBindings[3].func_151468_f();
            this.bZoomLock = keyBindings[4].func_151468_f();
            this.bWayPoints = keyBindings[5].func_151468_f();
            this.bQuickInfo = keyBindings[6].func_151468_f();
            boolean bIsUsing = this.tavcso.isUsing();
            if (this.bZoomIn || this.bZoomOut || this.bZoomReset || this.bNightV) {
                if (bIsUsing) {
                    if (this.bZoomIn) {
                        this.setZoomFactor(-this.zoomStep);
                    }
                    if (this.bZoomOut) {
                        this.setZoomFactor(this.zoomStep);
                    }
                    if (this.bZoomReset) {
                        this.setZoomFactor(this.zoomReset);
                    }
                    if (this.bNightV) {
                        boolean bl = this.tavcso.nightVision = !this.tavcso.nightVision;
                        if (this.tavcso.nightVision) {
                            System.out.println("NightVision ON");
                            this.mc.field_71439_g.func_70690_d(new PotionEffect(Potion.func_188412_a((int)16), 5, 1));
                        } else {
                            System.out.println("NightVision OFF");
                            this.mc.field_71439_g.func_184589_d(Potion.func_188412_a((int)16));
                        }
                    }
                }
            } else if (this.bWayPoints && this.tavcso.zoomLocked) {
                this.showWayPoints();
            } else if (this.bQuickInfo) {
                boolean bl = this.tavcso.quickInfo = !this.tavcso.quickInfo;
            }
            if (this.bZoomLock) {
                this.setZoomLock();
            }
        }
    }

    private void showWayPoints() {
        this.mc.func_147108_a((GuiScreen)new GuiOverlayScreen(this.mc));
    }

    private void setZoomLock() {
        boolean bl = this.tavcso.zoomLocked = !this.tavcso.zoomLocked;
        if (!this.tavcso.zoomLocked) {
            this.tavcso.resetUse();
        } else {
            this.tavcso.setUse();
        }
    }

    public void setZoomFactor(float correction) {
        float zoomFactor = this.tavcso.zoomFactor;
        if (correction == this.zoomReset) {
            zoomFactor = this.zoomReset;
        } else if ((zoomFactor += correction) < this.zoomMin) {
            zoomFactor = this.zoomMin;
        } else if (zoomFactor > this.zoomMax) {
            zoomFactor = this.zoomMax;
        }
        this.tavcso.zoomFactor = zoomFactor;
    }
}

