/*
 * Decompiled with CFR 0.152.
 */
package net.hegedus.binocular.renderer;

import java.awt.Color;
import java.util.ArrayList;
import net.hegedus.binocular.util.DrawUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;

public class GuiList {
    private ArrayList<? extends Object> data;
    private int elementHeight;
    private Minecraft mc;
    private FontRenderer font;
    private int xCoord;
    private int yCoord;
    private int width;
    private int height;
    private float scrollPos = 0.0f;
    private int startIndex;

    public GuiList(Minecraft mc, int x, int y, int w, int h, int elementHeight, ArrayList<? extends Object> data, IGuiList handler) {
        this.mc = mc;
        this.font = this.mc.field_71466_p;
        this.xCoord = x;
        this.yCoord = y;
        this.width = w;
        this.height = h;
        this.elementHeight = elementHeight;
        this.data = data;
    }

    public void render(int x, int y) {
        DrawUtils.setFontRenderer(this.font);
        DrawUtils.drawRect(this.xCoord, this.yCoord, this.width, this.height, Color.yellow);
        ScaledResolution sr = new ScaledResolution(this.mc);
        int scale = sr.func_78325_e();
        int scissorX = this.xCoord;
        int scissorY = this.yCoord;
        int scissorWidth = this.width;
        int scissorHeight = this.height;
        DrawUtils.startClip(this.xCoord, this.mc.field_71440_d - (scissorY + scissorHeight) * scale, (scissorWidth + scissorX) * scale, scissorHeight * scale);
        int padding = 5;
        boolean offset = false;
        for (int i = 0; i < this.data.size(); ++i) {
            Object o = this.data.get(i);
            int iY = this.yCoord + padding + i * (this.elementHeight + padding);
            DrawUtils.drawRect(this.xCoord, iY - padding, this.width, this.elementHeight, Color.red);
            DrawUtils.drawText(o.toString(), this.xCoord + padding, iY, Color.white.getRGB());
        }
        DrawUtils.endClip();
    }

    public static interface IGuiList {
        public void onElementDoubleClick(GuiList var1, Object var2, int var3);
    }
}

