/*
 * Decompiled with CFR 0.152.
 */
package net.hegedus.binocular.renderer;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hegedus.binocular.Binocular;
import net.hegedus.binocular.items.BinocularItem;
import net.hegedus.binocular.util.DrawUtils;
import net.hegedus.binocular.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiOverlay
extends Gui {
    private Minecraft mc;
    private FontRenderer font;
    private double ovWidth;
    private double ovHeight;
    private double ovChangeRatio;
    private static final List<RenderGameOverlayEvent.ElementType> BLOCKED_ELEMENT_TYPES = Arrays.asList(RenderGameOverlayEvent.ElementType.ARMOR, RenderGameOverlayEvent.ElementType.EXPERIENCE, RenderGameOverlayEvent.ElementType.FOOD, RenderGameOverlayEvent.ElementType.HEALTH, RenderGameOverlayEvent.ElementType.HEALTHMOUNT, RenderGameOverlayEvent.ElementType.AIR);

    public GuiOverlay(Minecraft mc) {
        this.mc = mc;
        this.font = this.mc.field_71466_p;
        this.mc.field_71460_t.func_78478_c();
        DrawUtils.setFontRenderer(this.font);
    }

    @SubscribeEvent
    public void renderScreen(RenderGameOverlayEvent.Post event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        try {
            Utils.initConfig();
            boolean bShowOverlay = Binocular.itemBinocular.isUsing();
            if (!bShowOverlay && this.mc.field_71439_g.func_184587_cr() && this.mc.field_71439_g.func_184607_cu().func_77973_b() == Binocular.itemBinocular) {
                bShowOverlay = true;
                System.out.println("[renderScreen] Showing Overlay");
            }
            if (!bShowOverlay) {
                bShowOverlay = this.getZoomLock();
            }
            if (bShowOverlay) {
                this.init();
                this.overlay();
                this.infos(false);
                this.compass();
            } else {
                Binocular.itemBinocular.resetUse();
                if (Binocular.itemBinocular.quickInfo) {
                    this.infos(true);
                }
            }
        }
        catch (Exception e) {
            System.out.println("[renderScreen] " + e.getMessage());
        }
    }

    private String compass() {
        String direction = "";
        try {
            int yaw = (int)this.mc.field_71439_g.field_70177_z;
            if (yaw < 0) {
                yaw += 360;
            }
            int facing = (yaw %= 360) / 45;
            String irany = "";
            switch (facing) {
                case 7: {
                    irany = I18n.func_74838_a((String)"direction.se");
                    break;
                }
                case 0: {
                    irany = I18n.func_74838_a((String)"direction.s");
                    break;
                }
                case 1: {
                    irany = I18n.func_74838_a((String)"direction.sw");
                    break;
                }
                case 2: {
                    irany = I18n.func_74838_a((String)"direction.w");
                    break;
                }
                case 3: {
                    irany = I18n.func_74838_a((String)"direction.nw");
                    break;
                }
                case 4: {
                    irany = I18n.func_74838_a((String)"direction.n");
                    break;
                }
                case 5: {
                    irany = I18n.func_74838_a((String)"direction.ne");
                    break;
                }
                case 6: {
                    irany = I18n.func_74838_a((String)"direction.e");
                }
            }
            direction = irany;
        }
        catch (Exception e) {
            System.out.println("compass: " + e.getMessage());
        }
        return direction;
    }

    private boolean getZoomLock() {
        boolean bRet = false;
        try {
            InventoryPlayer inventory = this.mc.field_71439_g.field_71071_by;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack curStack = inventory.func_70301_a(i);
                if (curStack == null || !(curStack.func_77973_b() instanceof BinocularItem)) continue;
                bRet = ((BinocularItem)curStack.func_77973_b()).zoomLocked;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bRet;
    }

    protected String getTime() {
        String time = "";
        try {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server.field_71305_c.length > 0) {
                time = StringUtils.func_76337_a((int)((int)server.field_71305_c[0].func_72820_D()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return time;
    }

    public static String formatTime(Long time) {
        int hours24 = (int)(time / 1000L + 6L) % 24;
        int hours = hours24 % 12;
        int minutes = (int)((float)time.longValue() / 16.666666f % 60.0f);
        String Time = String.format("%02d:%02d %s", hours < 1 ? 12 : hours, minutes, hours24 < 12 ? "AM" : "PM");
        return Time;
    }

    private void text(String text, int x, int y, int color) {
        DrawUtils.drawText(text, x, y, color);
    }

    private void scaledText(String text, float sizePercent, int x, int y, int color) {
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        if (scaledresolution.func_78325_e() == 1) {
            sizePercent = 1.0f;
        }
        float sizeFactor = 1.0f / sizePercent;
        int new_x = (int)((float)x * sizeFactor);
        int new_y = (int)((float)y * sizeFactor);
        GL11.glPushMatrix();
        GL11.glScalef((float)sizePercent, (float)sizePercent, (float)sizePercent);
        this.text(text, new_x, new_y, color);
        GL11.glPopMatrix();
    }

    private void init() {
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        double ovRatioX = 1.6;
        double ovRatioY = 4.26;
        this.ovWidth = (double)this.mc.field_71443_c / ovRatioX;
        this.ovChangeRatio = 640.0 / this.ovWidth;
        this.ovHeight = 240.0 / this.ovChangeRatio;
        if (scaledHeight > scaledWidth) {
            this.ovHeight = (double)this.mc.field_71440_d / ovRatioY;
            this.ovChangeRatio = 240.0 / this.ovHeight;
            this.ovWidth = 640.0 / this.ovChangeRatio;
        }
    }

    private void infos(boolean quickInfo) {
        String sElementPos;
        String sElementName;
        String sCompass;
        String sCurrentTime;
        String sPlayerPos;
        double compassPosY;
        double compassPosX;
        double destCPosY;
        double destPosY;
        double destPosX;
        double locPosY;
        double locPosX;
        double timePosY;
        double timePosX;
        double distPosY;
        double distPosX;
        double zoomPosY;
        double zoomPosX;
        double dist;
        DecimalFormat dfDist;
        int centerY;
        int centerX;
        block24: {
            this.mc.field_71460_t.func_78478_c();
            ScaledResolution scaledresolution = new ScaledResolution(this.mc);
            int scaledWidth = scaledresolution.func_78326_a();
            int scaledHeight = scaledresolution.func_78328_b();
            int scaleFactor = scaledresolution.func_78325_e();
            centerX = scaledWidth / 2;
            centerY = scaledHeight / 2;
            DecimalFormat dfPos = new DecimalFormat("0.0000");
            dfDist = new DecimalFormat("0.##");
            DecimalFormat df2 = new DecimalFormat("0.00");
            dist = 0.0;
            int zoomOfsX = 88;
            int zoomOfsY = 94;
            int distOfsX = 37;
            int distOfsY = 94;
            int timeOfsX = 298;
            int timeOfsY = 105;
            int locOfsX = 15;
            int locOfsY = 15;
            int icoOfsX = 120;
            int icoOfsY = 40;
            int entOfsX = 20;
            int entOfsY = 30;
            int destOfsX = 75;
            int destOfsY = 40;
            int destCOfsY = 20;
            if (scaleFactor > 2) {
                zoomOfsX -= 2;
                distOfsX += 3;
                icoOfsX = 180;
                icoOfsY = 60;
                destOfsX = 120;
                destOfsY = 55;
                destCOfsY = 25;
            }
            if (scaleFactor == 4) {
                icoOfsX = 240;
                icoOfsY = 70;
                destOfsX = 150;
                destOfsY = 60;
                destCOfsY = 30;
            }
            zoomPosX = (double)zoomOfsX / this.ovChangeRatio / (double)scaleFactor;
            zoomPosY = (double)zoomOfsY / this.ovChangeRatio / (double)scaleFactor;
            distPosX = (double)distOfsX / this.ovChangeRatio / (double)scaleFactor;
            distPosY = (double)distOfsY / this.ovChangeRatio / (double)scaleFactor;
            timePosX = (double)timeOfsX / this.ovChangeRatio / (double)scaleFactor;
            timePosY = (double)timeOfsY / this.ovChangeRatio / (double)scaleFactor;
            locPosX = (double)centerX - (this.ovWidth / 2.0 - (double)locOfsX) / (double)scaleFactor;
            locPosY = (double)centerY + (this.ovHeight / 2.0 + (double)locOfsY) / (double)scaleFactor;
            double icoPosX = centerX - icoOfsX / scaleFactor;
            double icoPosY = (double)centerY - (this.ovHeight / 2.0 + (double)icoOfsY) / (double)scaleFactor;
            destPosX = centerX - destOfsX / scaleFactor;
            destPosY = (double)centerY - (this.ovHeight / 2.0 + (double)destOfsY) / (double)scaleFactor;
            destCPosY = (double)centerY - (this.ovHeight / 2.0 + (double)destOfsY - (double)destCOfsY) / (double)scaleFactor;
            compassPosX = (int)((double)centerX - timePosX);
            compassPosY = destCPosY;
            double px = this.mc.func_175606_aa().field_70165_t;
            double py = this.mc.func_175606_aa().func_174813_aQ().field_72338_b;
            double pz = this.mc.func_175606_aa().field_70161_v;
            sPlayerPos = String.format("XYZ: %.3f / %.5f / %.3f", px, py, pz);
            sCurrentTime = "";
            try {
                Long time = this.mc.field_71441_e.field_73011_w.getWorldTime();
                sCurrentTime = GuiOverlay.formatTime(time);
            }
            catch (Exception time) {
                // empty catch block
            }
            sCompass = this.compass();
            sElementName = "";
            sElementPos = "";
            String sElementInfo = "";
            try {
                RayTraceResult mp = this.getMouseOverExtended(this.mc, 1000.0f);
                if (mp == null) break block24;
                BlockPos pos = mp.func_178782_a();
                if (mp.field_72313_a == RayTraceResult.Type.ENTITY) {
                    pos = new BlockPos(mp.field_72307_f.field_72450_a, mp.field_72307_f.field_72448_b, mp.field_72307_f.field_72449_c);
                    EntityLiving entity = this.GetEntityLookAt(this.mc, 1000);
                    if (entity != null) {
                        sElementPos = String.format("x:%s, y:%s, z:%s", dfPos.format(entity.field_70165_t), dfPos.format(entity.field_70163_u), dfPos.format(entity.field_70161_v));
                        sElementInfo = " \u00a77(\u00a7a" + Integer.toString((int)entity.func_110138_aP()) + "\u00a77" + "/" + "\u00a7a" + Integer.toString((int)entity.func_110143_aJ()) + "\u00a77" + ")" + "\u00a7f";
                        sElementName = entity.toString();
                        if (sElementName.indexOf("['") > -1 && (sElementName = sElementName.substring(sElementName.indexOf("['") + 2)).indexOf("'") > -1) {
                            sElementName = sElementName.substring(0, sElementName.indexOf("'"));
                        }
                        if (!quickInfo) {
                            GL11.glPushAttrib((int)1048575);
                            GL11.glPushMatrix();
                            RenderLiving renderLiving = (RenderLiving)Minecraft.func_71410_x().func_175598_ae().func_78715_a(entity.getClass());
                            GL11.glTranslatef((float)((int)icoPosX + entOfsX), (float)((int)icoPosY + entOfsY), (float)0.0f);
                            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            GL11.glScaled((double)25.0, (double)25.0, (double)25.0);
                            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                            renderLiving.func_76986_a(entity, 1.0, 1.0, 1.0, 0.0f, 0.0f);
                            GL11.glPopMatrix();
                            GL11.glPopAttrib();
                        }
                        int xp_width = (int)(entity.func_110143_aJ() / entity.func_110138_aP()) * 50;
                        sElementName = sElementName + sElementInfo;
                    } else {
                        System.out.println("[entity not found]");
                    }
                } else {
                    IBlockState state = this.mc.field_71439_g.field_70170_p.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    sElementName = block.func_149732_F();
                    if (sElementName.endsWith(".name")) {
                        sElementName = block.func_149739_a().substring(block.func_149739_a().indexOf(".") + 1);
                    }
                    if (!quickInfo && !sElementName.equals("air")) {
                        try {
                            ItemStack itemStack = new ItemStack(block);
                            GlStateManager.func_179123_a();
                            GlStateManager.func_179094_E();
                            this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                            if (itemStack.func_77973_b() != null) {
                                IBakedModel bakedModel = this.mc.func_175599_af().func_175037_a().func_178089_a(itemStack);
                                GlStateManager.func_179137_b((double)(icoPosX + 8.0), (double)(icoPosY + 8.0), (double)this.field_73735_i);
                                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                                GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)1.0f);
                                Minecraft.func_71410_x().func_175599_af().func_180454_a(new ItemStack(block), bakedModel);
                            } else {
                                IBlockState blockState = this.mc.field_71441_e.func_180495_p(pos);
                                IBakedModel bakedModel = this.mc.func_175602_ab().func_184389_a(blockState);
                                Tessellator tessellator = Tessellator.func_178181_a();
                                GlStateManager.func_179137_b((double)(icoPosX + 16.0), (double)(icoPosY + 16.0), (double)this.field_73735_i);
                                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                                GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)1.0f);
                                tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176599_b);
                                Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_187493_a((IBlockAccess)this.mc.field_71439_g.field_70170_p, bakedModel, blockState, new BlockPos(0, 0, 0), tessellator.func_178180_c(), false, 0L);
                                tessellator.func_78381_a();
                            }
                            GlStateManager.func_179099_b();
                            GlStateManager.func_179121_F();
                        }
                        catch (Exception ei) {
                            System.out.println("[renderIcon] [" + sElementName + "] err: " + ei.getMessage());
                        }
                    }
                }
                sElementPos = String.format("x:%d y:%d z:%d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                double dx = (double)pos.func_177958_n() - px;
                double dy = (double)pos.func_177956_o() - py;
                double dz = (double)pos.func_177952_p() - pz;
                dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
            }
            catch (Exception mp) {
                // empty catch block
            }
        }
        String sDistance = (dist < 5.0 ? "< 5" : dfDist.format(dist)) + "m";
        float zoomFactor = Binocular.itemBinocular.zoomFactor;
        zoomFactor = 100.0f - zoomFactor * 100.0f;
        if (quickInfo) {
            String sInfo = sCurrentTime;
            if (sCompass != "") {
                sInfo = sInfo + ", " + sCompass;
            }
            if (sElementName != "") {
                sInfo = sInfo + ", \u00a7e" + sElementName + "\u00a7f";
            }
            if (sElementPos != "") {
                sInfo = sInfo + "\u00a77 [\u00a7f" + sElementPos + "\u00a77" + "]" + "\u00a7f";
            }
            if (sDistance != "") {
                sInfo = sInfo + " " + sDistance;
            }
            this.scaledText(sInfo, 0.75f, 5, 5, Color.white.getRGB());
        } else {
            this.scaledText(I18n.func_74838_a((String)"zoom.in") + ": F", 0.75f, 10, 10, Color.white.getRGB());
            this.scaledText(I18n.func_74838_a((String)"zoom.out") + ": V", 0.75f, 10, 20, Color.white.getRGB());
            this.scaledText(I18n.func_74838_a((String)"zoom.reset") + ": R", 0.75f, 10, 30, Color.white.getRGB());
            this.scaledText(I18n.func_74838_a((String)"zoom.lock") + ": L", 0.75f, 10, 40, Color.white.getRGB());
            this.scaledText(I18n.func_74838_a((String)"zoom.nightvision") + ": N", 0.75f, 10, 50, Color.white.getRGB());
            this.scaledText(I18n.func_74838_a((String)"zoom.waypoints") + ": P", 0.75f, 10, 60, Color.white.getRGB());
            this.scaledText(I18n.func_74838_a((String)"zoom.quickInfo") + ": I", 0.75f, 10, 70, Color.white.getRGB());
            this.scaledText(sPlayerPos, 0.75f, (int)locPosX, (int)locPosY, Color.white.getRGB());
            this.scaledText(sCurrentTime, 0.75f, (int)((double)centerX - timePosX), (int)((double)centerY - timePosY), Color.white.getRGB());
            this.scaledText(sCompass, 0.75f, (int)compassPosX, (int)compassPosY, Color.white.getRGB());
            this.scaledText(sDistance, 0.75f, (int)((double)centerX + distPosX), (int)((double)centerY + distPosY), Color.green.getRGB());
            this.scaledText(dfDist.format(zoomFactor), 0.75f, (int)((double)centerX - zoomPosX), (int)((double)centerY + zoomPosY), Color.green.getRGB());
            this.scaledText(sElementName, 0.75f, (int)destPosX, (int)destPosY, Color.yellow.getRGB());
            this.scaledText(sElementPos, 0.75f, (int)destPosX, (int)destCPosY, Color.white.getRGB());
        }
    }

    public static void pre(double x, double y, double z) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
    }

    public static void post() {
        GlStateManager.func_179084_k();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    private void test() {
        DecimalFormat dfPos = new DecimalFormat("0.0000");
        RayTraceResult mop = this.getMouseOverExtended(this.mc, 100.0f);
        if (mop != null) {
            BlockPos pos = new BlockPos(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b - 1.0, mop.field_72307_f.field_72449_c);
            IBlockState state = this.mc.field_71439_g.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            String sElementPos = "x: " + dfPos.format(pos.func_177958_n()) + ", y: " + dfPos.format(pos.func_177956_o()) + ", z: " + dfPos.format(pos.func_177952_p());
            String sElementName = block.func_149732_F();
            if (sElementName.endsWith(".name")) {
                sElementName = block.func_149739_a().substring(block.func_149739_a().indexOf(".") + 1);
            }
            System.out.println("[block] " + sElementName + " " + sElementPos);
        }
    }

    public static List GetNearEntityWithPlayer(EntityLivingBase player, int range, boolean needToBeSeen) {
        double px = player.field_70165_t;
        double py = player.field_70163_u;
        double pz = player.field_70161_v;
        BlockPos posMin = new BlockPos(px - (double)range, py - (double)range, pz - (double)range);
        BlockPos posMax = new BlockPos(px + (double)range, py + (double)range, pz + (double)range);
        AxisAlignedBB boundingBox = new AxisAlignedBB(posMin, posMax);
        List l = player.field_70170_p.func_72872_a(EntityLivingBase.class, boundingBox);
        ArrayList<EntityLivingBase> result = new ArrayList<EntityLivingBase>();
        for (int i = 0; i < l.size(); ++i) {
            EntityLivingBase x = (EntityLivingBase)l.get(i);
            if (x == null || !(x.func_70032_d((Entity)player) <= (float)range) || needToBeSeen && !x.func_70685_l((Entity)player)) continue;
            result.add(x);
        }
        return result;
    }

    public EntityLiving GetEntityLookAt(Minecraft mc, int max_dis) {
        RayTraceResult mop = this.getMouseOverExtended(mc, max_dis);
        if (mop != null && mop.field_72308_g != null && mop.field_72308_g.field_70172_ad == 0 && mop.field_72308_g != mc.field_71439_g) {
            return (EntityLiving)mop.field_72308_g;
        }
        return null;
    }

    public RayTraceResult getMouseOverExtended(Minecraft mc, float dist) {
        Entity theRenderViewEntity = mc.func_175606_aa();
        AxisAlignedBB theViewBoundingBox = new AxisAlignedBB(theRenderViewEntity.field_70165_t - 0.5, theRenderViewEntity.field_70163_u - 0.0, theRenderViewEntity.field_70161_v - 0.5, theRenderViewEntity.field_70165_t + 0.5, theRenderViewEntity.field_70163_u + 1.5, theRenderViewEntity.field_70161_v + 0.5);
        RayTraceResult returnMOP = null;
        if (mc.field_71441_e != null) {
            double var2 = dist;
            returnMOP = theRenderViewEntity.func_174822_a(var2, 0.0f);
            double calcdist = var2;
            Vec3d pos = theRenderViewEntity.func_174824_e(0.0f);
            var2 = calcdist;
            if (returnMOP != null) {
                calcdist = returnMOP.field_72307_f.func_72438_d(pos);
            }
            Vec3d lookvec = theRenderViewEntity.func_70676_i(0.0f);
            Vec3d var8 = pos.func_72441_c(lookvec.field_72450_a * var2, lookvec.field_72448_b * var2, lookvec.field_72449_c * var2);
            Entity pointedEntity = null;
            float var9 = 1.0f;
            List list = mc.field_71441_e.func_72839_b(theRenderViewEntity, theViewBoundingBox.func_72321_a(lookvec.field_72450_a * var2, lookvec.field_72448_b * var2, lookvec.field_72449_c * var2).func_72314_b((double)var9, (double)var9, (double)var9));
            double d = calcdist;
            for (Entity entity : list) {
                double d1;
                if (!entity.func_70067_L()) continue;
                float bordersize = entity.func_70111_Y();
                AxisAlignedBB aabb = new AxisAlignedBB(entity.field_70165_t - (double)(entity.field_70130_N / 2.0f), entity.field_70163_u, entity.field_70161_v - (double)(entity.field_70130_N / 2.0f), entity.field_70165_t + (double)(entity.field_70130_N / 2.0f), entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v + (double)(entity.field_70130_N / 2.0f));
                aabb.func_72314_b((double)bordersize, (double)bordersize, (double)bordersize);
                RayTraceResult mop0 = aabb.func_72327_a(pos, var8);
                if (aabb.func_72318_a(pos)) {
                    if (!(0.0 < d) && d != 0.0) continue;
                    pointedEntity = entity;
                    d = 0.0;
                    continue;
                }
                if (mop0 == null || !((d1 = pos.func_72438_d(mop0.field_72307_f)) < d) && d != 0.0) continue;
                pointedEntity = entity;
                d = d1;
            }
            if (pointedEntity != null && (d < calcdist || returnMOP == null)) {
                returnMOP = new RayTraceResult(pointedEntity);
            }
        }
        return returnMOP;
    }

    public void overlay() {
        this.mc.field_71460_t.func_78478_c();
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        int scaleFactor = scaledresolution.func_78325_e();
        int centerX = scaledWidth / 2;
        int centerY = scaledHeight / 2;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        ResourceLocation texture = new ResourceLocation("binocular", "textures/items/BinocularBlur.png");
        this.mc.func_110434_K().func_110577_a(texture);
        boolean isHorizontal = true;
        double aspect_ratio = 1.0;
        int w = scaledWidth;
        int h = scaledWidth;
        int ofs_x = 0;
        int ofs_y = 0;
        if (h < scaledHeight) {
            h = scaledHeight;
            w = (int)((double)scaledHeight * aspect_ratio);
            isHorizontal = false;
        }
        if (w > scaledWidth) {
            ofs_x = (w - scaledWidth) / 2;
        }
        if (h > scaledHeight) {
            ofs_y = (h - scaledHeight) / 2;
        }
        int tl_x = 0 - ofs_x;
        int tl_y = 0 - ofs_y;
        int bl_x = 0 - ofs_x;
        int bl_y = h - ofs_y;
        int br_x = w - ofs_x;
        int br_y = h - ofs_y;
        int tr_x = w - ofs_x;
        int tr_y = 0 - ofs_y;
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = t.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)tl_x, (double)tl_y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)bl_x, (double)bl_y, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)br_x, (double)br_y, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)tr_x, (double)tr_y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        t.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }
}

