/*
 * Decompiled with CFR 0.152.
 */
package net.hegedus.binocular.util;

import java.awt.Color;
import java.awt.Font;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;

public class DrawUtils {
    private static float LINE_WIDTH = 1.0f;
    private static Font FONT = new Font("SansSerif", 0, 10);
    private static FontRenderer font;
    private static ScaledResolution resolution;

    public static void setFont(Font f) {
        FONT = f;
    }

    public static Font getFont() {
        return FONT;
    }

    public static void setResolution(ScaledResolution sr) {
        resolution = sr;
    }

    public static void setFontRenderer(FontRenderer fr) {
        font = fr;
    }

    public static void drawText(String text, int x, int y, int color) {
        font.func_78276_b(text, x, y, color);
    }

    public static void scaledText(String text, float sizePercent, int x, int y, int color) {
        if (resolution.func_78325_e() == 1) {
            sizePercent = 1.0f;
        }
        float sizeFactor = 1.0f / sizePercent;
        int new_x = (int)((float)x * sizeFactor);
        int new_y = (int)((float)y * sizeFactor);
        GL11.glPushMatrix();
        GL11.glScalef((float)sizePercent, (float)sizePercent, (float)sizePercent);
        font.func_78276_b(text, x, y, color);
        GL11.glPopMatrix();
    }

    public static void drawRect(int x, int y, int width, int height, Color color) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)DrawUtils.getR(color), (float)DrawUtils.getG(color), (float)DrawUtils.getB(color), (float)DrawUtils.getA(color));
        GL11.glLineWidth((float)LINE_WIDTH);
        GL11.glBegin((int)2);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glVertex2i((int)(x + width), (int)y);
        GL11.glVertex2i((int)(x + width), (int)(y + height));
        GL11.glVertex2i((int)x, (int)(y + height));
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static void fillRect(int x, int y, int width, int height, Color color) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)DrawUtils.getR(color), (float)DrawUtils.getG(color), (float)DrawUtils.getB(color), (float)DrawUtils.getA(color));
        GL11.glBegin((int)7);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glVertex2i((int)(x + width), (int)y);
        GL11.glVertex2i((int)(x + width), (int)(y + height));
        GL11.glVertex2i((int)x, (int)(y + height));
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static void startClip(int x, int y, int width, int height) {
        GL11.glEnable((int)3089);
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    public static void endClip() {
        GL11.glDisable((int)3089);
    }

    public static float getR(Color color) {
        return (float)color.getRed() / 255.0f;
    }

    public static float getG(Color color) {
        return (float)color.getGreen() / 255.0f;
    }

    public static float getB(Color color) {
        return (float)color.getBlue() / 255.0f;
    }

    public static float getA(Color color) {
        return (float)color.getAlpha() / 255.0f;
    }
}

