Scriptname TempestMagicCycloneHitScript extends activemagiceffect  

import Utility

Int indexSound
Int indexHit

Float Damage

Sound Property TempestSoundCycloneHit01 Auto
Sound Property TempestSoundCycloneHit02 Auto
Sound Property TempestSoundCycloneHit03 Auto
Sound Property TempestSoundCycloneHit04 Auto
Sound Property TempestSoundCycloneHit05 Auto
Sound Property TempestSoundCycloneHit06 Auto

VisualEffect Property TempestVisualEffectCycloneHit01 Auto
VisualEffect Property TempestVisualEffectCycloneHit02 Auto
VisualEffect Property TempestVisualEffectCycloneHit03 Auto
VisualEffect Property TempestVisualEffectCycloneHit04 Auto

Faction Property faction01  Auto  

GlobalVariable Property TempestDamageRate  Auto  

Event OnEffectStart(Actor Target, Actor Caster)

	Actor PlayerActor = Game.GetPlayer()

	if !Target.IsInFaction(faction01) && !Target.IsDead()

		if !Target.IsHostileToActor(PlayerActor)
			return
		endif

		indexSound = RandomInt(1,6)

		if indexSound == 1
			TempestSoundCycloneHit01.play(Caster)  
		elseif indexSound == 2
			TempestSoundCycloneHit02.play(Caster)
		elseif indexSound == 3
			TempestSoundCycloneHit03.play(Caster)
		elseif indexSound == 4
			TempestSoundCycloneHit04.play(Caster)
		elseif indexSound == 5
			TempestSoundCycloneHit05.play(Caster)
		else
			TempestSoundCycloneHit06.play(Caster)
		endif

		if Caster.getav("oneHanded") as float > Caster.getav("twoHanded") as float
			Damage =  Caster.getav("oneHanded") as float
		else
			Damage =  Caster.getav("twoHanded") as float
		endif

		Damage *= 0.4
		Damage *= TempestDamageRate.getValue()

		Target.DamageAv("Health", Damage)

		indexHit = RandomInt(1,4)

		if indexHit == 1
			TempestVisualEffectCycloneHit01.play(Target,0.3)
		elseif indexHit == 2
			TempestVisualEffectCycloneHit02.play(Target,0.3)
		elseif indexHit == 3
			TempestVisualEffectCycloneHit03.play(Target,0.3)
		else
			TempestVisualEffectCycloneHit04.play(Target,0.3)
		endif

		Target.StartCombat(Caster)

	endif

EndEvent
