Scriptname TempestMagicTempestScript extends activemagiceffect  

import Math
import Utility

float xMove
float yMove
float rXMove
float rYMove

; initial position vector
float xPos
float yPos
float zPos

float zAng 

int Fx
Int index
Int indexDimension
Int indexSound
Int indexSlash
Int indexBullet

Spell Property TempestSpellCycloneHit Auto
Spell Property TempestSpellTempestPierce Auto
Spell Property TempestSpellDimension01 Auto
Spell Property TempestSpellDimension02 Auto
Spell Property TempestSpellDimension03 Auto
Spell Property TempestSpellDimension04 Auto

Sound Property TempestSoundFemale01 Auto
Sound Property TempestSoundFemale02 Auto
Sound Property TempestSoundFemale03 Auto
Sound Property TempestSoundFemale04 Auto
Sound Property TempestSoundFemale05 Auto

Sound Property TempestSoundMale01 Auto
Sound Property TempestSoundMale02 Auto
Sound Property TempestSoundMale03 Auto
Sound Property TempestSoundMale04 Auto
Sound Property TempestSoundMale05 Auto

Sound Property TempestSoundTempestBegin Auto

Idle Property Tempest_Attack Auto
Idle Property Tempest_Idle Auto

Perk Property TempestPerkResetFallDamage  Auto

Activator Property TempestActivatorAirWalk  Auto
Activator Property TempestActivatorSlashDimension  Auto
ObjectReference SlashDimension

ObjectReference AirWalk

VisualEffect Property TempestVisualEffectSlash01  Auto
VisualEffect Property TempestVisualEffectSlash02  Auto
VisualEffect Property TempestVisualEffectSlash03  Auto
VisualEffect Property TempestVisualEffectSlash04  Auto
VisualEffect Property TempestVisualEffectSlash05  Auto
VisualEffect Property TempestVisualEffectSlash06  Auto
VisualEffect Property TempestVisualEffectSlash07  Auto
VisualEffect Property TempestVisualEffectSlash08  Auto

Message Property TempestMessageStamina  Auto  

GlobalVariable Property TempestDelay Auto
GlobalVariable Property TempestTrigger Auto
GlobalVariable Property TempestShakeCamera  Auto
GlobalVariable Property TempestShakeXBOX  Auto
GlobalVariable Property TempestRequireStamina  Auto

Event OnEffectStart(Actor Target, Actor Caster)

	if TempestTrigger.getValue() == 0 && Caster.GetAVPercentage("Stamina") >= TempestRequireStamina.getValue()

		Caster.damageAV("Stamina", 9999.0)

		Actor PlayerActor =  Game.GetPlayer()
		ActorBase PlayerBase = Caster.GetBaseObject() as ActorBase

		Caster.AddPerk(TempestPerkResetFallDamage)

		TempestTrigger.setValue(1)

			zAng = Caster.getAngleZ()

			yMove = 280
			xMove = 0

			rXMove = (math.Sin(zAng) * yMove)+(math.Cos(zAng) * xMove)
			rYMove = (math.Cos(zAng) * yMove)-(math.Sin(zAng) * xMove)

			xPos = rXMove
			yPos = rYMove

		Airwalk = Caster.PlaceAtMe(TempestActivatorAirwalk)

		Airwalk.MoveTo(Caster,xPos,yPos,0,True)
		Airwalk.setAngle(0,0,0)

		Airwalk.Activate(PlayerActor)

		wait(0.01)

		;Debug.SendAnimationEvent(Caster, "AttackPowerStartRight")
		;Caster.PlayIdle(Tempest_Attack)

		Debug.SendAnimationEvent(Caster, "ShoutStart")
		Debug.SendAnimationEvent(Caster, "ShoutSprintShortStart")


		Caster.RemovePerk(TempestPerkResetFallDamage)

		if PlayerBase.GetSex() == 0
			indexSound = RandomInt(1,5)

			if indexSound == 1
				TempestSoundMale01.play(Caster)  
			elseif indexSound == 2
				TempestSoundMale02.play(Caster)
			elseif indexSound == 3
				TempestSoundMale03.play(Caster)
			elseif indexSound == 4
				TempestSoundMale04.play(Caster)
			else
				TempestSoundMale05.play(Caster)
			endif
		else
			indexSound = RandomInt(1,5)

			if indexSound == 1
				TempestSoundFemale01.play(Caster)  
			elseif indexSound == 2
				TempestSoundFemale02.play(Caster)
			elseif indexSound == 3
				TempestSoundFemale03.play(Caster)
			elseif indexSound == 4
				TempestSoundFemale04.play(Caster)
			else
				TempestSoundFemale05.play(Caster)
			endif
		endif

		wait(TempestDelay.getValue())
		wait(TempestDelay.getValue())

		Fx = TempestSoundTempestBegin.play(Caster)
		index = 0
		indexBullet = 0
		indexDimension = 0

		if TempestShakeCamera.getValue() == 1
			Game.ShakeCamera(Caster,0.5,4.0)
		endif

		While(TempestTrigger.getValue() == 1) ;Caster.getav("Magicka") as float >= WhirlWindMagicka.getValue() && 

;			indexSlash = RandomInt(1,6)

			index += 1
			index = index % 8

			if index == 1
				TempestVisualEffectSlash01.play(Caster,0.6)
			elseif index == 2
				TempestVisualEffectSlash02.play(Caster,0.6)
			elseif index == 3
				TempestVisualEffectSlash03.play(Caster,0.6)
			elseif index == 4
				TempestVisualEffectSlash04.play(Caster,0.6)
			elseif index == 5
				TempestVisualEffectSlash05.play(Caster,0.6)
			elseif index == 6
				TempestVisualEffectSlash06.play(Caster,0.6)
			elseif index == 7
				TempestVisualEffectSlash07.play(Caster,0.6)
			else
				TempestVisualEffectSlash08.play(Caster,0.6)
			endif

			indexDimension += 1
			indexDimension = indexDimension % 4

			if indexDimension == 1
				TempestSpellDimension01.Cast(Caster)
			elseif indexDimension == 2
				TempestSpellDimension03.Cast(Caster)
			elseif indexDimension == 3
				TempestSpellDimension02.Cast(Caster)
			else
				TempestSpellDimension04.Cast(Caster)
			endif

			TempestSpellCycloneHit.Cast(Caster)
			if TempestShakeXBOX.getValue() == 1
				Game.ShakeController(0.25, 0.25, 0.3)
			endif

			if PlayerBase.GetSex() == 0
				indexSound = RandomInt(1,24)

				if indexSound == 1
					TempestSoundMale01.play(Caster)  
				elseif indexSound == 2
					TempestSoundMale02.play(Caster)
				elseif indexSound == 3
					TempestSoundMale03.play(Caster)
				elseif indexSound == 4
					TempestSoundMale04.play(Caster)
				elseif indexSound == 5
					TempestSoundMale05.play(Caster)
				else
					;none Voice
				endif
			else
				indexSound = RandomInt(1,24)

				if indexSound == 1
					TempestSoundFemale01.play(Caster)  
				elseif indexSound == 2
					TempestSoundFemale02.play(Caster)
				elseif indexSound == 3
					TempestSoundFemale03.play(Caster)
				elseif indexSound == 4
					TempestSoundFemale04.play(Caster)
				elseif indexSound == 5
					TempestSoundFemale05.play(Caster)
				else
					;none Voice
				endif
			endif

			if indexBullet < 13

				zAng = Caster.getAngleZ()

				yMove = 180
				xMove = 0

				rXMove = (math.Sin(zAng) * yMove)+(math.Cos(zAng) * xMove)
				rYMove = (math.Cos(zAng) * yMove)-(math.Sin(zAng) * xMove)

				xPos = rXMove
				yPos = rYMove
				zPos = 108
		
				SlashDimension= PlayerActor.PlaceAtMe(TempestActivatorSlashDimension)

				SlashDimension.MoveTo(Caster,xPos,yPos,zPos,True)
				SlashDimension.setAngle(RandomFloat(-180.0,180.0),RandomFloat(-180.0,180.0),RandomFloat(-180.0,180.0))

				SlashDimension.Activate(PlayerActor)

				indexBullet += 1

			endif 

			wait(TempestDelay.getValue())

;			Caster.DamageAV("Magicka", WhirlWindMagicka.getValue())

;			if Caster.getav("Magicka") as float < WhirlWindMagicka.getValue()
;				Debug.SendAnimationEvent(PlayerActor , "ShoutStop")
;			endif

		endWhile

;		WhirlWindVisualEffect.stop(Caster)
;		WhirlWindTrigger.setValue(0)

	else

		TempestMessageStamina.Show(3.0)

	endif

EndEvent

Event OnEffectFinish(Actor Target, Actor Caster)

	if TempestTrigger.getValue() == 1
		TempestTrigger.setValue(2)
		TempestSpellTempestPierce.Cast(Caster)

		Sound.StopInstance(Fx)

	endif

endEvent
