local assets =
{
    Asset("ANIM", "anim/wc3_sword.zip"),
   	Asset("ANIM", "anim/swap_wc3_sword.zip"),
 Asset("ATLAS", "images/inventoryimages/wc3_sword.xml"),	
}

local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_wc3_sword", "swap_batbat")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold") 
    inst.Light:Enable(true)
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal")
	inst.Light:Enable(false)
end

local function attackeffect(inst, owner, target)
    if owner.components.health and owner.components.health:GetPercent() < 1 and not target:HasTag("wall") then
   -- owner.components.health:DoDelta(TUNING.BATBAT_DRAIN,false,"wc3_sword")
		owner.components.sanity:DoDelta(-3)
	end       
	if target.components.freezable then
		target.components.freezable:AddColdness(1)
		target.components.freezable:SpawnShatterFX()
	end
	if target.components.sleeper and target.components.sleeper:IsAsleep() then
		target.components.sleeper:WakeUp()
	end
	if target.components.burnable and target.components.burnable:IsBurning() then
		target.components.burnable:Extinguish()
	end
	if target.components.combat then
		target.components.combat:SuggestTarget(owner)
		if target.sg and not target.sg:HasStateTag("frozen") and target.sg.sg.states.hit then
			target.sg:GoToState("hit")
		end
	end
end

local function fn(Sim)
    local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)
	 
	local light = inst.entity:AddLight()
	
	inst.AnimState:SetBank("batbat")
    inst.AnimState:SetBuild("wc3_sword")
    inst.AnimState:PlayAnimation("idle")
	inst.AnimState:SetMultColour(1, 1, 1, 1)
	
	inst:AddTag("shadow")
    inst:AddTag("sharp")
	
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(80)
	inst.components.weapon:SetOnAttack(attackeffect)
	
	inst:AddComponent("tool")
	inst.components.tool:SetAction(ACTIONS.CHOP)

	
	inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	   inst.components.inventoryitem.atlasname = "images/inventoryimages/wc3_sword.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    --inst.components.equippable.dapperness = TUNING.CRAZINESS_MED
	
	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.NIGHTSWORD_USES*5)
    inst.components.finiteuses:SetUses(TUNING.NIGHTSWORD_USES*5)
	inst.components.finiteuses:SetConsumption(ACTIONS.CHOP, 0.5)
	
    inst.components.finiteuses:SetOnFinished( onfinished )
	
	local light = inst.entity:AddLight()
	inst.Light:SetRadius(1.5)
    inst.Light:SetFalloff(0.8)
    inst.Light:SetIntensity(.3)
    inst.Light:SetColour(174/255,240/255,240/255)		
    
    return inst
end

return Prefab( "common/inventory/wc3_sword", fn, assets)