/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowlib.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.shadowfacts.shadowlib.util.FileUtils;
import net.shadowfacts.shadowlib.util.IOUtils;

public class ZipUtils {
    public static void zipDir(File folder, File zipFile) throws IOException {
        ZipUtils.zipDir(folder, new FileOutputStream(zipFile));
    }

    public static void zipDir(File folder, OutputStream outputStream) throws IOException {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            ZipUtils.processZipDir(folder, zipOutputStream, folder.getPath().length() + 1);
        }
    }

    private static void processZipDir(File folder, ZipOutputStream zipOutputStream, int prefixLength) throws IOException {
        for (File f : folder.listFiles()) {
            if (f.isFile()) {
                ZipEntry zipEntry = new ZipEntry(f.getPath().substring(prefixLength));
                zipOutputStream.putNextEntry(zipEntry);
                try (FileInputStream inputStream = new FileInputStream(f);){
                    IOUtils.copy(inputStream, zipOutputStream);
                }
                zipOutputStream.closeEntry();
                continue;
            }
            if (!f.isDirectory()) continue;
            ZipUtils.processZipDir(f, zipOutputStream, prefixLength);
        }
    }

    public static void unzipToDir(String zipPath, String outputDirPath) throws IOException {
        FileUtils.checkCreateDir(new File(outputDirPath));
        try (ZipInputStream in = new ZipInputStream(new FileInputStream(zipPath));){
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    String name = entry.getName();
                    File f = new File(outputDirPath + File.separator + name);
                    FileUtils.checkCreateDir(f.getParentFile());
                    try (FileOutputStream out = new FileOutputStream(f);){
                        IOUtils.copy(in, out);
                    }
                }
                entry = in.getNextEntry();
            }
            in.closeEntry();
        }
    }
}

