/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.event;

import java.util.Optional;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.shadowfacts.shadowmc.achievement.AchievementProvider;
import net.shadowfacts.shadowmc.anvil.AnvilManager;
import net.shadowfacts.shadowmc.anvil.AnvilRecipe;
import net.shadowfacts.shadowmc.config.ConfigManager;

public class ShadowMCEventHandler {
    @SubscribeEvent
    public void anvilUpdate(AnvilUpdateEvent event) {
        if (event.getLeft() == null || event.getRight() == null) {
            return;
        }
        Optional<AnvilRecipe> optionalRecipe = AnvilManager.getInstance().getRecipe(event.getLeft(), event.getRight());
        if (optionalRecipe.isPresent()) {
            AnvilRecipe recipe = optionalRecipe.get();
            event.setCost(Math.max(recipe.getXPCost(), 1));
            event.setOutput(recipe.getResult());
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (ConfigManager.instance.getModIdConfigNameMap().containsKey(event.getModID())) {
            String name = ConfigManager.instance.getModIdConfigNameMap().get(event.getModID());
            ConfigManager.instance.load(name);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack result = event.crafting;
        if (result.func_77973_b() instanceof AchievementProvider) {
            ((AchievementProvider)result.func_77973_b()).grantAchievement(event.player, result);
        } else if (result.func_77973_b() instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)result.func_77973_b();
            if (itemBlock.field_150939_a instanceof AchievementProvider) {
                ((AchievementProvider)itemBlock.field_150939_a).grantAchievement(event.player, result);
            }
        }
    }

    @SubscribeEvent
    public void onItemSmelted(PlayerEvent.ItemSmeltedEvent event) {
        ItemStack result = event.smelting;
        if (result.func_77973_b() instanceof AchievementProvider) {
            ((AchievementProvider)result.func_77973_b()).grantAchievement(event.player, result);
        } else if (result.func_77973_b() instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)result.func_77973_b();
            if (itemBlock.field_150939_a instanceof AchievementProvider) {
                ((AchievementProvider)itemBlock.field_150939_a).grantAchievement(event.player, result);
            }
        }
    }
}

