/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.gui.component;

import java.util.function.Supplier;
import net.shadowfacts.shadowmc.gui.component.GUIComponent;
import net.shadowfacts.shadowmc.util.Color;

public class GUIVerticalBarIndicator
extends GUIComponent {
    protected Supplier<Float> levelSupplier;
    protected Color primaryColor = Color.PURE_RED;
    protected Color secondaryColor = Color.DARK_RED;

    public GUIVerticalBarIndicator(int x, int y, int width, int height, Supplier<Float> levelSupplier) {
        super(x, y, width, height);
        this.levelSupplier = levelSupplier;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        float level = this.levelSupplier.get().floatValue();
        int filled = Math.min((int)(level * (float)this.height), this.height);
        this.drawRect(this.x, this.y + (this.height - filled), this.width, filled, this.primaryColor);
        this.drawRect(this.x, this.y, this.width, this.height - filled, this.secondaryColor);
    }

    public GUIVerticalBarIndicator setPrimaryColor(Color primaryColor) {
        this.primaryColor = primaryColor;
        return this;
    }

    public GUIVerticalBarIndicator setSecondaryColor(Color secondaryColor) {
        this.secondaryColor = secondaryColor;
        return this;
    }
}

