/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.nbt;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameData;
import net.shadowfacts.shadowlib.util.Pair;
import net.shadowfacts.shadowmc.fluid.CreativeFluidTank;
import net.shadowfacts.shadowmc.fluid.FluidTank;
import net.shadowfacts.shadowmc.nbt.AutoSerializeNBT;
import net.shadowfacts.shadowmc.nbt.NBTDeserializer;
import net.shadowfacts.shadowmc.nbt.NBTSerializer;
import net.shadowfacts.shadowmc.util.LogHelper;
import net.shadowfacts.shadowmc.util.RedstoneMode;

public class AutoNBTSerializer {
    private static Map<Class, Pair> serializers = new HashMap<Class, Pair>();
    private static LogHelper log = new LogHelper("ShadowMC|AutoNBT");

    public static <T> void registerSerializer(Class<T> clazz, NBTSerializer<T> serializer, NBTDeserializer<T> deserializer) {
        serializers.put(clazz, new Pair<NBTSerializer<T>, NBTDeserializer<T>>(serializer, deserializer));
    }

    public static <T> Pair<NBTSerializer<T>, NBTDeserializer<T>> getSerializersFor(Class<T> clazz) {
        return serializers.get(clazz);
    }

    public static <T> NBTSerializer<T> getSerializerFor(Class<T> clazz) {
        return AutoNBTSerializer.getSerializersFor(clazz).getLeft();
    }

    public static <T> NBTDeserializer<T> getDeserializerFor(Class<T> clazz) {
        return AutoNBTSerializer.getSerializersFor(clazz).getRight();
    }

    public static NBTTagCompound serialize(Class<?> clazz, Object instance) {
        return AutoNBTSerializer.serialize(clazz, instance, new NBTTagCompound());
    }

    public static NBTTagCompound serialize(Class<?> clazz, Object instance, NBTTagCompound tag) {
        Arrays.stream(clazz.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> f.isAnnotationPresent(AutoSerializeNBT.class) || clazz.isAnnotationPresent(AutoSerializeNBT.class)).forEach(f -> {
            try {
                NBTSerializer<?> serializer = AutoNBTSerializer.getSerializerFor(f.getType());
                f.setAccessible(true);
                serializer.serialize(tag, f.getName(), f.get(instance));
            }
            catch (ReflectiveOperationException e) {
                log.error("Couldn't serialize %s in %s", f.getName(), clazz.getName());
                e.printStackTrace();
            }
        });
        return tag;
    }

    public static void deserialize(Class<?> clazz, Object instance, NBTTagCompound tag) {
        Arrays.stream(clazz.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> f.isAnnotationPresent(AutoSerializeNBT.class) || clazz.isAnnotationPresent(AutoSerializeNBT.class)).forEach(f -> {
            try {
                NBTDeserializer<?> deserializer = AutoNBTSerializer.getDeserializerFor(f.getType());
                f.setAccessible(true);
                f.set(instance, deserializer.deserialize(tag, f.getName()));
            }
            catch (ReflectiveOperationException e) {
                log.error("Couldn't deserialize %s in %s", f.getName(), clazz.getName());
                e.printStackTrace();
            }
        });
    }

    private static void serializeItemStack(NBTTagCompound tag, String name, ItemStack val) {
        if (val != null) {
            NBTTagCompound stackTag = new NBTTagCompound();
            val.func_77955_b(stackTag);
            tag.func_74782_a(name, (NBTBase)stackTag);
        }
    }

    private static ItemStack deserializeItemStack(NBTTagCompound tag, String name) {
        return tag.func_74764_b(name) ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(name)) : null;
    }

    private static void serializeItemStackArray(NBTTagCompound tag, String name, ItemStack[] val) {
        NBTTagList tagList = new NBTTagList();
        for (ItemStack stack : val) {
            NBTTagCompound stackTag = new NBTTagCompound();
            stack.func_77955_b(stackTag);
            tagList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a(name, (NBTBase)tagList);
    }

    private static ItemStack[] deserializeItemStackArray(NBTTagCompound tag, String name) {
        NBTTagList tagList = tag.func_150295_c(name, 10);
        ItemStack[] stacks = new ItemStack[tagList.func_74745_c()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            stacks[i] = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i));
        }
        return stacks;
    }

    private static void serializeEnumFacing(NBTTagCompound tag, String name, EnumFacing val) {
        tag.func_74768_a(name, val.func_176745_a());
    }

    private static EnumFacing deserializeEnumFacing(NBTTagCompound tag, String name) {
        return EnumFacing.func_82600_a((int)tag.func_74762_e(name));
    }

    private static void serializeBlockPos(NBTTagCompound tag, String name, BlockPos val) {
        tag.func_74772_a(name, val.func_177986_g());
    }

    private static BlockPos deserializeBlockPos(NBTTagCompound tag, String name) {
        return BlockPos.func_177969_a((long)tag.func_74763_f(name));
    }

    private static void serializeRedstoneMode(NBTTagCompound tag, String name, RedstoneMode val) {
        tag.func_74768_a(name, val.ordinal());
    }

    private static RedstoneMode deserializeRedstoneMode(NBTTagCompound tag, String name) {
        return RedstoneMode.values()[tag.func_74762_e(name)];
    }

    private static void serializeBlock(NBTTagCompound tag, String name, Block val) {
        tag.func_74778_a(name, GameData.getBlockRegistry().getNameForObject((Object)val).toString());
    }

    private static Block deserializeBlock(NBTTagCompound tag, String name) {
        return (Block)GameData.getBlockRegistry().getObject(new ResourceLocation(tag.func_74779_i(name)));
    }

    private static void serializeItem(NBTTagCompound tag, String name, Item val) {
        tag.func_74778_a(name, GameData.getItemRegistry().getNameForObject((Object)val).toString());
    }

    private static Item deserializeItem(NBTTagCompound tag, String name) {
        return (Item)GameData.getItemRegistry().getObject(new ResourceLocation(tag.func_74779_i(name)));
    }

    private static void serializeFluidStack(NBTTagCompound tag, String name, FluidStack val) {
        NBTTagCompound stackTag = new NBTTagCompound();
        val.writeToNBT(stackTag);
        tag.func_74782_a(name, (NBTBase)stackTag);
    }

    private static FluidStack deserializeFluidStack(NBTTagCompound tag, String name) {
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l(name));
    }

    private static void serializeFluid(NBTTagCompound tag, String name, Fluid val) {
        tag.func_74778_a(name, FluidRegistry.getFluidName((Fluid)val));
    }

    private static Fluid deserializeFluid(NBTTagCompound tag, String name) {
        return FluidRegistry.getFluid((String)tag.func_74779_i(name));
    }

    private static void serializeFluidTank(NBTTagCompound tag, String name, FluidTank val) {
        NBTTagCompound tankTag = new NBTTagCompound();
        val.writeToNBT(tankTag);
        tag.func_74782_a(name, (NBTBase)tankTag);
    }

    private static FluidTank deserializeFluidTank(NBTTagCompound tag, String name) {
        return new FluidTank(0).readFromNBT(tag.func_74775_l(name));
    }

    private static void serializeCreativeFluidTank(NBTTagCompound tag, String name, CreativeFluidTank val) {
        NBTTagCompound tankTag = new NBTTagCompound();
        val.writeToNBT(tankTag);
        tag.func_74782_a(name, (NBTBase)tankTag);
    }

    private static CreativeFluidTank deserializeCreativeFluidTank(NBTTagCompound tag, String name) {
        return (CreativeFluidTank)new CreativeFluidTank(0).readFromNBT(tag.func_74775_l(name));
    }

    static {
        AutoNBTSerializer.registerSerializer(NBTBase.class, NBTTagCompound::func_74782_a, NBTTagCompound::func_74781_a);
        AutoNBTSerializer.registerSerializer(Byte.TYPE, NBTTagCompound::func_74774_a, NBTTagCompound::func_74771_c);
        AutoNBTSerializer.registerSerializer(Short.TYPE, NBTTagCompound::func_74777_a, NBTTagCompound::func_74765_d);
        AutoNBTSerializer.registerSerializer(Integer.TYPE, NBTTagCompound::func_74768_a, NBTTagCompound::func_74762_e);
        AutoNBTSerializer.registerSerializer(Long.TYPE, NBTTagCompound::func_74772_a, NBTTagCompound::func_74763_f);
        AutoNBTSerializer.registerSerializer(Float.TYPE, NBTTagCompound::func_74776_a, NBTTagCompound::func_74760_g);
        AutoNBTSerializer.registerSerializer(Double.TYPE, NBTTagCompound::func_74780_a, NBTTagCompound::func_74769_h);
        AutoNBTSerializer.registerSerializer(String.class, NBTTagCompound::func_74778_a, NBTTagCompound::func_74779_i);
        AutoNBTSerializer.registerSerializer(byte[].class, NBTTagCompound::func_74773_a, NBTTagCompound::func_74770_j);
        AutoNBTSerializer.registerSerializer(int[].class, NBTTagCompound::func_74783_a, NBTTagCompound::func_74759_k);
        AutoNBTSerializer.registerSerializer(NBTTagCompound.class, NBTTagCompound::func_74782_a, NBTTagCompound::func_74775_l);
        AutoNBTSerializer.registerSerializer(Boolean.TYPE, NBTTagCompound::func_74757_a, NBTTagCompound::func_74767_n);
        AutoNBTSerializer.registerSerializer(ItemStack.class, AutoNBTSerializer::serializeItemStack, AutoNBTSerializer::deserializeItemStack);
        AutoNBTSerializer.registerSerializer(ItemStack[].class, AutoNBTSerializer::serializeItemStackArray, AutoNBTSerializer::deserializeItemStackArray);
        AutoNBTSerializer.registerSerializer(EnumFacing.class, AutoNBTSerializer::serializeEnumFacing, AutoNBTSerializer::deserializeEnumFacing);
        AutoNBTSerializer.registerSerializer(BlockPos.class, AutoNBTSerializer::serializeBlockPos, AutoNBTSerializer::deserializeBlockPos);
        AutoNBTSerializer.registerSerializer(RedstoneMode.class, AutoNBTSerializer::serializeRedstoneMode, AutoNBTSerializer::deserializeRedstoneMode);
        AutoNBTSerializer.registerSerializer(Block.class, AutoNBTSerializer::serializeBlock, AutoNBTSerializer::deserializeBlock);
        AutoNBTSerializer.registerSerializer(Item.class, AutoNBTSerializer::serializeItem, AutoNBTSerializer::deserializeItem);
        AutoNBTSerializer.registerSerializer(FluidStack.class, AutoNBTSerializer::serializeFluidStack, AutoNBTSerializer::deserializeFluidStack);
        AutoNBTSerializer.registerSerializer(Fluid.class, AutoNBTSerializer::serializeFluid, AutoNBTSerializer::deserializeFluid);
        AutoNBTSerializer.registerSerializer(FluidTank.class, AutoNBTSerializer::serializeFluidTank, AutoNBTSerializer::deserializeFluidTank);
        AutoNBTSerializer.registerSerializer(CreativeFluidTank.class, AutoNBTSerializer::serializeCreativeFluidTank, AutoNBTSerializer::deserializeCreativeFluidTank);
    }
}

