/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;

public class BytecodePrettyPrinter {
    public static String[] getMethod(String className, String methodName, String methodDescriptor) throws IOException {
        ClassReader classReader = new ClassReader(className);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(null, (Printer)new SourceCodeTextifier(), printWriter);
        MethodSelectorVisitor methodSelectorVisitor = new MethodSelectorVisitor((ClassVisitor)traceClassVisitor, methodName, methodDescriptor);
        classReader.accept((ClassVisitor)methodSelectorVisitor, 2);
        return BytecodePrettyPrinter.toList(stringWriter.toString());
    }

    public static String[] getMethod(String className, String methodName) throws IOException {
        return BytecodePrettyPrinter.getMethod(className, methodName, null);
    }

    private static String[] toList(String str) {
        String[] operations = str.split("[\n]");
        for (int i = 0; i < operations.length; ++i) {
            operations[i] = operations[i].trim();
        }
        return operations;
    }

    public static void printMethod(String className, String methodName, String methodDescriptor) {
        try {
            String[] ops;
            for (String s : ops = BytecodePrettyPrinter.getMethod(className, methodName, methodDescriptor)) {
                System.out.println(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class SourceCodeTextifier
    extends Printer {
        public SourceCodeTextifier() {
            this(262144);
        }

        protected SourceCodeTextifier(int api) {
            super(api);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        public void visitSource(String file, String debug) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public Textifier visitClassAnnotation(String desc, boolean visible) {
            return new Textifier();
        }

        public void visitClassAttribute(Attribute attr) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public Textifier visitField(int access, String name, String desc, String signature, Object value) {
            return new Textifier();
        }

        public Textifier visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Textifier t = new Textifier();
            this.text.add(t.getText());
            return t;
        }

        public void visitClassEnd() {
        }

        public void visit(String name, Object value) {
        }

        public void visitEnum(String name, String desc, String value) {
        }

        public Textifier visitAnnotation(String name, String desc) {
            return new Textifier();
        }

        public Textifier visitArray(String name) {
            return new Textifier();
        }

        public void visitAnnotationEnd() {
        }

        public Textifier visitFieldAnnotation(String desc, boolean visible) {
            return new Textifier();
        }

        public void visitFieldAttribute(Attribute attr) {
            this.visitAttribute(attr);
        }

        public void visitFieldEnd() {
        }

        public Textifier visitAnnotationDefault() {
            return new Textifier();
        }

        public Textifier visitMethodAnnotation(String desc, boolean visible) {
            return new Textifier();
        }

        public Textifier visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return new Textifier();
        }

        public void visitMethodAttribute(Attribute attr) {
        }

        public void visitCode() {
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        }

        public void visitInsn(int opcode) {
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitVarInsn(int opcode, int var) {
        }

        public void visitTypeInsn(int opcode, String type) {
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitLdcInsn(Object cst) {
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        }

        public void visitLineNumber(int line, Label start) {
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public void visitMethodEnd() {
        }

        public void visitAttribute(Attribute attr) {
        }
    }

    private static class MaxVisitFilterMethodVisitor
    extends MethodVisitor {
        public MaxVisitFilterMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }
    }

    private static class MethodSelectorVisitor
    extends ClassVisitor {
        private final String methodName;
        private final String methodDescriptor;

        public MethodSelectorVisitor(ClassVisitor cv, String methodName, String methodDescriptor) {
            super(262144, cv);
            this.methodName = methodName;
            this.methodDescriptor = methodDescriptor;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.methodName.equals(name)) {
                if (this.methodDescriptor == null) {
                    return new MaxVisitFilterMethodVisitor(super.visitMethod(access, name, desc, signature, exceptions));
                }
                if (this.methodDescriptor.equals(desc)) {
                    return new MaxVisitFilterMethodVisitor(super.visitMethod(access, name, desc, signature, exceptions));
                }
            }
            return null;
        }
    }
}

