/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.sleepingbag;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowfacts.sleepingbag.ModelSleepingBag;
import net.shadowfacts.sleepingbag.SleepingBag;

public class ItemSleepingBag
extends ItemArmor {
    private static final String TAG_SPAWN = "Spawn";
    private static final String TAG_POSITION = "Position";
    private static final String TAG_SLEEPING = "Sleeping";
    private static final String TAG_SLOT = "Slot";
    private static final int CHESTPIECE_SLOT = 2;

    public ItemSleepingBag() {
        super(ItemArmor.ArmorMaterial.IRON, 2, EntityEquipmentSlot.CHEST);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77655_b("sleepingbag");
        this.setRegistryName("sleepingbag");
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "sleepingbag:textures/models/sleepingbag.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot slot, ModelBiped _default) {
        return slot == EntityEquipmentSlot.CHEST ? ModelSleepingBag.instance : _default;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack sleepingBagCopy;
            ItemStack currentArmor = player.field_71071_by.field_70460_b[2];
            if (currentArmor != null) {
                currentArmor = currentArmor.func_77946_l();
            }
            if ((sleepingBagCopy = stack.func_77946_l()).func_77978_p() == null) {
                sleepingBagCopy.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound tag = sleepingBagCopy.func_77978_p();
            tag.func_74768_a(TAG_SLOT, player.field_71071_by.field_70461_c);
            player.field_71071_by.field_70460_b[2] = sleepingBagCopy;
            if (currentArmor != null) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, currentArmor);
                return EnumActionResult.SUCCESS;
            }
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            return EnumActionResult.FAIL;
        }
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
        return EnumActionResult.SUCCESS;
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot slot, Entity entity) {
        return slot == EntityEquipmentSlot.CHEST;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        NBTTagCompound tag;
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (player.func_70608_bn()) {
            return;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((tag = stack.func_77978_p()).func_74767_n(TAG_SLEEPING)) {
            ItemSleepingBag.restoreOriginalSpawn(player, tag);
            ItemSleepingBag.restoreOriginalPosition(player, tag);
            tag.func_82580_o(TAG_SLEEPING);
            ItemSleepingBag.getOutOfSleepingBag(player);
        } else {
            int posZ;
            int posY;
            int posX = MathHelper.func_76128_c((double)player.field_70165_t);
            BlockPos pos = new BlockPos(posX, posY = MathHelper.func_76128_c((double)player.field_70163_u), posZ = MathHelper.func_76128_c((double)player.field_70161_v));
            if (ItemSleepingBag.canPlayerSleep(player, world, pos)) {
                ItemSleepingBag.storeOriginalSpawn(player, tag);
                ItemSleepingBag.storeOriginalPosition(player, tag);
                tag.func_74757_a(TAG_SLEEPING, true);
                ItemSleepingBag.sleepSafe((EntityPlayerMP)player, world, pos);
            } else {
                ItemSleepingBag.getOutOfSleepingBag(player);
            }
        }
    }

    private static void sleepSafe(EntityPlayerMP player, World world, BlockPos pos) {
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)true, (String[])new String[]{"sleeping", "field_71083_bS"});
        ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)0, (String[])new String[]{"sleepTimer", "field_71076_b"});
        player.field_71081_bT = pos;
        player.field_70181_x = 0.0;
        player.field_70179_y = 0.0;
        player.field_70159_w = 0.0;
        world.func_72854_c();
        SPacketUseBed sleepPacket = new SPacketUseBed((EntityPlayer)player, pos);
        player.func_71121_q().func_73039_n().func_151248_b((Entity)player, (Packet)sleepPacket);
        player.field_71135_a.func_147359_a((Packet)sleepPacket);
    }

    private static EntityPlayer.EnumStatus vanillaCanSleep(EntityPlayer player, World world, BlockPos pos) {
        PlayerSleepInBedEvent event = new PlayerSleepInBedEvent(player, pos);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResultStatus() != null) {
            return event.getResultStatus();
        }
        if (!world.field_73011_w.func_76569_d()) {
            return EntityPlayer.EnumStatus.NOT_POSSIBLE_HERE;
        }
        if (world.func_72935_r()) {
            return EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW;
        }
        Vec3i vec = new Vec3i(8, 5, 8);
        List mobs = world.func_72872_a(EntityMob.class, new AxisAlignedBB(pos.func_177973_b(vec), pos.func_177971_a(vec)));
        if (!mobs.isEmpty()) {
            return EntityPlayer.EnumStatus.NOT_SAFE;
        }
        return EntityPlayer.EnumStatus.OK;
    }

    private static boolean canPlayerSleep(EntityPlayer player, World world, BlockPos pos) {
        if (player.func_70608_bn() || !player.func_70089_S()) {
            return false;
        }
        if (!ItemSleepingBag.isNotSuffocating(world, pos) || !ItemSleepingBag.isSolidEnough(world, pos.func_177977_b())) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("sleepingbag.no_ground", new Object[0]));
            return false;
        }
        EntityPlayer.EnumStatus status = ItemSleepingBag.vanillaCanSleep(player, world, pos);
        if (status == EntityPlayer.EnumStatus.OK) {
            return true;
        }
        if (status == EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]));
        } else if (status == EntityPlayer.EnumStatus.NOT_SAFE) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]));
        }
        return false;
    }

    private static boolean isNotSuffocating(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().func_180646_a(state, world, pos) == null || state.func_177230_c().isAir(state, (IBlockAccess)world, pos);
    }

    private static boolean isSolidEnough(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        AxisAlignedBB box = state.func_177230_c().func_180646_a(state, world, pos);
        if (box == null) {
            return false;
        }
        double dx = box.field_72336_d - box.field_72340_a;
        double dy = box.field_72337_e - box.field_72338_b;
        double dz = box.field_72334_f - box.field_72339_c;
        return dx >= 0.5 && dy >= 0.5 && dz >= 0.5;
    }

    private static void getOutOfSleepingBag(EntityPlayer player) {
        ItemStack stack = player.field_71071_by.field_70460_b[2];
        if (stack != null && stack.func_77973_b() == SleepingBag.sleepingBag && !ItemSleepingBag.tryReturnToSlot(player, stack) && !player.field_71071_by.func_70441_a(stack)) {
            float f = 0.7f;
            float d0 = player.field_70170_p.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            float d1 = player.field_70170_p.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            float d2 = player.field_70170_p.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            EntityItem item = new EntityItem(player.field_70170_p, player.field_70165_t + (double)d0, player.field_70163_u + (double)d1, player.field_70161_v + (double)d2, stack);
            item.func_174869_p();
            if (stack.func_77942_o()) {
                item.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            player.field_70170_p.func_72838_d((Entity)item);
        }
    }

    private static boolean tryReturnToSlot(EntityPlayer player, ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        int returnSlot = tag.func_74762_e(TAG_SLOT);
        tag.func_82580_o(TAG_SLOT);
        ItemStack possiblyArmor = player.field_71071_by.field_70462_a[returnSlot];
        if (ItemSleepingBag.isChestplate(possiblyArmor)) {
            player.field_71071_by.field_70460_b[2] = possiblyArmor;
        } else {
            player.field_71071_by.field_70460_b[2] = null;
            if (possiblyArmor != null) {
                return false;
            }
        }
        player.field_71071_by.func_70299_a(returnSlot, stack);
        return true;
    }

    private static boolean isChestplate(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemSleepingBag) {
            return false;
        }
        if (item instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)item;
            return armor.field_77881_a == EntityEquipmentSlot.CHEST;
        }
        return false;
    }

    private static void storeOriginalSpawn(EntityPlayer player, NBTTagCompound tag) {
        BlockPos pos = player.getBedLocation(player.field_70170_p.field_73011_w.getDimension());
        if (pos != null) {
            tag.func_74772_a(TAG_SPAWN, pos.func_177986_g());
        }
    }

    private static void restoreOriginalSpawn(EntityPlayer player, NBTTagCompound tag) {
        if (tag.func_74764_b(TAG_SPAWN)) {
            BlockPos pos = BlockPos.func_177969_a((long)tag.func_74763_f(TAG_SPAWN));
            player.setSpawnChunk(pos, false, player.field_70170_p.field_73011_w.getDimension());
            tag.func_82580_o(TAG_SPAWN);
        }
    }

    private static void storeOriginalPosition(EntityPlayer player, NBTTagCompound tag) {
        NBTTagCompound posTag = new NBTTagCompound();
        posTag.func_74780_a("x", player.field_70165_t);
        posTag.func_74780_a("y", player.field_70163_u);
        posTag.func_74780_a("z", player.field_70161_v);
        tag.func_74782_a(TAG_POSITION, (NBTBase)posTag);
    }

    private static void restoreOriginalPosition(EntityPlayer player, NBTTagCompound tag) {
        if (tag.func_74764_b(TAG_POSITION)) {
            NBTTagCompound posTag = tag.func_74775_l(TAG_POSITION);
            player.func_70107_b(posTag.func_74769_h("x"), posTag.func_74769_h("y"), posTag.func_74769_h("z"));
            tag.func_82580_o(TAG_POSITION);
        }
    }

    public static boolean isWearingSleepingBag(EntityPlayer player) {
        ItemStack armor = player.field_71071_by.field_70460_b[2];
        return armor != null && armor.func_77973_b() == SleepingBag.sleepingBag;
    }
}

