PrefabFiles = {
	"izzy",
	"izzy_none",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/izzy.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/izzy.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/izzy.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/izzy.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/izzy_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/izzy_silho.xml" ),

    Asset( "IMAGE", "bigportraits/izzy.tex" ),
    Asset( "ATLAS", "bigportraits/izzy.xml" ),
	
	Asset( "IMAGE", "images/map_icons/izzy.tex" ),
	Asset( "ATLAS", "images/map_icons/izzy.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_izzy.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_izzy.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_izzy.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_izzy.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_izzy.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_izzy.xml" ),
	
	Asset( "IMAGE", "images/names_izzy.tex" ),
    Asset( "ATLAS", "images/names_izzy.xml" ),
	
    Asset( "IMAGE", "bigportraits/izzy_none.tex" ),
    Asset( "ATLAS", "bigportraits/izzy_none.xml" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

-- The character select screen lines
STRINGS.CHARACTER_TITLES.izzy = "The Lizard Mouse"
STRINGS.CHARACTER_NAMES.izzy = "Izzy"
STRINGS.CHARACTER_DESCRIPTIONS.izzy = "*Nightvision\n*Fast Gather\n*Loves Cooking"
STRINGS.CHARACTER_QUOTES.izzy = "\"I feel like i'm forgetting something......\""

--STRINGS.CHARACTERS = {}
--STRINGS.CHARACTERS.IZZY.DESCRIBE = {}
--STRINGS.CHARACTERS.IZZY.DESCRIBE.EVERGREEN = "Is it Chrtistmas already?"
--STRINGS.CHARACTERS.IZZY.DESCRIBE.SPIDER = "KILL IT WITH FIRE!"
--STRINGS.CHARACTERS.IZZY.DESCRIBE.RABBIT = "Fluffy bun buns"
--STRINGS.CHARACTERS.IZZY.DESCRIBE.SAPLING = "It's soo tiny."


local Normal = {
    axe = true,
    pickaxe = true,
    shovel = true
}
 
local Golden = {
    goldenaxe = true,
    goldenpickaxe = true,
    goldenshovel = true
}

 AddComponentPostInit("workable", function(self)
    local old = self.WorkedBy
    function self:WorkedBy(worker, numworks)
        if worker.prefab == "izzy" then
            local a = 1
            if worker.components.inventory then
                a = worker.components.inventory.equipslots.hands
            end
            local item = worker.activeitem or a
            if item then
                if item.prefab == "axe" or
                    item.prefab == "pickaxe" or
                    item.prefab == "shovel" then
                    numworks = (numworks or 2) * 3
                elseif item.prefab == "goldenaxe" or
                    item.prefab == "goldenpickaxe" or
                    item.prefab == "goldenshovel" then
                    numworks = (numworks or 2) * 3
                end
            end
        end
        old(self, worker, numworks)
    end
	

	
	 AddComponentPostInit("sanityaura", function(self)
		 local old = self.GetAura 
		 function self:GetAura(observer) 
			 if observer.prefab == "izzy" and self.inst.prefab == "spiders"  then 
				 return - 10
			 end
			 return old(self,observer) 
		 end
	 end)	
 

local myhandler = GLOBAL.ActionHandler (GLOBAL.ACTIONS.PICK, function(inst, action)
	if action.target.components.pickable then
		if action.target.components.pickable.quickpick and action.target ~= nil or inst.prefab == "izzy" and action.target ~= nil then
			return "doshortaction"
		else
			return "dolongaction"
		end
	end

AddStategraphActionHandler("woodie", myhandler)
end)
end)
-- Custom speech strings
STRINGS.CHARACTERS.IZZY = require "speech_izzy"

-- The character's name as appears in-game 
STRINGS.NAMES.IZZY = "Izzy"

AddMinimapAtlas("images/map_icons/izzy.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("izzy", "FEMALE")

