% Character strings.
%
% General.
%   char        - Create character array (string).
%   double      - Convert string to numeric character codes.
%   cellstr     - Create cell array of strings from character array.
%   blanks      - String of blanks.
%   deblank     - Remove trailing blanks.
%   eval        - Execute string with MATLAB expression.
%
% String tests.
%   ischar      - True for character array (string).
%   iscellstr   - True for cell array of strings.
%   isletter    - True for letters of the alphabet.
%   isspace     - True for white space characters.
%
% String operations.
%   regexp      - Regular expression matching.
%   regexpi     - Regular expression matching ignoring case.
%   regexprep   - Regular expression replacing.
%   strcat      - Concatenate strings.
%   strvcat     - Vertically concatenate strings.
%   strcmp      - Compare strings.
%   strncmp     - Compare first N characters of strings.
%   strcmpi     - Compare strings ignoring case.
%   strncmpi    - Compare first N characters of strings ignoring case.
%   findstr     - Find shorter string pattern within longer string.
%   strfind     - Find second string pattern within first string.
%   strjust     - Justify character array.
%   strmatch    - Find possible matches for string.
%   strrep      - Replace string with another.
%   strtok      - Find token in string.
%   upper       - Convert string to uppercase.
%   lower       - Convert string to lowercase.
%
% String to number conversion.
%   num2str     - Convert number to string.
%   int2str     - Convert integer to string.
%   mat2str     - Convert matrix to eval'able string.
%   str2double  - Convert string to double precision value.
%   str2num     - Convert string matrix to numeric array.
%   sprintf     - Write formatted data to string.
%   sscanf      - Read string under format control.
%
% Base number conversion.
%   hex2num     - Convert IEEE hexadecimal to double precision number.
%   hex2dec     - Convert hexadecimal string to decimal integer.
%   dec2hex     - Convert decimal integer to hexadecimal string.
%   bin2dec     - Convert binary string to decimal integer.
%   dec2bin     - Convert decimal integer to binary string.
%   base2dec    - Convert base B string to decimal integer.
%   dec2base    - Convert decimal integer to base B string.
%
%   See also STRINGS.

% Utility functions.
%   strings     - Help for strings.
%
% Grandfathered functions.
%   str2mat     - Form blank padded character matrix from strings.
%   isstr       - True for character array (string).
%   setstr      - Convert numeric values into character string.

%   Copyright 1984-2002 The MathWorks, Inc.
%   Generated from Contents.m_template revision 1.1  $Date: 2002/05/31 22:22:15 $




