% Elementary matrices and matrix manipulation.
%
% Elementary matrices.
%   zeros       - Zeros array.
%   ones        - Ones array.
%   eye         - Identity matrix.
%   repmat      - Replicate and tile array.
%   rand        - Uniformly distributed random numbers.
%   randn       - Normally distributed random numbers.
%   linspace    - Linearly spaced vector.
%   logspace    - Logarithmically spaced vector.
%   freqspace   - Frequency spacing for frequency response.
%   meshgrid    - X and Y arrays for 3-D plots.
%   :           - Regularly spaced vector and index into matrix.
%
% Basic array information.
%   size        - Size of array.
%   length      - Length of vector.
%   ndims       - Number of dimensions.
%   numel       - Number of elements.
%   disp        - Display matrix or text.
%   isempty     - True for empty array.
%   isequal     - True if arrays are numerically equal.
%   isequalwithequalnans - True if arrays are numerically equal.
%   isnumeric   - True for numeric arrays.
%   islogical   - True for logical array.
%   logical     - Convert numeric values to logical.
%
% Matrix manipulation.
%   cat         - Concatenate arrays.
%   reshape     - Change size.
%   diag        - Diagonal matrices and diagonals of matrix.
%   blkdiag     - Block diagonal concatenation.
%   tril        - Extract lower triangular part.
%   triu        - Extract upper triangular part.
%   fliplr      - Flip matrix in left/right direction.
%   flipud      - Flip matrix in up/down direction.
%   flipdim     - Flip matrix along specified dimension.
%   rot90       - Rotate matrix 90 degrees.
%   :           - Regularly spaced vector and index into matrix.
%   find        - Find indices of nonzero elements.
%   end         - Last index.
%   sub2ind     - Linear index from multiple subscripts.
%   ind2sub     - Multiple subscripts from linear index.
%
% Multi-dimensional array functions.
%   ndgrid      - Generate arrays for N-D functions and interpolation.
%   permute     - Permute array dimensions.
%   ipermute    - Inverse permute array dimensions.
%   shiftdim    - Shift dimensions.
%   circshift   - Shift array circularly.
%   squeeze     - Remove singleton dimensions.
%
% Special variables and constants.
%   ans         - Most recent answer.
%   eps         - Floating point relative accuracy.
%   realmax     - Largest positive floating point number.
%   realmin     - Smallest positive floating point number.
%   pi          - 3.1415926535897....
%   i, j        - Imaginary unit.
%   inf         - Infinity.
%   NaN         - Not-a-Number.
%   isnan       - True for Not-a-Number.
%   isinf       - True for infinite elements.
%   isfinite    - True for finite elements.
%   why         - Succinct answer.
%
% Specialized matrices.
%   compan      - Companion matrix.
%   gallery     - Higham test matrices.
%   hadamard    - Hadamard matrix.
%   hankel      - Hankel matrix.
%   hilb        - Hilbert matrix.
%   invhilb     - Inverse Hilbert matrix.
%   magic       - Magic square.
%   pascal      - Pascal matrix.
%   rosser      - Classic symmetric eigenvalue test problem.
%   toeplitz    - Toeplitz matrix.
%   vander      - Vandermonde matrix.
%   wilkinson   - Wilkinson's eigenvalue test matrix.

% Obsolete functions.
%   meshdom     - Generate X and Y arrays for 3-D plots.
%   flops       - Floating point operation count.

%   Copyright 1984-2002 The MathWorks, Inc.
%   $Revision: 5.33 $  $Date: 2002/04/08 20:21:04 $


