%NUMEL   Number of elements in an array or subscripted array expression.
%   N = NUMEL(A) returns the number of elements, N, in array A.
%
%   N = NUMEL(A, VARARGIN) returns the number of subscripted
%   elements, N, in A(index1, index2, ..., indexN), where VARARGIN
%   is a cell array whose elements are index1, index2, ... indexN.
%
%   The NUMEL builtin function is implicitly called by MATLAB 
%   whenever a comma-separated list is generated by expressions
%   such as A{index1, index2, ..., indexN} or A.fieldname.   
%
%   It is important to note the significance of NUMEL with regards
%   to the overloaded SUBSREF and SUBSASGN functions. In the case of
%   the overloaded SUBSREF function, NUMEL is used to compute the 
%   number of expected outputs (NARGOUT) returned from SUBSREF. For
%   the overloaded SUBSASGN function, NUMEL is used to compute the 
%   number of expected inputs (NARGIN) to be assigned using SUBSASGN.
%   The NARGIN value for the overloaded SUBSASGN function consists of
%   the variable being assigned to, the structure array of subscripts,
%   and the value returned by NUMEL.  
%
%   It is vital that class designers ensure that the value of N
%   returned by the builtin NUMEL function is consistent with the 
%   class design for that object. If the value of N returned by the 
%   builtin NUMEL function is different from either the NARGOUT for
%   the overloaded SUBSREF function or the NARGIN for the overloaded
%   SUBSASGN function, then NUMEL needs to be overloaded to return a
%   value of N that is consistent with the class's SUBSREF and SUBSASGN
%   functions. Otherwise, MATLAB will produce errors when calling the 
%   overloaded SUBSREF and SUBSASGN functions.  
%
%   See also SIZE, PROD, SUBSREF, SUBSASGN, NARGIN, NARGOUT.

%   Copyright 1984-2002 The MathWorks, Inc. 
%   $Revision: 1.4 $ $Date: 2002/04/08 20:21:09 $
%   Built-in function.
