local assets =
{   
    Asset("ANIM", "anim/icefrog.zip"),
    Asset("ANIM", "anim/swap_icefrog.zip"),
    Asset ("ATLAS", "images/inventoryimages/icefrog.xml")
}


local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_icefrog", "swap_nightmaresword")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function onattack(inst, attacker, target, skipsanity)
    if not skipsanity and attacker ~= nil and attacker.components.sanity ~= nil then
        attacker.components.sanity:DoDelta(-TUNING.SANITY_SUPERTINY)
    end

    if not target:IsValid() then
        --target killed or removed in combat damage phase
        return
    end

    if target.components.sleeper ~= nil and target.components.sleeper:IsAsleep() then
        target.components.sleeper:WakeUp()
    end

    if target.components.burnable ~= nil then
        if target.components.burnable:IsBurning() then
            target.components.burnable:Extinguish()
        elseif target.components.burnable:IsSmoldering() then
            target.components.burnable:SmotherSmolder()
        end
    end

    if target.components.combat ~= nil then
        target.components.combat:SuggestTarget(attacker)
    end

    if target.sg ~= nil and not target.sg:HasStateTag("frozen") then
        target:PushEvent("attacked", { attacker = attacker, damage = 0 })
    end

    if target.components.freezable ~= nil then
        target.components.freezable:AddColdness(9)
        target.components.freezable:SpawnShatterFX()
    end
end

local function onhaunt(inst, haunter)
    if math.random() <= TUNING.HAUNT_CHANCE_RARE then
        local x, y, z = inst.Transform:GetWorldPosition() 
        local ents = TheSim:FindEntities(x, y, z, 6, { "freezable" }, { "INLIMBO" })
        if #ents > 0 then
            for i, v in ipairs(ents) do
                if v:IsValid() and not v:IsInLimbo() then
                    onattack(inst, haunter, v, true) 
                end
            end
            inst.components.hauntable.hauntvalue = TUNING.HAUNT_LARGE
            return true
        end
    end
    return false
end

local function fn(Sim)
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
        
    MakeInventoryPhysics(inst)
    
    if not TheWorld.ismastersim then
        return inst
  end
  
  inst.AnimState:SetBank("nightmaresword")
  inst.AnimState:SetBuild("icefrog")
  inst.AnimState:PlayAnimation("idle")
    
  inst:AddTag("sharp")
  
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE *0.9)
    inst.components.weapon:SetRange(8, 10)
    inst.components.weapon:SetOnAttack(onattack)
    inst.components.weapon.onattack = onattack
    inst.components.weapon:SetProjectile("ice_projectile")

  inst:AddComponent("finiteuses")
  inst.components.finiteuses:SetMaxUses(100)
  inst.components.finiteuses:SetUses(100)
  inst.components.finiteuses:SetOnFinished(inst.Remove)
    
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "icefrog"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/icefrog.xml"
    
  inst:AddComponent("equippable")
  inst.components.equippable:SetOnEquip( onequip )
  inst.components.equippable:SetOnUnequip( onunequip)
  MakeHauntableLaunch(inst)
      AddHauntableCustomReaction(inst, onhaunt, true, false, true)
    
    return inst
end

return Prefab( "common/inventory/icefrog", fn, assets)
