PrefabFiles = {
	"esctemplate",
	"esctemplate_none",
	"frog",
	"torch",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/esctemplate.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/esctemplate.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/esctemplate.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/esctemplate.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/esctemplate_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/esctemplate_silho.xml" ),

    Asset( "IMAGE", "bigportraits/esctemplate.tex" ),
    Asset( "ATLAS", "bigportraits/esctemplate.xml" ),
	
	Asset( "IMAGE", "images/map_icons/esctemplate.tex" ),
	Asset( "ATLAS", "images/map_icons/esctemplate.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_esctemplate.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_esctemplate.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_esctemplate.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_esctemplate.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_esctemplate.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_esctemplate.xml" ),
	
	Asset( "IMAGE", "images/names_esctemplate.tex" ),
    Asset( "ATLAS", "images/names_esctemplate.xml" ),
	
    Asset( "IMAGE", "bigportraits/esctemplate_none.tex" ),
    Asset( "ATLAS", "bigportraits/esctemplate_none.xml" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

-- 给MOD的变量赋值
TUNING.TORE_DAMAGE= GetModConfigData("TOR_DAMAGE")
TUNING.OTK_DEF= GetModConfigData("OTK_DEF")
TUNING.JZ_SPD= GetModConfigData("JZ_SPD")
TUNING.OV_TEP= GetModConfigData("OV_TEP")

-- The character select screen lines
STRINGS.CHARACTER_TITLES.esctemplate = "jasenwdh"
STRINGS.CHARACTER_NAMES.esctemplate = "jasenwdh"
STRINGS.CHARACTER_DESCRIPTIONS.esctemplate = "*FFF团大膜法师，能用火把释放火球\n*是个死宅，但是跑的比香港记者还快\n*一旦angry就会念诗，还能把媒体批判一番"
STRINGS.CHARACTER_QUOTES.esctemplate = "\"在下区区一介死宅而已！\""

-- Custom speech strings
STRINGS.CHARACTERS.ESCTEMPLATE = require "speech_esctemplate"

-- The character's name as appears in-game 
STRINGS.NAMES.ESCTEMPLATE = "jasenwdh"

AddMinimapAtlas("images/map_icons/esctemplate.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("esctemplate", "MALE")

-- 控制表情
local emoteanims = {
		{name="Dance",anims={"emoteXL_pre_dance0","emoteXL_loop_dance0"}},
		{name="Pose",anims={"emote_strikepose"}},
		{name="Sit",anims={"emote_pre_sit2","emote_loop_sit2","emote_pre_sit4","emote_loop_sit4"}},
}

local emotesay = {
	jasenwdh = { 
		Pose = "我是身经百战，见的多了。",
		Dance = "我今天是作为一个长者，给你们一点人生的经验。",
		Sit = "闷声发大财。"
	},
}

local function CheckWhichEmote(data)
    name = false
    if data then
        for i,anim in pairs(emoteanims) do
            if type(data.anim)=="string" and anim.anims[1] == data.anim then -- if data.anim is a string, we only need to check first.
                name = anim.name
            elseif type(data.anim)=="table" then -- check also if anim is a table
                for k,animstringdata in pairs(data.anim) do
                    if type(animstringdata)=="string" then   -- if it is now a string
                        for k2,animstring in pairs(anim.anims) do
                            if animstring == animstringdata then
                                name = anim.name
                            end
                        end
                    elseif type(animstringdata)=="table" then -- in case of sit and aquat it is again a table...
                        for q,stringdata in pairs(animstringdata) do
                            for k2,animstring in pairs(anim.anims) do
                                if animstring == stringdata then
                                    name = anim.name
                                end
                            end 
                        end
                    end
                end
            end
        end
    end
    return name -- returns the name of the emotion from your emoteanims table
end

local function EmoteReact(inst, data)
    if data then
        name = CheckWhichEmote(data)
        if name then
            local saytable = emotesay[inst.prefab]
            if saytable then
                local saying = saytable[name]
                if saying and inst.components.talker then
                    inst.components.talker:Say(saying)
                end
            end
        end
	end
end

AddPlayerPostInit(function(inst)
	inst:ListenForEvent("emote", EmoteReact)
end)