
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when reviving from ghost (optional)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "esctemplate_speed_mod", TUNING.JZ_SPD)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "esctemplate_speed_mod")
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end

---------
local function updatestats(inst, phase)
    
    if phase == "day" then
        inst.components.sanity.night_drain_mult = 0
    elseif phase == "dusk" then
        inst.components.sanity.night_drain_mult = 0
	elseif phase == "night" then
        inst.components.sanity.night_drain_mult = 0
end
end

-----------
local function emote(inst, data)
	if data.anim == "emoteXL_angry" then
	inst.components.health:DoDelta(-1)
	inst.components.talker:Say("苟利国家生死已，岂因祸福避趋之。")
	end
	
	if data.anim == "emoteXL_facepalm" then
	inst.components.health:DoDelta(-1)
	inst.components.talker:Say("你们啊，不要想弄个大新闻。")
	end
	
	if data.anim == "emoteXL_kiss" then
	inst.components.health:DoDelta(-1)
	inst.components.talker:Say("无可奉告。")
	end
	
	if data.anim == "emoteXL_sad" then
	inst.components.health:DoDelta(-1)
	inst.components.talker:Say("我着急啊，真的。")
	end
	
	if data.anim == "emoteXL_annoyed" then
	inst.components.health:DoDelta(-1)
	inst.components.talker:Say("毕竟还Too Young！Too Simple！")
	end
	
	if data.anim == "emoteXL_swoon" then
	inst.components.health:DoDelta(-1)
	inst.components.talker:Say("闷声发大财。")
	end
		
	if data.anim == "emoteXL_bonesaw" then
	inst.components.health:DoDelta(-1)
	inst.components.talker:Say("按照香港的基本法，按照香港的选举法！")
	end
	
	if data.anim == "emoteXL_happycheer" then
	inst.components.health:DoDelta(-1)
	inst.components.talker:Say("Sometimes Naive!")
	end	
end

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "esctemplate.tex" )
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	inst:AddTag("wa")
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(75)
	inst.components.hunger:SetMax(75)
	inst.components.sanity:SetMax(150)
	
	--------------
	inst:WatchWorldState("phase", updatestats)
	updatestats(inst, TheWorld.state.phase)
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	inst:ListenForEvent("emote", emote)
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 0.5 * TUNING.WILSON_HUNGER_RATE
	
	inst.components.temperature.inherentinsulation = TUNING.OTK_DEF
	
	inst.components.temperature.overheattemp = TUNING.OV_TEP
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
end

return MakePlayerCharacter("esctemplate", prefabs, assets, common_postinit, master_postinit, start_inv)
