/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems.declmime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverImpl;
import org.netbeans.modules.openide.filesystems.declmime.Util;
import org.netbeans.modules.openide.filesystems.declmime.XMLMIMEComponent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;

final class FileElement {
    Type fileCheck = new Type();
    private String mime = null;
    XMLMIMEComponent rule = null;
    static final String EXIT_MIME_TYPE = "mime-type-to-exit";

    FileElement() {
    }

    String[] getExtensions() {
        return this.fileCheck.exts;
    }

    String getMimeType() {
        return this.mime;
    }

    private boolean isExit() {
        return this.fileCheck.exit;
    }

    void setMIME(String mime) {
        if ("null".equals(mime)) {
            return;
        }
        this.mime = mime;
    }

    String resolve(FileObject file) {
        try {
            if (this.fileCheck.accept(file)) {
                if (this.rule != null && !this.rule.acceptFileObject(file)) {
                    return null;
                }
                if (this.isExit() || this.mime == null) {
                    return EXIT_MIME_TYPE;
                }
                return this.mime;
            }
        }
        catch (IOException io) {
            Logger.getLogger(MIMEResolverImpl.class.getName()).log(Level.INFO, "IOException in resolver " + this, io);
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FileElement(");
        buf.append(this.fileCheck).append(' ');
        buf.append(this.rule).append(' ');
        buf.append("Result:").append(this.mime);
        return buf.toString();
    }

    public void writeExternal(DataOutput out) throws IOException {
        Util.writeUTF(out, this.mime);
        this.fileCheck.writeExternal(out);
        if (this.rule != null) {
            out.writeBoolean(true);
            this.rule.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readExternal(DataInput in) throws IOException {
        this.mime = Util.readUTF(in);
        this.fileCheck.readExternal(in);
        if (in.readBoolean()) {
            this.rule = new XMLMIMEComponent(in);
        }
    }

    static class Type {
        private static final String EMPTY_EXTENSION = "";
        private String[] exts;
        private String[] mimes;
        private String[] fatts;
        private String[] vals;
        private boolean exit;
        private byte[] magic;
        private byte[] mask;
        private List<FilePattern> patterns;
        private List<FileName> names;
        private transient FilePattern lastAddedPattern;

        Type() {
        }

        final boolean isValid() {
            return this.exts != null || this.mimes != null || this.fatts != null || this.patterns != null || this.names != null || this.magic != null;
        }

        private void writeExternal(DataOutput out) throws IOException {
            Util.writeStrings(out, this.exts);
            Util.writeStrings(out, this.mimes);
            Util.writeStrings(out, this.fatts);
            Util.writeStrings(out, this.vals);
            out.writeBoolean(this.exit);
            Util.writeBytes(out, this.magic);
            Util.writeBytes(out, this.mask);
            if (this.patterns == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(this.patterns.size());
                for (FilePattern p : this.patterns) {
                    p.writeExternal(out);
                }
            }
            if (this.names == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(this.names.size());
                for (FileName n : this.names) {
                    n.writeExternal(out);
                }
            }
        }

        private void readExternal(DataInput in) throws IOException {
            int namesSize;
            this.exts = Util.readStrings(in);
            this.mimes = Util.readStrings(in);
            this.fatts = Util.readStrings(in);
            this.vals = Util.readStrings(in);
            this.exit = in.readBoolean();
            this.magic = Util.readBytes(in);
            this.mask = Util.readBytes(in);
            int patternsSize = in.readInt();
            if (patternsSize >= 0) {
                this.patterns = new ArrayList<FilePattern>(patternsSize);
                for (int i = 0; i < patternsSize; ++i) {
                    this.patterns.add(new FilePattern(in));
                }
            }
            if ((namesSize = in.readInt()) >= 0) {
                this.names = new ArrayList<FileName>(namesSize);
                for (int i = 0; i < namesSize; ++i) {
                    this.names.add(new FileName(in));
                }
            }
        }

        public String toString() {
            int i = 0;
            StringBuffer buf = new StringBuffer();
            buf.append("fast-check(");
            if (this.exts != null) {
                buf.append("exts:");
                for (i = 0; i < this.exts.length; ++i) {
                    buf.append(this.exts[i]).append(", ");
                }
            }
            if (this.mimes != null) {
                buf.append("mimes:");
                for (i = 0; i < this.mimes.length; ++i) {
                    buf.append(this.mimes[i]).append(", ");
                }
            }
            if (this.fatts != null) {
                buf.append("file-attributes:");
                for (i = 0; i < this.fatts.length; ++i) {
                    buf.append(this.fatts[i]).append("='").append(this.vals[i]).append("', ");
                }
            }
            if (this.patterns != null) {
                buf.append("patterns:");
                for (FilePattern pattern : this.patterns) {
                    buf.append(pattern.toString()).append(", ");
                }
            }
            if (this.names != null) {
                buf.append("names:");
                for (FileName name : this.names) {
                    buf.append(name.toString()).append(", ");
                }
            }
            if (this.magic != null) {
                buf.append("magic:").append(XMLUtil.toHex((byte[])this.magic, (int)0, (int)this.magic.length));
            }
            if (this.mask != null) {
                buf.append("mask:").append(XMLUtil.toHex((byte[])this.mask, (int)0, (int)this.mask.length));
            }
            buf.append(')');
            return buf.toString();
        }

        final void addExt(String ext) {
            this.exts = Util.addString(this.exts, ext);
        }

        final void addMIME(String mime) {
            this.mimes = Util.addString(this.mimes, mime.toLowerCase());
        }

        final void addAttr(String name, String value) {
            this.fatts = Util.addString(this.fatts, name);
            this.vals = Util.addString(this.vals, value);
        }

        final void addPattern(String value, int range, boolean ignoreCase) {
            if (this.patterns == null) {
                this.patterns = new ArrayList<FilePattern>();
            }
            this.lastAddedPattern = new FilePattern(value, range, ignoreCase);
            this.patterns.add(this.lastAddedPattern);
        }

        final void addInnerPattern(String value, int range, boolean ignoreCase) {
            FilePattern inner = new FilePattern(value, range, ignoreCase);
            this.lastAddedPattern.setInner(inner);
            this.lastAddedPattern = inner;
        }

        final void addName(String name, boolean substring, boolean ignoreCase) {
            if (this.names == null) {
                this.names = new ArrayList<FileName>();
            }
            this.names.add(new FileName(name, substring, ignoreCase));
        }

        final boolean setMagic(byte[] magic, byte[] mask) {
            if (magic == null) {
                return true;
            }
            if (mask != null && magic.length != mask.length) {
                return false;
            }
            this.magic = magic;
            if (mask != null) {
                this.mask = mask;
                for (int i = 0; i < mask.length; ++i) {
                    int n = i;
                    this.magic[n] = (byte)(this.magic[n] & mask[i]);
                }
            }
            return true;
        }

        final void setExit() {
            this.exit = true;
        }

        private static String getMIMEType(String extension) {
            return FileUtil.getMIMEType(extension);
        }

        private static void handleIOException(FileObject fo, IOException ioe) throws IOException {
            if (!(!fo.canRead() || Utilities.isWindows() && ioe instanceof FileNotFoundException && fo.isValid() && fo.getName().toLowerCase().contains("ntuser"))) {
                throw ioe;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean accept(FileObject fo) throws IOException {
            if (this.exts != null) {
                String ext = fo.getExt();
                if (ext == null) {
                    ext = EMPTY_EXTENSION;
                }
                if (!Util.contains(this.exts, ext, MIMEResolverImpl.CASE_INSENSITIVE)) {
                    return false;
                }
            }
            if (this.mimes != null) {
                boolean match = false;
                String s = Type.getMIMEType(fo.getExt());
                if (s == null) {
                    return false;
                }
                int l = s.indexOf(59);
                if (l >= 0) {
                    s = s.substring(0, l);
                }
                s = s.toLowerCase();
                for (int i = this.mimes.length - 1; i >= 0; --i) {
                    if (s.equals(this.mimes[i])) {
                        match = true;
                        break;
                    }
                    if (this.mimes[i].length() <= 0 || this.mimes[i].charAt(0) != '+' || !s.endsWith(this.mimes[i])) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    return false;
                }
            }
            if (this.magic != null) {
                boolean bl;
                byte[] header = new byte[this.magic.length];
                InputStream in = null;
                try {
                    in = fo.getInputStream();
                    int read = in.read(header);
                    if (read < 0) {
                        bl = false;
                        return bl;
                    }
                }
                catch (IOException openex) {
                    Type.handleIOException(fo, openex);
                    bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ioe) {}
                }
                for (int i = 0; i < this.magic.length; ++i) {
                    if (this.mask != null) {
                        int n = i;
                        header[n] = (byte)(header[n] & this.mask[i]);
                    }
                    if (this.magic[i] == header[i]) continue;
                    return false;
                }
            }
            if (this.fatts != null) {
                for (int i = this.fatts.length - 1; i >= 0; --i) {
                    Object attr = fo.getAttribute(this.fatts[i]);
                    if (attr != null) {
                        if (attr.toString().equals(this.vals[i]) || this.vals[i] == null) continue;
                        return false;
                    }
                    return false;
                }
            }
            if (this.patterns != null) {
                try {
                    boolean matched = false;
                    for (FilePattern pattern : this.patterns) {
                        if (!pattern.match(fo)) continue;
                        matched = true;
                        break;
                    }
                    if (!matched) {
                        return false;
                    }
                }
                catch (IOException ioe) {
                    Type.handleIOException(fo, ioe);
                    return false;
                }
            }
            if (this.names != null) {
                boolean matched = false;
                for (FileName name : this.names) {
                    if (!name.match(fo)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    return false;
                }
            }
            return true;
        }

        class FileName {
            static final boolean DEFAULT_IGNORE_CASE = true;
            static final boolean DEFAULT_SUBSTRING = false;
            private final String name;
            private final boolean substring;
            private final boolean ignoreCase;

            public FileName(String name, boolean substring, boolean ignoreCase) {
                this.name = ignoreCase ? name.toLowerCase() : name;
                this.substring = substring;
                this.ignoreCase = ignoreCase;
            }

            public FileName(DataInput is) throws IOException {
                this(Util.readUTF(is), is.readBoolean(), is.readBoolean());
            }

            public void writeExternal(DataOutput os) throws IOException {
                Util.writeUTF(os, this.name);
                os.writeBoolean(this.substring);
                os.writeBoolean(this.ignoreCase);
            }

            public boolean match(FileObject fo) {
                String nameAndExt = fo.getNameExt();
                if (this.ignoreCase) {
                    nameAndExt = nameAndExt.toLowerCase();
                }
                if (this.substring) {
                    return nameAndExt.contains(this.name);
                }
                return nameAndExt.equals(this.name);
            }

            public String toString() {
                return "[" + this.name + ", " + this.substring + ", " + this.ignoreCase + "]";
            }
        }

        class FilePattern {
            static final boolean DEFAULT_IGNORE_CASE = false;
            private final String value;
            private final int range;
            private final boolean ignoreCase;
            private final byte[] bytes;
            private final int valueLength;
            private FilePattern inner;

            public FilePattern(String value, int range, boolean ignoreCase) {
                this.value = value;
                this.valueLength = value.length();
                this.bytes = ignoreCase ? value.toLowerCase().getBytes() : value.getBytes();
                this.range = range;
                this.ignoreCase = ignoreCase;
            }

            public FilePattern(DataInput is) throws IOException {
                this(Util.readUTF(is), is.readInt(), is.readBoolean());
                if (is.readBoolean()) {
                    this.inner = type.new FilePattern(is);
                }
            }

            public void writeExternal(DataOutput os) throws IOException {
                Util.writeUTF(os, this.value);
                os.writeInt(this.range);
                os.writeBoolean(this.ignoreCase);
                if (this.inner != null) {
                    os.writeBoolean(true);
                    this.inner.writeExternal(os);
                } else {
                    os.writeBoolean(false);
                }
            }

            public void setInner(FilePattern inner) {
                this.inner = inner;
            }

            private boolean match(byte b, AtomicInteger pointer) {
                if (b == this.bytes[pointer.get()]) {
                    return pointer.incrementAndGet() >= this.valueLength;
                }
                pointer.set(0);
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean match(FileObject fo) throws IOException {
                InputStream is = null;
                boolean matched = false;
                try {
                    is = fo.getInputStream();
                    byte[] byteRange = new byte[this.range];
                    int read = is.read(byteRange);
                    AtomicInteger pointer = new AtomicInteger(0);
                    for (int i = 0; i < read; ++i) {
                        byte b = byteRange[i];
                        if (this.ignoreCase) {
                            b = (byte)Character.toLowerCase(b);
                        }
                        if (!this.match(b, pointer)) continue;
                        matched = true;
                        break;
                    }
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException ioe) {}
                }
                if (matched) {
                    if (this.inner == null) {
                        return true;
                    }
                    return this.inner.match(fo);
                }
                return false;
            }

            public String toString() {
                return "[" + this.value + ", " + this.range + ", " + this.ignoreCase + (this.inner != null ? ", " + this.inner : Type.EMPTY_EXTENSION) + "]";
            }
        }
    }
}

