/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.options.CanvasOptions;

public class Ruler
extends JPanel {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int PX = 0;
    public static final int MM = 1;
    public static final int CM = 2;
    public static final int IN = 3;
    private static final int SIZE = 25;
    private int orientation;
    private int unitType;
    private double unit;
    private double unitDPI;
    private double increment;
    private int tickCount;
    private double tickMarkZero;
    private VectorCanvas canvas;
    private JViewport viewport;
    private double zoomFactor;
    private Rectangle2D view;
    private Point caret;
    private boolean caretVisible;

    public Ruler(VectorCanvas canvas) {
        this(canvas, 0, 0);
    }

    public Ruler(VectorCanvas canvas, int orientation, int unitType) {
        this.canvas = canvas;
        this.orientation = orientation;
        this.unitType = unitType;
        this.caret = new Point();
        this.caretVisible = false;
        this.zoomFactor = 1.0;
        this.tickMarkZero = 0.0;
        this.view = (Rectangle)canvas.getBounds().clone();
        this.setFont(new Font("Monospaced", 0, 10));
        this.setBackground(Color.WHITE);
        this.updateIncrementAndUnits();
        canvas.addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                Ruler.this.canvasMouseMoved(evt);
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                Ruler.this.canvasMouseDragged(evt);
            }
        });
        canvas.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                Ruler.this.canvasMouseExited(evt);
            }
        });
        canvas.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Ruler.this.canvasComponentResized(evt);
            }
        });
        for (Container parent = canvas.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JScrollPane)) continue;
            this.viewport = ((JScrollPane)parent).getViewport();
            break;
        }
    }

    protected void updateIncrementAndUnits() {
        this.tickCount = 10;
        double dpi = 96.0;
        switch (this.unitType) {
            case 1: {
                this.unitDPI = this.unit = dpi / 25.4;
                this.unit *= 10.0;
                if (this.zoomFactor < 1.0) {
                    this.unit = this.zoomFactor >= 0.5 ? (this.unit *= 2.0) : (this.zoomFactor >= 0.25 ? (this.unit *= 4.0) : (this.zoomFactor >= 0.1 ? (this.unit *= 10.0) : (this.unit *= 1.0 / this.zoomFactor)));
                }
                this.increment = this.unit / (double)this.tickCount;
                break;
            }
            case 2: {
                this.unitDPI = this.unit = dpi / 2.54;
                if (this.zoomFactor < 1.0) {
                    this.unit = this.zoomFactor >= 0.5 ? (this.unit *= 2.0) : (this.zoomFactor >= 0.25 ? (this.unit *= 4.0) : (this.zoomFactor >= 0.1 ? (this.unit *= 10.0) : (this.unit *= 1.0 / this.zoomFactor)));
                }
                this.increment = this.unit / (double)this.tickCount;
                break;
            }
            case 3: {
                this.unit = dpi;
                this.unitDPI = dpi;
                if (this.zoomFactor < 1.0) {
                    this.unit = this.zoomFactor >= 0.5 ? (this.unit *= 2.0) : (this.zoomFactor >= 0.25 ? (this.unit *= 4.0) : (this.zoomFactor >= 0.1 ? (this.unit *= 10.0) : (this.unit *= 1.0 / this.zoomFactor)));
                }
                this.increment = this.unit / (double)this.tickCount;
                break;
            }
            default: {
                this.unit = 50.0;
                this.unitDPI = 1.0;
                if (this.zoomFactor >= 9.0) {
                    this.unit *= 1.0 / this.zoomFactor;
                } else if (this.zoomFactor >= 4.0) {
                    this.unit /= 5.0;
                } else if (this.zoomFactor >= 3.0) {
                    this.unit /= 2.5;
                } else if (this.zoomFactor >= 2.0) {
                    this.unit /= 2.0;
                } else if (!(this.zoomFactor >= 1.0)) {
                    this.unit = this.zoomFactor >= 0.5 ? (this.unit *= 2.0) : (this.zoomFactor >= 0.25 ? (this.unit *= 4.0) : (this.zoomFactor >= 0.1 ? (this.unit *= 10.0) : (this.unit *= 1.0 / this.zoomFactor)));
                }
                this.increment = this.unit / (double)this.tickCount;
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        double end;
        double start;
        Graphics2D g2d = (Graphics2D)g;
        Rectangle drawHere = (Rectangle)this.viewport.getViewRect().clone();
        this.view.setRect(this.canvas.getBounds().getBounds2D());
        Insets insets = this.canvas.getInsets();
        this.view.setRect(this.view.getX() + (double)insets.left, this.view.getY() + (double)insets.top, this.view.getWidth() - (double)(insets.left + insets.right), this.view.getHeight() - (double)(insets.top + insets.bottom));
        if (this.orientation == 0) {
            if (drawHere.getWidth() > this.view.getWidth()) {
                drawHere.setRect(drawHere.getX() - this.view.getX(), drawHere.getY(), drawHere.getWidth() + this.view.getX(), drawHere.getHeight());
            }
            this.tickMarkZero = this.view.getX();
            drawHere.y = 0;
            drawHere.height = 25;
            start = drawHere.getX();
            end = drawHere.getX() + drawHere.getWidth();
        } else {
            if (drawHere.getHeight() > this.view.getHeight()) {
                drawHere.setRect(drawHere.getX(), drawHere.getY() - this.view.getY(), drawHere.getWidth(), drawHere.getHeight() + this.view.getY());
            }
            this.tickMarkZero = this.view.getY();
            drawHere.x = 0;
            drawHere.width = 25;
            start = drawHere.getY();
            end = drawHere.getY() + drawHere.getHeight();
        }
        g.setColor(this.getBackground());
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        g.setColor(Color.BLACK);
        g.setFont(this.getFont());
        if (this.orientation == 0) {
            g.drawLine(drawHere.x, 24, drawHere.x + drawHere.width, 24);
        } else {
            g.drawLine(24, drawHere.y, 24, drawHere.y + drawHere.height);
        }
        FontMetrics fontMetrics = g.getFontMetrics();
        int fontHeight = fontMetrics.getHeight();
        int fontAscent = fontMetrics.getAscent();
        int tickLengthFull = 25;
        int tickLengthOdd = 25 - fontHeight;
        int tickLengthEven = tickLengthOdd - 2;
        double tickIncrement = this.increment * this.zoomFactor;
        double tick = (int)Math.round(start / tickIncrement);
        boolean odd = tick % 2.0 == 0.0;
        for (double i = start; i < end; i += tickIncrement) {
            String text;
            int tickLength;
            double shifted = i + this.tickMarkZero;
            if (tick % (double)this.tickCount == 0.0) {
                tickLength = tickLengthFull;
                int label = (int)Math.round(tick / (double)this.tickCount * this.unit / this.unitDPI);
                if (label < 0) {
                    label = 0 - label;
                }
                text = Integer.toString(label);
                odd = false;
            } else {
                if (odd) {
                    tickLength = tickLengthOdd;
                    odd = false;
                } else {
                    tickLength = tickLengthEven;
                    odd = true;
                }
                text = null;
            }
            tick += 1.0;
            int shiftedInt = (int)shifted;
            if (this.orientation == 0) {
                g.drawLine(shiftedInt, 24, shiftedInt, 25 - tickLength - 1);
                if (text == null) continue;
                g.drawString(text, shiftedInt + 2, fontAscent);
                continue;
            }
            g.drawLine(24, shiftedInt, 25 - tickLength - 1, shiftedInt);
            if (text == null) continue;
            int pos = shiftedInt;
            char[] chars = text.toCharArray();
            for (int j = 0; j < text.length(); ++j) {
                g.drawChars(chars, j, 1, 2, pos += fontAscent);
            }
        }
        if (this.caretVisible) {
            g.setColor(CanvasOptions.getInstance().getSelectionColor());
            if (this.orientation == 0) {
                g2d.drawLine(this.caret.x + (int)Math.round(this.tickMarkZero), 1, this.caret.x + (int)Math.round(this.tickMarkZero), 24);
            } else {
                g2d.drawLine(0, this.caret.y + (int)Math.round(this.tickMarkZero), 24, this.caret.y + (int)Math.round(this.tickMarkZero));
            }
        }
    }

    public void setPreferredHeight(int ph) {
        this.setPreferredSize(new Dimension(25, ph));
    }

    public void setPreferredWidth(int pw) {
        this.setPreferredSize(new Dimension(pw, 25));
    }

    protected final synchronized void repaintCaret() {
        if (this.caret == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.orientation == 0) {
            this.repaint(this.caret.x + (int)Math.floor(this.tickMarkZero), 2, 2, 23);
        } else {
            this.repaint(2, this.caret.y + (int)Math.floor(this.tickMarkZero), 23, 2);
        }
    }

    public void setUnitType(int unitType) {
        this.unitType = unitType;
        this.updateIncrementAndUnits();
    }

    public int getUnitType() {
        return this.unitType;
    }

    private void canvasMouseMoved(MouseEvent evt) {
        this.caretVisible = false;
        this.repaintCaret();
        this.caret = evt.getPoint();
        this.caretVisible = true;
        this.repaintCaret();
    }

    private void canvasMouseDragged(MouseEvent evt) {
        this.caretVisible = false;
        this.repaintCaret();
        this.caret = evt.getPoint();
        this.caretVisible = true;
        this.repaintCaret();
    }

    private void canvasMouseExited(MouseEvent evt) {
        this.caretVisible = false;
        this.repaintCaret();
    }

    private void canvasComponentResized(ComponentEvent evt) {
        AffineTransform at = this.canvas.getTransform(false);
        this.zoomFactor = at.getScaleX();
        this.updateIncrementAndUnits();
        if (this.orientation == 0) {
            this.setPreferredWidth(this.canvas.getWidth());
        } else {
            this.setPreferredHeight(this.canvas.getHeight());
        }
        this.repaint();
    }
}

