/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.text.TextCaret;
import kiyut.sketsa.canvas.text.TextEditor;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.undo.DOMUndoManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGTSpanElement;
import org.w3c.dom.svg.SVGTextElement;

public class TextTool
extends AbstractTool {
    private VectorCanvas canvas;
    private int x;
    private int y;
    private String initialText = "here is the text ";

    @Override
    public void paint(Graphics2D g2d) {
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void startTool() {
        this.canvas.getTextEditor().stopEdit();
        this.canvas.getCanvasSelection().setEnabledVisible(false, false, false);
        this.canvas.setCursor(Cursor.getPredefinedCursor(2));
        this.fireMessageReceived(0, "Text tool");
    }

    @Override
    public void endTool() {
        if (this.canvas != null) {
            this.canvas.getTextEditor().stopEdit();
            this.canvas.getTextEditor().setSVGTextElement(null);
        }
    }

    protected SVGElement createSVGElement() {
        CanvasModel model = this.canvas.getModel();
        SVGDocument svgDocument = model.getSVGDocument();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGElement element = (SVGElement)svgDocument.createElementNS(svgNS, "text");
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        srcPts[0] = this.x;
        srcPts[1] = this.y;
        AffineTransform at = this.canvas.getTransform(true);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        at.transform(srcPts, 0, dstPts, 0, 1);
        element.setAttributeNS(null, "x", Float.toString((float)dstPts[0]));
        element.setAttributeNS(null, "y", Float.toString((float)dstPts[1]));
        Text text = svgDocument.createTextNode(this.initialText);
        SVGTSpanElement tspan = (SVGTSpanElement)svgDocument.createElementNS(svgNS, "tspan");
        tspan.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
        tspan.appendChild((Node)text);
        element.appendChild((Node)tspan);
        return element;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        TextEditor editor = this.canvas.getTextEditor();
        if (editor.isEditable()) {
            editor.mouseClicked(evt);
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        TextEditor editor = this.canvas.getTextEditor();
        if (editor.isEditable()) {
            editor.mousePressed(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        TextEditor editor = this.canvas.getTextEditor();
        if (editor.isEditable()) {
            editor.mouseReleased(evt);
            return;
        }
        this.x = evt.getX();
        this.y = evt.getY();
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.x = gridSize * Math.round((float)this.x / (float)gridSize);
            this.y = gridSize * Math.round((float)this.y / (float)gridSize);
        }
        boolean newText = false;
        SVGTextElement element = CanvasUtilities.getSVGTextElementAt(this.canvas, evt.getPoint());
        CanvasModel model = this.canvas.getModel();
        if (element == null) {
            element = (SVGTextElement)this.createSVGElement();
            DOMUndoManager undoManager = this.canvas.getUndoManager();
            undoManager.start("Insert Text");
            try {
                model.appendChild((Element)element);
                newText = true;
            }
            finally {
                undoManager.end();
            }
            this.canvas.refresh();
        }
        editor.setSVGTextElement(element);
        ArrayList<SVGElement> selectionList = new ArrayList<SVGElement>(1);
        selectionList.add((SVGElement)element);
        this.canvas.getCanvasSelection().setSelectionList(selectionList);
        editor.startEdit();
        if (newText) {
            int length = this.initialText.length();
            TextCaret caret = editor.getCaret();
            caret.setDot(0);
            caret.moveDot(length);
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        TextEditor editor = this.canvas.getTextEditor();
        if (editor.isEditable()) {
            editor.mouseDragged(evt);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        TextEditor editor = this.canvas.getTextEditor();
        if (editor.isEditable()) {
            editor.keyTyped(evt);
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        TextEditor editor = this.canvas.getTextEditor();
        if (editor.isEditable()) {
            editor.keyPressed(evt);
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        TextEditor editor = this.canvas.getTextEditor();
        if (editor.isEditable()) {
            editor.keyReleased(evt);
        }
    }
}

