/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.GeomUtilities;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;
import org.w3c.dom.svg.SVGTransformable;

public class TranslateTool
extends AbstractTool {
    private VectorCanvas canvas;
    private Stroke stroke = new BasicStroke(1.0f);
    private int startX;
    private int startY;
    private int tx;
    private int ty;
    private List<SVGElement> selectionList = new ArrayList<SVGElement>();
    private List<Shape> outlineList = new ArrayList<Shape>();
    private List<Shape> newOutlineList = new ArrayList<Shape>();
    private Rectangle2D bounds;
    private boolean translating = false;

    @Override
    public void paint(Graphics2D g2d) {
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(this.canvas.getCanvasSelection().getStrokePaint());
        if (this.translating) {
            g2d.setStroke(this.stroke);
            for (int i = 0; i < this.newOutlineList.size(); ++i) {
                Shape shape = this.newOutlineList.get(i);
                g2d.draw(shape);
            }
        } else {
            g2d.setStroke(this.canvas.getCanvasSelection().getStroke());
            Map<String, Rectangle2D> border = this.canvas.getCanvasSelection().getBorder();
            Rectangle2D r = border.get(Integer.toString(0));
            g2d.draw(r);
            Rectangle2D handle = border.get(Integer.toString(1));
            g2d.fill(handle);
            handle = border.get(Integer.toString(3));
            g2d.fill(handle);
            handle = border.get(Integer.toString(7));
            g2d.fill(handle);
            handle = border.get(Integer.toString(9));
            g2d.fill(handle);
        }
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void startTool() {
        if (this.canvas.getCursor().getType() != 0) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.canvas.getCanvasSelection().setEnabledVisible(false, false, false);
        this.translating = false;
        this.canvas.repaint();
        this.fireMessageReceived(0, "Drag to move selection using Transform Matrix");
    }

    @Override
    public void endTool() {
        this.selectionList.clear();
        this.outlineList.clear();
        this.newOutlineList.clear();
    }

    private void updateDOM() {
        if (this.selectionList.isEmpty()) {
            return;
        }
        double[] srcPts = new double[4];
        double[] dstPts = new double[4];
        srcPts[0] = this.startX;
        srcPts[1] = this.startY;
        srcPts[2] = this.tx + this.startX;
        srcPts[3] = this.ty + this.startY;
        AffineTransform canvasAt = (AffineTransform)this.canvas.getTransform().clone();
        double[] values = new double[6];
        CanvasModel model = this.canvas.getModel();
        for (int i = 0; i < this.selectionList.size(); ++i) {
            GraphicsNode gn;
            SVGElement element = this.selectionList.get(i);
            if (!(element instanceof SVGTransformable) || (gn = model.getGraphicsNode(element)) == null) continue;
            AffineTransform at = (AffineTransform)gn.getGlobalTransform().clone();
            at.concatenate(canvasAt);
            try {
                at = at.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
            at.transform(srcPts, 0, dstPts, 0, 2);
            AffineTransform newAt = AffineTransform.getTranslateInstance(dstPts[2] - dstPts[0], dstPts[3] - dstPts[1]);
            newAt.getMatrix(values);
            SVGMatrix matrix = model.getSVGSVGElement().createSVGMatrix();
            matrix.setA((float)values[0]);
            matrix.setB((float)values[1]);
            matrix.setC((float)values[2]);
            matrix.setD((float)values[3]);
            matrix.setE((float)values[4]);
            matrix.setF((float)values[5]);
            SVGTransform transform = model.getSVGSVGElement().createSVGTransformFromMatrix(matrix);
            SVGTransformList transformList = ((SVGTransformable)element).getTransform().getBaseVal();
            transformList.appendItem(transform);
            transformList.consolidate();
        }
    }

    private void updateOutline() {
        AffineTransform at = AffineTransform.getTranslateInstance(this.tx, this.ty);
        this.newOutlineList.clear();
        for (int i = 0; i < this.outlineList.size(); ++i) {
            Shape shape = this.outlineList.get(i);
            shape = at.createTransformedShape(shape);
            this.newOutlineList.add(shape);
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        if (!this.translating) {
            return;
        }
        this.tx = evt.getX() - this.startX;
        this.ty = evt.getY() - this.startY;
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            Rectangle2D tBounds = this.canvas.getCanvasSelection().getSelectionBounds2D();
            int distanceX = (int)Math.round(tBounds.getX() % (double)gridSize);
            int distanceY = (int)Math.round(tBounds.getY() % (double)gridSize);
            this.tx = Math.round(this.tx / gridSize) * gridSize - distanceX;
            this.ty = Math.round(this.ty / gridSize) * gridSize - distanceY;
        }
        this.updateOutline();
        Rectangle2D newBounds = GeomUtilities.getBounds2D(this.newOutlineList);
        Rectangle2D.union(this.bounds, newBounds, this.bounds);
        Rectangle r = this.bounds.getBounds();
        this.canvas.repaint(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
        this.bounds = newBounds;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.startX = evt.getX();
        this.startY = evt.getY();
        this.tx = 0;
        this.ty = 0;
        this.translating = false;
        Map<String, Rectangle2D> border = this.canvas.getCanvasSelection().getBorder();
        Rectangle2D r = border.get(Integer.toString(0));
        if (!r.contains(this.startX, this.startY)) {
            return;
        }
        this.outlineList.clear();
        this.newOutlineList.clear();
        AffineTransform canvasAt = (AffineTransform)this.canvas.getTransform().clone();
        CanvasModel model = this.canvas.getModel();
        this.selectionList = CanvasUtilities.getGraphicsElement(this.canvas.getCanvasSelection().getSelectionList());
        for (int i = 0; i < this.selectionList.size(); ++i) {
            SVGElement elt = this.selectionList.get(i);
            GraphicsNode gn = model.getGraphicsNode(elt);
            if (gn == null) continue;
            Shape shape = gn.getOutline();
            AffineTransform at = (AffineTransform)canvasAt.clone();
            at.concatenate(gn.getGlobalTransform());
            shape = at.createTransformedShape(shape);
            this.outlineList.add(shape);
        }
        this.bounds = GeomUtilities.getBounds2D(this.outlineList);
        this.translating = true;
        this.canvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.outlineList.clear();
        this.newOutlineList.clear();
        if (this.translating) {
            Cursor prevCursor = this.canvas.getCursor();
            this.canvas.setCursor(Cursor.getPredefinedCursor(3));
            DOMUndoManager undoManager = this.canvas.getUndoManager();
            undoManager.start("Transform translate selections");
            try {
                this.updateDOM();
                this.canvas.refresh();
            }
            finally {
                undoManager.end();
                this.canvas.getCanvasSelection().updateBorder();
                this.translating = false;
                this.selectionList.clear();
                this.canvas.setCursor(prevCursor);
                this.canvas.repaint();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        Map<String, Rectangle2D> border = this.canvas.getCanvasSelection().getBorder();
        Rectangle2D r = border.get(Integer.toString(0));
        if (r.contains(x, y)) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.canvas.setCursor(Cursor.getDefaultCursor());
        }
    }
}

