/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.tool.ZoomTool;

public class ZoomInTool
extends ZoomTool {
    private Cursor zoomInCursor;

    public ZoomInTool() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            Dimension dim = toolkit.getBestCursorSize(32, 32);
            if (dim.getWidth() == 0.0 || dim.getHeight() == 0.0) {
                throw new RuntimeException("doesn't support custom cursor");
            }
            Image cursorImage = toolkit.getImage(this.getClass().getResource("/kiyut/sketsa/canvas/tool/zoom-in-cursor32.png"));
            this.zoomInCursor = toolkit.createCustomCursor(cursorImage, new Point(12, 12), "ZOOM_IN_CURSOR");
        }
        catch (Exception e) {
            this.zoomInCursor = Cursor.getDefaultCursor();
        }
    }

    @Override
    public void startTool() {
        super.startTool();
        this.canvas.setCursor(this.zoomInCursor);
        this.fireMessageReceived(0, "Click on canvas to Zoom In");
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        double newZoomFactor;
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        double zoomFactor = this.canvas.getZoomFactor();
        int index = 0;
        for (int i = 0; i < this.presetZoomFactor.length; ++i) {
            double preset = this.presetZoomFactor[i];
            if (!(zoomFactor < preset)) continue;
            index = i;
            break;
        }
        if (zoomFactor < (newZoomFactor = this.presetZoomFactor[index])) {
            this.canvas.setZoomFactor(newZoomFactor);
        }
    }
}

