/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.loaders;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.cookies.RevertCookie;
import kiyut.sketsa.cookies.SVGEditorCookie;
import kiyut.sketsa.cookies.SaveAsCookie;
import kiyut.sketsa.io.DefaultFileFilter;
import kiyut.sketsa.io.SVGWriter;
import kiyut.sketsa.loaders.SVGDataObject;
import kiyut.sketsa.loaders.event.SVGEditorSupportEvent;
import kiyut.sketsa.loaders.event.SVGEditorSupportListener;
import kiyut.sketsa.options.MRUFilesOptions;
import kiyut.sketsa.registration.RegistrationManager;
import kiyut.sketsa.util.IOUtilities;
import kiyut.sketsa.windows.canvas.CanvasTopComponent;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.svg.SVGDocument;

public class SVGEditorSupport
implements OpenCookie,
EditCookie,
CloseCookie,
SVGEditorCookie,
SaveAsCapable,
SaveAsCookie,
PropertyChangeListener {
    protected SVGDataObject dataObject;
    protected CanvasTopComponent editorTC;
    protected SaveCookie saveCookie = new SVGSaveCookie();
    protected RevertCookie revertCookie = new SVGRevertCookie();
    private static ListenerRegistry LISTENER_REGISTRY = new ListenerRegistry();

    public SVGEditorSupport(SVGDataObject dataObject) {
        this.dataObject = dataObject;
    }

    @Override
    public VectorCanvas getVectorCanvas() {
        if (this.editorTC == null) {
            return null;
        }
        return this.editorTC.getVectorCanvas();
    }

    @Override
    public CanvasTopComponent getVectorCanvasTopComponent() {
        return this.getCanvasTopComponent();
    }

    @Override
    public CanvasTopComponent getCanvasTopComponent() {
        if (this.editorTC == null) {
            return null;
        }
        return this.editorTC;
    }

    @Override
    public UndoRedo getUndoRedo() {
        if (this.editorTC == null) {
            return null;
        }
        return this.editorTC.getUndoRedo();
    }

    @Override
    public boolean isOpened() {
        if (this.dataObject == null) {
            return false;
        }
        return this.dataObject.isValid();
    }

    @Override
    public SVGDataObject getSVGDataObject() {
        return this.dataObject;
    }

    @Override
    public void saveAs() throws IOException {
        this.saveDocumentAs();
    }

    @Override
    public void saveAs(String path, boolean compress) throws IOException {
        this.saveDocument(path, compress);
    }

    public void saveAs(FileObject folder, String fileName) throws IOException {
        File file = FileUtil.toFile((FileObject)folder);
        boolean compress = false;
        if (fileName.toLowerCase().endsWith("svgz")) {
            compress = true;
        }
        String path = file.toString() + File.separator + fileName;
        this.saveDocument(path, compress);
    }

    public void open() {
        if (this.editorTC != null) {
            this.editorTC.requestActive();
            return;
        }
        this.dataObject.addPropertyChangeListener(this);
        SVGDocumentLoader runnable = new SVGDocumentLoader();
        RequestProcessor.getDefault().post((Runnable)runnable);
    }

    public void edit() {
        this.open();
    }

    public void revertDocument() {
        Object[] args = new Object[]{this.messageToolTip()};
        String msg = MessageFormat.format(NbBundle.getMessage(SVGEditorSupport.class, (String)"MSG_ConfirmRevert.Text"), args);
        Object choice = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)msg, NbBundle.getMessage(SVGEditorSupport.class, (String)"MSG_ConfirmRevert.Title"), 0, 3));
        if (choice != NotifyDescriptor.YES_OPTION) {
            return;
        }
        SVGDocumentLoader loader = new SVGDocumentLoader(true);
        RequestProcessor.getDefault().post((Runnable)loader);
    }

    protected TopComponent createTopComponent() {
        this.editorTC = new CanvasTopComponent();
        this.editorTC.setIcon(this.dataObject.getNodeDelegate().getIcon(1));
        this.updateName(this.editorTC);
        return this.editorTC;
    }

    protected String messageOpening() {
        return NbBundle.getMessage(DataObject.class, (String)"CTL_ObjectOpen", (Object)this.dataObject.getPrimaryEntry().getFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)this.dataObject.getPrimaryEntry().getFile()));
    }

    protected String messageOpened() {
        return NbBundle.getMessage(DataObject.class, (String)"CTL_ObjectOpened", (Object)this.dataObject.getPrimaryEntry().getFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)this.dataObject.getPrimaryEntry().getFile()));
    }

    protected String messageSave() {
        return NbBundle.getMessage(DataObject.class, (String)"MSG_SaveFile", (Object)this.dataObject.getPrimaryEntry().getFile().getNameExt());
    }

    protected String messageName() {
        if (!this.dataObject.isValid()) {
            return "";
        }
        return this.addFlagsToName(this.dataObject.getNodeDelegate().getDisplayName());
    }

    private String addFlagsToName(String name) {
        int version = 3;
        if (this.dataObject.isModified()) {
            version = !this.dataObject.getPrimaryFile().canWrite() ? 2 : 1;
        } else if (!this.dataObject.getPrimaryEntry().getFile().canWrite()) {
            version = 0;
        }
        return NbBundle.getMessage(DataObject.class, (String)"LAB_EditorName", (Object)new Integer(version), (Object)name);
    }

    protected String messageToolTip() {
        SVGDocument doc = this.dataObject.getSVGDocument();
        if (doc == null) {
            return FileUtil.getFileDisplayName((FileObject)this.dataObject.getPrimaryEntry().getFile());
        }
        String path = doc.getDocumentURI();
        if (path == null) {
            return FileUtil.getFileDisplayName((FileObject)this.dataObject.getPrimaryEntry().getFile());
        }
        try {
            URI uri = new URI(path);
            path = new File(uri).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals((Object)this.dataObject) && "modified".equals(evt.getPropertyName())) {
            if (this.dataObject.isModified()) {
                this.addSaveCookie();
            } else {
                this.removeSaveCookie();
            }
        }
        this.updateName(this.editorTC);
    }

    protected void updateName(TopComponent component) {
        String name = this.messageName();
        component.setDisplayName(name);
        component.setName(name);
        component.setToolTipText(this.messageToolTip());
    }

    protected void saveDocument() throws IOException {
        String uriString = this.dataObject.getSVGDocument().getDocumentURI();
        if (uriString != null) {
            if (!this.checkSave()) {
                return;
            }
            String path = null;
            try {
                URI uri = new URI(uriString);
                path = new File(uri).toString();
            }
            catch (URISyntaxException ex) {
                throw new IOException("URISyntaxException");
            }
            boolean compress = false;
            if (path.toLowerCase().endsWith(".svgz")) {
                compress = true;
            }
            this.saveDocument(path, compress);
        } else {
            this.saveDocumentAs();
        }
    }

    protected void saveDocumentAs() throws IOException {
        if (!this.checkSave()) {
            return;
        }
        JFileChooser fc = IOUtilities.getFileChooser();
        DefaultFileFilter svgFilter = new DefaultFileFilter();
        svgFilter.addExtension("svg");
        svgFilter.setDescription("SVG");
        DefaultFileFilter svgzFilter = new DefaultFileFilter();
        svgzFilter.addExtension("svgz");
        svgzFilter.setDescription("SVG Compressed");
        fc.addChoosableFileFilter(svgFilter);
        fc.addChoosableFileFilter(svgzFilter);
        fc.setFileFilter(svgFilter);
        int choice = fc.showSaveDialog(WindowManager.getDefault().getMainWindow());
        if (choice != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        IOUtilities.setUserDir(file);
        String path = file.toString();
        String str = path.toLowerCase();
        if (fc.getFileFilter() == svgFilter) {
            if (!str.endsWith(".svg")) {
                path = path + ".svg";
            }
        } else if (fc.getFileFilter() == svgzFilter) {
            if (!str.endsWith(".svgz")) {
                path = path + ".svgz";
            }
        } else if (!str.endsWith(".svg") && !str.endsWith(".svgz")) {
            path = path + ".svg";
        }
        boolean compress = false;
        if (path.toLowerCase().endsWith(".svgz")) {
            compress = true;
        }
        final SVGDataObject oldDataObject = this.dataObject;
        SVGDocument doc = this.dataObject.getSVGDocument();
        DataObject dob = null;
        file = new File(path);
        try {
            dob = DataObject.find((FileObject)FileUtil.toFileObject((File)file));
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (dob != null && ((SVGDataObject)dob).getSVGDocument() != null) {
            Object[] args = new Object[]{file.getName()};
            String msg = MessageFormat.format(NbBundle.getMessage(SVGEditorSupport.class, (String)"MSG_DocumentIsOpen.Text"), args);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        this.saveDocument(path, compress);
        if (dob == null) {
            try {
                dob = DataObject.find((FileObject)FileUtil.toFileObject((File)file));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (dob != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    oldDataObject.setSVGDocument(null);
                    oldDataObject.setEditorSupport(null);
                    oldDataObject.removePropertyChangeListener(SVGEditorSupport.this);
                    try {
                        oldDataObject.setValid(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    oldDataObject.dispose();
                }
            });
            this.dataObject = (SVGDataObject)dob;
            this.dataObject.setEditorSupport(this);
            this.dataObject.addPropertyChangeListener(this);
            this.dataObject.setSVGDocument(doc);
            this.addRevertCookie();
            this.editorTC.setSVGDataObject(this.dataObject);
            this.editorTC.setActivatedNodes(new Node[]{this.dataObject.getNodeDelegate()});
            this.updateName(this.editorTC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDocument(String path, boolean compress) throws IOException {
        SVGDocument doc = this.dataObject.getSVGDocument();
        if (doc == null || path == null) {
            throw new IllegalArgumentException("unable to save, parameter path is null");
        }
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(path);
            if (compress) {
                GZIPOutputStream gzip = new GZIPOutputStream(outputStream);
                outputStream = gzip;
            }
            OutputStreamWriter out = new OutputStreamWriter(outputStream, "UTF-8");
            BufferedWriter writer = new BufferedWriter(out);
            SVGWriter.write(doc, writer);
            writer.flush();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
                outputStream = null;
            }
        }
        File newFile = new File(path);
        String uri = newFile.toURI().toString();
        doc.setDocumentURI(uri);
        this.dataObject.setModified(false);
        this.updateName(this.editorTC);
        MRUFilesOptions opts = MRUFilesOptions.getInstance();
        opts.addFile(newFile.getAbsolutePath());
        SVGEditorSupportEvent evt = this.createEvent(doc, null, this.editorTC);
        SVGEditorSupport.getListenerRegistry().fireDocumentSaved(evt);
    }

    private boolean checkSave() {
        boolean b = RegistrationManager.getInstance().checkRegistration();
        return b;
    }

    protected void addSaveCookie() {
        if (this.dataObject.getCookie(SaveCookie.class) == null) {
            this.dataObject.addCookie((Node.Cookie)this.saveCookie);
            this.dataObject.setModified(true);
        }
    }

    protected void removeSaveCookie() {
        Node.Cookie cookie = this.dataObject.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            this.dataObject.removeCookie((Node.Cookie)this.saveCookie);
            this.dataObject.setModified(false);
        }
    }

    protected void addRevertCookie() {
        String uriString = this.dataObject.getSVGDocument().getDocumentURI();
        if (uriString == null) {
            return;
        }
        if (this.dataObject.getCookie(RevertCookie.class) == null) {
            this.dataObject.addCookie(this.revertCookie);
        }
    }

    protected void removeRevertCookie() {
        Node.Cookie cookie = this.dataObject.getCookie(RevertCookie.class);
        if (cookie != null && cookie.equals(this.revertCookie)) {
            this.dataObject.removeCookie(this.revertCookie);
        }
    }

    protected boolean canClose() {
        if (this.dataObject.isModified()) {
            Object choice = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)this.messageSave(), NbBundle.getMessage(SVGEditorSupport.class, (String)"MSG_ConfirmSave.Title"), 1, 3));
            if (choice == NotifyDescriptor.CANCEL_OPTION || choice == NotifyDescriptor.CLOSED_OPTION) {
                return false;
            }
            if (choice == NotifyDescriptor.YES_OPTION) {
                if (!this.checkSave()) {
                    return false;
                }
                try {
                    SaveCookie cookie = (SaveCookie)this.dataObject.getCookie(SaveCookie.class);
                    cookie.save();
                }
                catch (IOException ex) {
                    Logger logger = Logger.getLogger(this.getClass().getName());
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                    return false;
                }
                return true;
            }
            return true;
        }
        return true;
    }

    public boolean close() {
        boolean closed = this.canClose();
        if (closed) {
            SVGDocument doc = this.dataObject.getSVGDocument();
            try {
                this.dataObject.setValid(false);
                this.dataObject.setSVGDocument(null);
                this.removeRevertCookie();
            }
            catch (PropertyVetoException ex) {
                closed = false;
            }
            if (closed) {
                SVGEditorSupportEvent evt = this.createEvent(doc, null, this.editorTC);
                SVGEditorSupport.getListenerRegistry().fireDocumentClosed(evt);
            }
        }
        return closed;
    }

    void replaceSVGDocument(SVGDocument doc, SVGDocument replacedDoc) {
        SVGEditorSupportEvent evt = this.createEvent(doc, replacedDoc, this.editorTC);
        SVGEditorSupport.getListenerRegistry().fireDocumentReplaced(evt);
    }

    public static ListenerRegistry getListenerRegistry() {
        return LISTENER_REGISTRY;
    }

    SVGEditorSupportEvent createEvent(SVGDocument doc, SVGDocument replacedDoc, TopComponent tc) {
        SVGEditorSupportEvent evt = new SVGEditorSupportEvent(this, doc, replacedDoc, tc);
        return evt;
    }

    public static final class ListenerRegistry {
        private EventListenerList listenerList = new EventListenerList();

        private ListenerRegistry() {
        }

        public void addListener(SVGEditorSupportListener listener) {
            this.listenerList.add(SVGEditorSupportListener.class, listener);
        }

        public void removeListener(SVGEditorSupportListener listener) {
            this.listenerList.remove(SVGEditorSupportListener.class, listener);
        }

        private void fireDocumentCreated(SVGEditorSupportEvent evt) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != SVGEditorSupportListener.class) continue;
                ((SVGEditorSupportListener)listeners[i + 1]).documentCreated(evt);
            }
        }

        private void fireDocumentLoaded(SVGEditorSupportEvent evt) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != SVGEditorSupportListener.class) continue;
                ((SVGEditorSupportListener)listeners[i + 1]).documentLoaded(evt);
            }
        }

        private void fireDocumentReverted(SVGEditorSupportEvent evt) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != SVGEditorSupportListener.class) continue;
                ((SVGEditorSupportListener)listeners[i + 1]).documentReverted(evt);
            }
        }

        private void fireDocumentOpened(SVGEditorSupportEvent evt) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != SVGEditorSupportListener.class) continue;
                ((SVGEditorSupportListener)listeners[i + 1]).documentOpened(evt);
            }
        }

        private void fireDocumentSaved(SVGEditorSupportEvent evt) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != SVGEditorSupportListener.class) continue;
                ((SVGEditorSupportListener)listeners[i + 1]).documentSaved(evt);
            }
        }

        private void fireDocumentClosed(SVGEditorSupportEvent evt) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != SVGEditorSupportListener.class) continue;
                ((SVGEditorSupportListener)listeners[i + 1]).documentClosed(evt);
            }
        }

        private void fireDocumentReplaced(SVGEditorSupportEvent evt) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != SVGEditorSupportListener.class) continue;
                ((SVGEditorSupportListener)listeners[i + 1]).documentReplaced(evt);
            }
        }
    }

    public class SVGRevertCookie
    implements RevertCookie {
        @Override
        public void revert() {
            SVGEditorSupport.this.revertDocument();
        }
    }

    public class SVGSaveCookie
    implements SaveCookie {
        public void save() throws IOException {
            SVGEditorSupport.this.saveDocument();
        }
    }

    public class SVGDocumentLoader
    implements Runnable,
    Cancellable {
        private ProgressHandle handle;
        private boolean canCancel = true;
        private boolean revert = false;

        public SVGDocumentLoader() {
            this(false);
        }

        public SVGDocumentLoader(boolean revert) {
            this.revert = revert;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            boolean exceptionOccur = false;
            this.handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SVGEditorSupport.class, (String)"MSG_LoadingDocument.Text"), (Cancellable)this);
            this.handle.start();
            try {
                this.canCancel = true;
                SVGDocument doc = SVGEditorSupport.this.dataObject.getSVGDocument();
                if (doc == null || this.revert) {
                    doc = this.loadDocument();
                    if (doc != null) {
                        SVGEditorSupportEvent evt = SVGEditorSupport.this.createEvent(doc, null, null);
                        SVGEditorSupport.getListenerRegistry().fireDocumentLoaded(evt);
                    }
                } else {
                    SVGEditorSupportEvent evt = SVGEditorSupport.this.createEvent(doc, null, null);
                    SVGEditorSupport.getListenerRegistry().fireDocumentCreated(evt);
                }
                this.canCancel = false;
                this.openEditor(doc);
                if (!exceptionOccur) return;
            }
            catch (Exception ex) {
                try {
                    Logger logger = Logger.getLogger(this.getClass().getName());
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                    exceptionOccur = true;
                    if (!exceptionOccur) return;
                }
                catch (Throwable throwable) {
                    if (!exceptionOccur) throw throwable;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SVGDocumentLoader.this.canCancel = true;
                            if (SVGDocumentLoader.this.handle != null) {
                                SVGDocumentLoader.this.handle.finish();
                            }
                            SVGDocumentLoader.this.handle = null;
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                return;
            }
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }

        public boolean cancel() {
            return this.canCancel;
        }

        public SVGDocument loadDocument() throws IOException {
            String uri;
            SVGDocument existingDoc = SVGEditorSupport.this.dataObject.getSVGDocument();
            if (existingDoc == null) {
                File file = FileUtil.toFile((FileObject)SVGEditorSupport.this.dataObject.getPrimaryEntry().getFile());
                file = FileUtil.normalizeFile((File)file);
                uri = file.toURI().toString();
                MRUFilesOptions opts = MRUFilesOptions.getInstance();
                opts.addFile(file.getAbsolutePath());
            } else {
                uri = existingDoc.getDocumentURI();
            }
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
            this.handle.progress("Parsing ...");
            SVGDocument loadedDoc = f.createSVGDocument(uri);
            Element svgRoot = loadedDoc.getDocumentElement();
            NamedNodeMap attrMap = svgRoot.getAttributes();
            for (int i = 0; i < attrMap.getLength(); ++i) {
                Attr attr = (Attr)attrMap.item(i);
                attr.setValue(attr.getValue());
            }
            Attr attr = svgRoot.getAttributeNodeNS(null, "baseProfile");
            if (attr == null) {
                svgRoot.setAttributeNS(null, "baseProfile", "full");
            }
            this.canCancel = false;
            return loadedDoc;
        }

        public void openEditor(final SVGDocument doc) {
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        this.openEditorImpl();
                    }
                    finally {
                        SVGDocumentLoader.this.canCancel = true;
                        if (SVGDocumentLoader.this.handle != null) {
                            SVGDocumentLoader.this.handle.finish();
                        }
                        SVGDocumentLoader.this.handle = null;
                    }
                }

                public void openEditorImpl() {
                    SVGEditorSupportEvent evt;
                    CanvasTopComponent editorTC;
                    SVGDocumentLoader.this.handle.progress("Rendering ...");
                    if (!SVGDocumentLoader.this.revert) {
                        editorTC = (CanvasTopComponent)SVGEditorSupport.this.createTopComponent();
                        editorTC.setSVGDataObject(SVGEditorSupport.this.dataObject);
                        editorTC.getVectorCanvas().setSVGDocument(doc);
                        editorTC.open();
                        editorTC.setActivatedNodes(new Node[]{SVGEditorSupport.this.dataObject.getNodeDelegate()});
                        SVGEditorSupport.this.addRevertCookie();
                    } else {
                        editorTC = SVGEditorSupport.this.editorTC;
                        editorTC.getVectorCanvas().setSVGDocument(doc);
                        SVGEditorSupport.this.dataObject.setModified(false);
                        evt = SVGEditorSupport.this.createEvent(doc, null, editorTC);
                        SVGEditorSupport.getListenerRegistry().fireDocumentReverted(evt);
                    }
                    evt = SVGEditorSupport.this.createEvent(doc, null, editorTC);
                    SVGEditorSupport.getListenerRegistry().fireDocumentOpened(evt);
                    if (editorTC == null) {
                        throw new RuntimeException("CanvasTopComponent is null");
                    }
                    editorTC.requestActive();
                }
            });
        }
    }
}

