/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.tool;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import kiyut.sketsa.io.DefaultFileFilter;
import kiyut.sketsa.util.DOMUtilities;
import kiyut.sketsa.util.IOUtilities;
import kiyut.sketsa.util.UnitConversion;
import kiyut.swing.combo.SeparatorComboBox;
import kiyut.swing.dialog.DialogESC;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class ExportAsImageWindow
extends DialogESC {
    private SVGDocument svgDocument;
    private static ResourceBundle bundle = ResourceBundle.getBundle(ExportAsImageWindow.class.getName());
    private List<String[]> sizeList;
    private List<String[]> unitList;
    private List<String> dpiList;
    private String oldUnit;
    private JTextField areaHeightField;
    private JTextField areaWidthField;
    private JTextField areaXField;
    private JTextField areaYField;
    private JPanel buttonPane;
    private JButton closeButton;
    private JComboBox dpiCombo;
    private JCheckBox executeOnloadCheck;
    private JButton exportButton;
    private JLabel jLabel11;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel optionPane;
    private JTextField outputHeightField;
    private JTextField outputWidthField;
    private JProgressBar progressBar;
    private JSlider qualitySlider;
    private JComboBox sizeCombo;
    private JCheckBox transparentWhiteCheck;
    private JComboBox typeCombo;
    private JComboBox unitCombo;

    public ExportAsImageWindow(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initCustomComponents();
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.exportButton);
    }

    private void initComponents() {
        this.optionPane = new JPanel();
        this.jPanel1 = new JPanel();
        this.typeCombo = new JComboBox();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel6 = new JLabel();
        this.qualitySlider = new JSlider();
        this.transparentWhiteCheck = new JCheckBox();
        this.executeOnloadCheck = new JCheckBox();
        JPanel aoiPane = new JPanel();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        this.areaXField = new JTextField();
        this.areaYField = new JTextField();
        this.areaWidthField = new JTextField();
        this.areaHeightField = new JTextField();
        JPanel outputPane = new JPanel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel11 = new JLabel();
        this.outputWidthField = new JTextField();
        this.outputHeightField = new JTextField();
        this.sizeCombo = new SeparatorComboBox();
        this.unitCombo = new JComboBox();
        this.dpiCombo = new JComboBox();
        this.progressBar = new JProgressBar();
        this.buttonPane = new JPanel();
        this.exportButton = new JButton();
        this.closeButton = new JButton();
        this.setTitle(bundle.getString("CTL_Title.Text"));
        this.setResizable(false);
        this.optionPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.optionPane.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.typeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"PNG", "JPEG"}));
        this.typeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExportAsImageWindow.this.typeComboItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.typeCombo, gridBagConstraints);
        jLabel1.setText(bundle.getString("CTL_Type.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.jPanel1.add((Component)jLabel1, gridBagConstraints);
        jLabel6.setText(bundle.getString("CTL_Quality.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.jPanel1.add((Component)jLabel6, gridBagConstraints);
        this.qualitySlider.setMajorTickSpacing(25);
        this.qualitySlider.setMinorTickSpacing(5);
        this.qualitySlider.setPaintTicks(true);
        this.qualitySlider.setToolTipText(bundle.getString("CTL_QualitySlider.Text"));
        this.qualitySlider.setValue(100);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.qualitySlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.optionPane.add((Component)this.jPanel1, gridBagConstraints);
        this.transparentWhiteCheck.setText(bundle.getString("CTL_ForceTrannsparentWhiteCheck.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.optionPane.add((Component)this.transparentWhiteCheck, gridBagConstraints);
        this.executeOnloadCheck.setText(bundle.getString("CTL_ExecuteOnloadCheck.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.optionPane.add((Component)this.executeOnloadCheck, gridBagConstraints);
        aoiPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CTL_AOI.Text")), BorderFactory.createEmptyBorder(6, 12, 12, 12)));
        aoiPane.setLayout(new GridBagLayout());
        jLabel7.setText(bundle.getString("CTL_AreaX.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        aoiPane.add((Component)jLabel7, gridBagConstraints);
        jLabel8.setText(bundle.getString("CTL_AreaY.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        aoiPane.add((Component)jLabel8, gridBagConstraints);
        jLabel9.setText(bundle.getString("CTL_AreaWidth.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        aoiPane.add((Component)jLabel9, gridBagConstraints);
        jLabel10.setText(bundle.getString("CTL_AreaHeight.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        aoiPane.add((Component)jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        aoiPane.add((Component)this.areaXField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        aoiPane.add((Component)this.areaYField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        aoiPane.add((Component)this.areaWidthField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        aoiPane.add((Component)this.areaHeightField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.optionPane.add((Component)aoiPane, gridBagConstraints);
        outputPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CTL_Output.Text")), BorderFactory.createEmptyBorder(6, 12, 12, 12)));
        outputPane.setLayout(new GridBagLayout());
        jLabel2.setText(bundle.getString("CTL_OutputWidth.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        outputPane.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText(bundle.getString("CTL_OutputHeight.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        outputPane.add((Component)jLabel3, gridBagConstraints);
        this.jLabel4.setText(bundle.getString("CTL_OutputSize.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        outputPane.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText(bundle.getString("CTL_OutputUnit.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        outputPane.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel11.setText(bundle.getString("CTL_OutputDPIUnit.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        outputPane.add((Component)this.jLabel11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        outputPane.add((Component)this.outputWidthField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        outputPane.add((Component)this.outputHeightField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        outputPane.add((Component)this.sizeCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        outputPane.add((Component)this.unitCombo, gridBagConstraints);
        this.dpiCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        outputPane.add((Component)this.dpiCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.optionPane.add((Component)outputPane, gridBagConstraints);
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.optionPane.add((Component)this.progressBar, gridBagConstraints);
        this.buttonPane.setLayout(new GridLayout(1, 0, 6, 0));
        this.exportButton.setText(bundle.getString("CTL_ExportButton.Text"));
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportAsImageWindow.this.exportButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.exportButton);
        this.closeButton.setText(bundle.getString("CTL_CloseButton.Text"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportAsImageWindow.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        this.optionPane.add((Component)this.buttonPane, gridBagConstraints);
        this.getContentPane().add((Component)this.optionPane, "Center");
        this.pack();
    }

    private void typeComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        String type = (String)this.typeCombo.getSelectedItem();
        if (type.equalsIgnoreCase("JPEG")) {
            this.qualitySlider.setEnabled(true);
        } else {
            this.qualitySlider.setEnabled(false);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        try {
            this.validateOption();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExportAsImageWindow.this.generate();
            }
        });
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane theRootPane = super.createRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        AbstractAction actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportAsImageWindow.this.setVisible(false);
            }
        };
        InputMap inputMap = theRootPane.getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        theRootPane.getActionMap().put("ESCAPE", actionListener);
        return theRootPane;
    }

    private void initCustomComponents() {
        String[] item;
        int i;
        this.sizeList = new ArrayList<String[]>();
        this.sizeList.add(new String[]{"Custom", "", "", ""});
        this.sizeList.add(new String[]{"--", "", "", ""});
        this.sizeList.add(new String[]{"640 x 480", "640", "480", "px"});
        this.sizeList.add(new String[]{"800 x 600", "800", "600", "px"});
        this.sizeList.add(new String[]{"1024 x 768", "1024", "768", "px"});
        this.sizeList.add(new String[]{"--", "", "", ""});
        this.sizeList.add(new String[]{"A3 [297.01 x 419.95 mm]", "297.01", "419.950", "mm"});
        this.sizeList.add(new String[]{"A4 [209.97 x 297.01 mm]", "209.97", "297.01", "mm"});
        this.sizeList.add(new String[]{"A5 [148.51 x 209.97 mm]", "148.51", "209.97", "mm"});
        this.sizeList.add(new String[]{"A6 [104.99 x 148.51 mm]", "104.99", "148.51", "mm"});
        this.sizeList.add(new String[]{"B4 [250.02 x 352.98 mm]", "250.02", "352.98", "mm"});
        this.sizeList.add(new String[]{"B5 [176.02 x 250.00 mm]", "176.02", "250.00", "mm"});
        this.sizeList.add(new String[]{"US-Letter [8.50 x 11.00 in]", "8.50", "11.00", "in"});
        this.sizeList.add(new String[]{"US-Legal [8.50 x 14.00 in]", "8.50", "14.00", "in"});
        this.sizeList.add(new String[]{"--", "", "", ""});
        this.sizeList.add(new String[]{"CD Cover [120.99 x 119.97 mm]", "120.99", "119.97", "mm"});
        this.unitList = new ArrayList<String[]>();
        this.unitList.add(new String[]{"pixel", "px"});
        this.unitList.add(new String[]{"millimeter", "mm"});
        this.unitList.add(new String[]{"centimeter", "cm"});
        this.unitList.add(new String[]{"inch", "in"});
        this.unitList.add(new String[]{"point", "pt"});
        this.dpiList = new ArrayList<String>();
        this.dpiList.add("72");
        this.dpiList.add("96");
        this.dpiList.add("300");
        for (i = 0; i < this.sizeList.size(); ++i) {
            item = this.sizeList.get(i);
            this.sizeCombo.addItem(item[0]);
        }
        for (i = 0; i < this.unitList.size(); ++i) {
            item = this.unitList.get(i);
            this.unitCombo.addItem(item[0]);
        }
        for (i = 0; i < this.dpiList.size(); ++i) {
            this.dpiCombo.addItem(this.dpiList.get(i));
        }
        this.sizeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                int index = ExportAsImageWindow.this.sizeCombo.getSelectedIndex();
                if (index == 0) {
                    return;
                }
                String[] item = (String[])ExportAsImageWindow.this.sizeList.get(index);
                String unit = item[3];
                if (unit.length() < 1) {
                    unit = "px";
                }
                for (int i = 0; i < ExportAsImageWindow.this.unitList.size(); ++i) {
                    if (!unit.equals(((String[])ExportAsImageWindow.this.unitList.get(i))[1])) continue;
                    ExportAsImageWindow.this.unitCombo.setSelectedIndex(i);
                    break;
                }
                if (item[1].length() > 1) {
                    ExportAsImageWindow.this.outputWidthField.setText(item[1]);
                }
                if (item[2].length() > 1) {
                    ExportAsImageWindow.this.outputHeightField.setText(item[2]);
                }
            }
        });
        this.unitCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                int index = ExportAsImageWindow.this.unitCombo.getSelectedIndex();
                String unit = ((String[])ExportAsImageWindow.this.unitList.get(index))[1];
                try {
                    ExportAsImageWindow.this.validateOption();
                    float dpi = Float.parseFloat(ExportAsImageWindow.this.dpiCombo.getSelectedItem().toString());
                    float value = Float.parseFloat(ExportAsImageWindow.this.outputWidthField.getText());
                    ExportAsImageWindow.this.outputWidthField.setText(Float.toString((float)UnitConversion.convert(value, ExportAsImageWindow.this.oldUnit, unit, dpi)));
                    value = Float.parseFloat(ExportAsImageWindow.this.outputHeightField.getText());
                    ExportAsImageWindow.this.outputHeightField.setText(Float.toString((float)UnitConversion.convert(value, ExportAsImageWindow.this.oldUnit, unit, dpi)));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(ExportAsImageWindow.this, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
                }
                ExportAsImageWindow.this.oldUnit = unit;
            }
        });
        ActionListener sizeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ExportAsImageWindow.this.sizeCombo.getSelectedIndex() != 0) {
                    ExportAsImageWindow.this.sizeCombo.setSelectedIndex(0);
                }
            }
        };
        this.outputWidthField.addActionListener(sizeActionListener);
        this.outputHeightField.addActionListener(sizeActionListener);
        this.oldUnit = "px";
        this.sizeCombo.setSelectedIndex(0);
        this.unitCombo.setSelectedIndex(0);
        this.dpiCombo.setSelectedIndex(1);
        this.qualitySlider.setEnabled(false);
    }

    public void setArea(Rectangle2D area) {
        if (area != null) {
            this.areaXField.setText(Float.toString((float)area.getX()));
            this.areaYField.setText(Float.toString((float)area.getY()));
            this.areaWidthField.setText(Float.toString((float)area.getWidth()));
            this.areaHeightField.setText(Float.toString((float)area.getHeight()));
            this.outputWidthField.setText(Float.toString((float)area.getWidth()));
            this.outputHeightField.setText(Float.toString((float)area.getHeight()));
        }
    }

    public void setSVGDocument(SVGDocument doc) {
        this.svgDocument = doc;
    }

    private void validateOption() {
        float f = -1.0f;
        try {
            f = Float.parseFloat(this.areaXField.getText());
            if (f < 0.0f) {
                throw new RuntimeException();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidAOIX.Text"));
        }
        try {
            f = Float.parseFloat(this.areaYField.getText());
            if (f < 0.0f) {
                throw new RuntimeException();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidAOIY.Text"));
        }
        try {
            f = Float.parseFloat(this.areaWidthField.getText());
            if (f <= 0.0f) {
                throw new RuntimeException();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidAOIWidth.Text"));
        }
        try {
            f = Float.parseFloat(this.areaHeightField.getText());
            if (f <= 0.0f) {
                throw new RuntimeException();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidAOIHeight.Text"));
        }
        try {
            f = Float.parseFloat(this.dpiCombo.getSelectedItem().toString());
            if (f <= 0.0f) {
                throw new RuntimeException();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidOutputDPI.Text"));
        }
        try {
            f = Float.parseFloat(this.outputWidthField.getText());
            if (f <= 0.0f) {
                throw new RuntimeException();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidOutputWidth.Text"));
        }
        try {
            f = Float.parseFloat(this.outputHeightField.getText());
            if (f <= 0.0f) {
                throw new RuntimeException();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidOutputHeight.Text"));
        }
    }

    private Transcoder createTranscoder() {
        JPEGTranscoder t = null;
        String type = (String)this.typeCombo.getSelectedItem();
        if (type.equalsIgnoreCase("JPEG")) {
            t = new JPEGTranscoder();
            float f = (float)this.qualitySlider.getValue() / 100.0f;
            t.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(f));
        } else if (type.equalsIgnoreCase("PNG")) {
            t = new PNGTranscoder();
        } else if (type.equalsIgnoreCase("TIFF")) {
            t = new TIFFTranscoder();
        }
        t.addTranscodingHint(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE, (Object)new Boolean(this.transparentWhiteCheck.isSelected()));
        t.addTranscodingHint(SVGAbstractTranscoder.KEY_EXECUTE_ONLOAD, (Object)new Boolean(this.executeOnloadCheck.isSelected()));
        float width = Float.parseFloat(this.outputWidthField.getText());
        float height = Float.parseFloat(this.outputHeightField.getText());
        float dpi = Float.parseFloat(this.dpiCombo.getSelectedItem().toString());
        String dstUnit = "px";
        int index = this.unitCombo.getSelectedIndex();
        String srcUnit = this.unitList.get(index)[1];
        width = (float)UnitConversion.convert(width, srcUnit, dstUnit, dpi);
        height = (float)UnitConversion.convert(height, srcUnit, dstUnit, dpi);
        if (!dstUnit.equalsIgnoreCase(srcUnit)) {
            double pxToMM = (double)(1.0f / dpi) * 25.4;
            t.addTranscodingHint(SVGAbstractTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)new Float(pxToMM));
        }
        t.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)new Float(width));
        t.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)new Float(height));
        t.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_WIDTH, (Object)new Float(width));
        t.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_HEIGHT, (Object)new Float(height));
        Rectangle2D.Float rect = new Rectangle2D.Float(Float.parseFloat(this.areaXField.getText()), Float.parseFloat(this.areaYField.getText()), Float.parseFloat(this.areaWidthField.getText()), Float.parseFloat(this.areaHeightField.getText()));
        t.addTranscodingHint(SVGAbstractTranscoder.KEY_AOI, (Object)rect);
        return t;
    }

    private void updateProgress(int value) {
        Container container = this.getContentPane();
        if (container instanceof JComponent) {
            Dimension dim = this.getPreferredSize();
            JComponent comp = (JComponent)container;
            this.progressBar.setValue(value);
            comp.paintImmediately(0, 0, (int)dim.getWidth(), (int)dim.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate() {
        System.gc();
        DefaultFileFilter fileFilter = new DefaultFileFilter();
        String extension = "";
        String type = (String)this.typeCombo.getSelectedItem();
        if (type.equalsIgnoreCase("JPEG")) {
            extension = "jpg";
            fileFilter.addExtension(extension);
            fileFilter.addExtension("jpeg");
            fileFilter.setDescription("JPEG");
        } else if (type.equalsIgnoreCase("PNG")) {
            extension = "png";
            fileFilter.addExtension(extension);
            fileFilter.setDescription("PNG");
        } else if (type.equalsIgnoreCase("TIFF")) {
            extension = "tif";
            fileFilter.addExtension(extension);
            fileFilter.addExtension("tiff");
            fileFilter.setDescription("TIFF");
        }
        JFileChooser fc = IOUtilities.getFileChooser();
        fc.setFileFilter(fileFilter);
        fc.setFileSelectionMode(0);
        int choice = fc.showSaveDialog(this);
        if (choice != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        IOUtilities.setUserDir(file);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.updateProgress(0);
        this.exportButton.setEnabled(false);
        this.closeButton.setEnabled(false);
        String filename = file.toString();
        if (!filename.endsWith("." + extension)) {
            filename = filename + "." + extension;
        }
        OutputStream ostream = null;
        SVGDocument doc = null;
        try {
            Transcoder trans = this.createTranscoder();
            this.updateProgress(5);
            doc = (SVGDocument)DOMUtilities.deepCloneDocument((Document)this.svgDocument);
            TranscoderInput input = new TranscoderInput((Document)doc);
            this.updateProgress(25);
            ostream = new FileOutputStream(filename);
            TranscoderOutput output = new TranscoderOutput(ostream);
            this.updateProgress(50);
            trans.transcode(input, output);
            ostream.flush();
            this.updateProgress(100);
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        finally {
            doc = null;
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (IOException ex) {}
            }
            this.exportButton.setEnabled(true);
            this.closeButton.setEnabled(true);
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.updateProgress(0);
            System.gc();
        }
    }
}

