/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.tool;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.io.DefaultFileFilter;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.util.IOUtilities;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.Base64EncoderStream;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGImageElement;
import org.w3c.dom.svg.SVGPreserveAspectRatio;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGViewElement;

public class InsertImagePane
extends JPanel {
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.tool.InsertImagePane");
    protected boolean useImageSize = true;
    protected boolean isOptionsShown = false;
    private JPanel attributePane;
    private JButton browseButton;
    private JCheckBox embedCheck;
    private JTextField hField;
    private JTextField hrefField;
    private JTextField idField;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JButton optionsButton;
    private JPanel optionsPane;
    private JComboBox preserveAspectRatioAlignCombo;
    private JComboBox preserveAspectRatioMeetOrSliceCombo;
    private JPanel subPane;
    private JTextField wField;
    private JTextField xField;
    private JTextField yField;

    public InsertImagePane() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.optionsPane = new JPanel();
        this.jPanel2 = new JPanel();
        JLabel jLabel8 = new JLabel();
        this.idField = new JTextField();
        this.xField = new JTextField();
        this.yField = new JTextField();
        this.wField = new JTextField();
        this.hField = new JTextField();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.jPanel3 = new JPanel();
        this.preserveAspectRatioAlignCombo = new JComboBox();
        this.preserveAspectRatioMeetOrSliceCombo = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jPanel4 = new JPanel();
        this.embedCheck = new JCheckBox();
        this.attributePane = new JPanel();
        this.jPanel1 = new JPanel();
        this.hrefField = new JTextField();
        this.browseButton = new JButton();
        this.optionsButton = new JButton();
        this.subPane = new JPanel();
        this.optionsPane.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CTL_Attribute.Text")), BorderFactory.createEmptyBorder(0, 12, 5, 5)));
        this.jPanel2.setLayout(new GridBagLayout());
        jLabel8.setText(bundle.getString("CTL_ID.Text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.jPanel2.add((Component)jLabel8, gridBagConstraints);
        this.idField.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.idField, gridBagConstraints);
        this.xField.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.xField, gridBagConstraints);
        this.yField.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.yField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.wField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.hField, gridBagConstraints);
        jLabel5.setText(bundle.getString("CTL_Height.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.jPanel2.add((Component)jLabel5, gridBagConstraints);
        jLabel4.setText(bundle.getString("CTL_Width.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.jPanel2.add((Component)jLabel4, gridBagConstraints);
        jLabel3.setText(bundle.getString("CTL_Y.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.jPanel2.add((Component)jLabel3, gridBagConstraints);
        jLabel2.setText(bundle.getString("CTL_X.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.optionsPane.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CTL_PreserveAspectRatio.Text")), BorderFactory.createEmptyBorder(6, 12, 12, 12)));
        this.jPanel3.setLayout(new GridBagLayout());
        this.preserveAspectRatioAlignCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"none", "xMinYMin", "xMidYMin", "xMaxYMin", "xMinYMid", "xMidYMid", "xMaxYMid", "xMinYMax", "xMidYMax", "xMaxYMax"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        this.jPanel3.add((Component)this.preserveAspectRatioAlignCombo, gridBagConstraints);
        this.preserveAspectRatioMeetOrSliceCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"meet", "slice"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel3.add((Component)this.preserveAspectRatioMeetOrSliceCombo, gridBagConstraints);
        this.jLabel1.setText(bundle.getString("CTL_Align.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.optionsPane.add((Component)this.jPanel3, gridBagConstraints);
        this.embedCheck.setText(bundle.getString("CTL_Embed.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.optionsPane.add((Component)this.embedCheck, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        this.attributePane.setMinimumSize(new Dimension(100, 23));
        this.attributePane.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.hrefField.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.hrefField, gridBagConstraints);
        this.browseButton.setText(bundle.getString("CTL_Browse.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.browseButton, gridBagConstraints);
        this.optionsButton.setText(bundle.getString("CTL_Options.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel1.add((Component)this.optionsButton, gridBagConstraints);
        this.subPane.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.subPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.attributePane.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.attributePane, gridBagConstraints);
    }

    protected void initCustomComponents() {
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultFileFilter fileFilter = new DefaultFileFilter();
                fileFilter.addExtension("svg");
                fileFilter.addExtension("svgz");
                fileFilter.addExtension("png");
                fileFilter.addExtension("jpg");
                fileFilter.setDescription("Image Files");
                JFileChooser fc = IOUtilities.getFileChooser();
                fc.setFileFilter(fileFilter);
                fc.setFileSelectionMode(0);
                int choice = fc.showOpenDialog(InsertImagePane.this);
                if (choice != 0) {
                    return;
                }
                File file = fc.getSelectedFile();
                IOUtilities.setUserDir(file);
                InsertImagePane.this.hrefField.setText(file.toString());
                if (InsertImagePane.this.useImageSize) {
                    try {
                        ImageReader reader;
                        FileImageInputStream iis = new FileImageInputStream(file);
                        Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
                        ImageReader imageReader = reader = it.hasNext() ? it.next() : null;
                        if (reader != null) {
                            reader.setInput(iis);
                            int w = reader.getWidth(0);
                            int h = reader.getHeight(0);
                            InsertImagePane.this.wField.setText(Integer.toString(w));
                            InsertImagePane.this.hField.setText(Integer.toString(h));
                        }
                    }
                    catch (Exception ex) {
                        Logger logger = Logger.getLogger(this.getClass().getName());
                        logger.log(Level.FINE, ex.getMessage(), ex);
                    }
                }
            }
        });
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (InsertImagePane.this.isOptionsShown) {
                    InsertImagePane.this.subPane.remove(InsertImagePane.this.optionsPane);
                    InsertImagePane.this.isOptionsShown = false;
                } else {
                    InsertImagePane.this.subPane.add((Component)InsertImagePane.this.optionsPane, "Center");
                    InsertImagePane.this.isOptionsShown = true;
                }
                Container host = InsertImagePane.this.getTopLevelAncestor();
                if (host instanceof Window) {
                    ((Window)InsertImagePane.this.getTopLevelAncestor()).pack();
                }
            }
        });
    }

    public String getTitle() {
        return bundle.getString("CTL_Title.Text");
    }

    public static void showDialog(Component parentComponent, VectorCanvas canvas, Rectangle2D imageBounds) {
        int choice;
        String uri = canvas.getSVGDocument().getDocumentURI();
        if (uri == null) {
            JOptionPane.showMessageDialog(parentComponent, bundle.getString("MSG_DocumentBaseError.Text"), bundle.getString("MSG_Exception.Title"), 0);
            return;
        }
        InsertImagePane pane = new InsertImagePane();
        if (imageBounds != null) {
            if (imageBounds.isEmpty() || imageBounds.getWidth() < 10.0 || imageBounds.getHeight() < 10.0) {
                pane.setUseImageSize(true);
            } else {
                pane.setUseImageSize(false);
            }
            pane.setImageBounds(imageBounds);
        }
        if ((choice = pane.showDialogImpl(parentComponent)) == 0) {
            pane.updateVectorCanvas(canvas);
        }
    }

    private int showDialogImpl(Component parentComponent) {
        boolean valid = false;
        int choice = 2;
        while (!valid) {
            choice = JOptionPane.showConfirmDialog(parentComponent, this, this.getTitle(), 2, -1);
            if (choice == 0) {
                try {
                    this.validateInputValue();
                    valid = true;
                }
                catch (Exception ex) {
                    valid = false;
                    JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                }
                continue;
            }
            valid = true;
        }
        return choice;
    }

    private void validateInputValue() throws ParseException {
        String str = this.hrefField.getText().trim();
        if (!new File(str).exists()) {
            throw new RuntimeException(bundle.getString("MSG_FileNotExists.Text"));
        }
        str = this.xField.getText().trim();
        if (str.length() > 0) {
            DataTypeUtilities.validateLength(str);
        }
        if ((str = this.yField.getText().trim()).length() > 0) {
            DataTypeUtilities.validateLength(str);
        }
        if ((str = this.wField.getText().trim()).length() == 0) {
            throw new RuntimeException(bundle.getString("MSG_InvalidWidth.Text"));
        }
        Number number = DataTypeUtilities.validateLength(str);
        if (number.floatValue() < 0.0f) {
            throw new RuntimeException(bundle.getString("MSG_InvalidWidth.Text"));
        }
        str = this.hField.getText().trim();
        if (str.length() == 0) {
            throw new RuntimeException(bundle.getString("MSG_InvalidHeight.Text"));
        }
        number = DataTypeUtilities.validateLength(str);
        if (number.floatValue() < 0.0f) {
            throw new RuntimeException(bundle.getString("MSG_InvalidHeight.Text"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVectorCanvas(VectorCanvas canvas) {
        Logger logger;
        String defaultStr;
        SVGElement elt;
        try {
            this.validateInputValue();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
        }
        SVGDocument doc = canvas.getSVGDocument();
        boolean svgVector = false;
        File file = new File(this.hrefField.getText().trim());
        String hrefSource = null;
        if (!this.embedCheck.isSelected()) {
            try {
                URI baseUri = new URI(doc.getDocumentURI());
                File baseFile = new File(baseUri);
                hrefSource = IOUtilities.relativize(baseFile, file);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, bundle.getString("MSG_InvalidDocumentBase.Text") + ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
                return;
            }
            elt = (SVGElement)doc.createElementNS("http://www.w3.org/2000/svg", "image");
            elt.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", hrefSource);
        } else {
            try {
                elt = this.embed(doc, file);
                if (elt == null) {
                    throw new RuntimeException(bundle.getString("MSG_EmbedError.Text"));
                }
                if (elt instanceof SVGSVGElement) {
                    svgVector = true;
                }
            }
            catch (Exception ex) {
                Logger logger2 = Logger.getLogger(this.getClass().getName());
                logger2.log(Level.FINE, ex.getMessage(), ex);
                JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
                return;
            }
        }
        String id = this.idField.getText().trim();
        if (id.length() > 0) {
            elt.setId(id);
        }
        String attrName = "x";
        String str = this.xField.getText().trim();
        if (str.length() > 0) {
            defaultStr = "0";
            try {
                if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                    elt.setAttributeNS(null, attrName, str);
                }
            }
            catch (ParseException ex) {
                logger = Logger.getLogger(this.getClass().getName());
                logger.log(Level.FINE, ex.getMessage(), ex);
            }
        }
        attrName = "y";
        str = this.yField.getText().trim();
        if (str.length() > 0) {
            defaultStr = "0";
            try {
                if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                    elt.setAttributeNS(null, attrName, str);
                }
            }
            catch (ParseException ex) {
                logger = Logger.getLogger(this.getClass().getName());
                logger.log(Level.FINE, ex.getMessage(), ex);
            }
        }
        if (!svgVector) {
            attrName = "width";
            str = this.wField.getText().trim();
            elt.setAttributeNS(null, attrName, str);
            attrName = "height";
            str = this.hField.getText().trim();
            elt.setAttributeNS(null, attrName, str);
        }
        short align = 6;
        short meetOrSlice = 1;
        int index = this.preserveAspectRatioAlignCombo.getSelectedIndex();
        switch (index) {
            case 0: {
                align = 1;
                break;
            }
            case 1: {
                align = 2;
                break;
            }
            case 2: {
                align = 3;
                break;
            }
            case 3: {
                align = 4;
                break;
            }
            case 4: {
                align = 5;
                break;
            }
            case 5: {
                align = 6;
                break;
            }
            case 6: {
                align = 7;
                break;
            }
            case 7: {
                align = 8;
                break;
            }
            case 8: {
                align = 9;
                break;
            }
            case 9: {
                align = 10;
            }
        }
        switch (index) {
            case 0: {
                meetOrSlice = 1;
                break;
            }
            case 1: {
                meetOrSlice = 2;
            }
        }
        boolean isDefault = false;
        if (!svgVector && align == 6 && meetOrSlice == 1) {
            isDefault = true;
        }
        if (!isDefault) {
            SVGPreserveAspectRatio preserveAspectRatio = null;
            if (elt instanceof SVGImageElement) {
                preserveAspectRatio = ((SVGImageElement)elt).getPreserveAspectRatio().getBaseVal();
            } else if (elt instanceof SVGViewElement) {
                preserveAspectRatio = ((SVGViewElement)elt).getPreserveAspectRatio().getBaseVal();
            }
            if (preserveAspectRatio != null) {
                preserveAspectRatio.setAlign(align);
                preserveAspectRatio.setMeetOrSlice(meetOrSlice);
            }
        }
        DOMUndoManager undoManager = canvas.getUndoManager();
        undoManager.start("Insert Image");
        try {
            doc.getDocumentElement().appendChild((Node)elt);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
        }
        finally {
            undoManager.end();
        }
        ArrayList<SVGElement> list = new ArrayList<SVGElement>(1);
        list.add(elt);
        canvas.getCanvasSelection().setSelectionList(list);
        canvas.refresh();
    }

    public void setUseImageSize(boolean b) {
        this.useImageSize = b;
    }

    public boolean isUseImageSize() {
        return this.useImageSize;
    }

    public void setImageBounds(Rectangle2D imageBounds) {
        if (imageBounds == null) {
            return;
        }
        this.xField.setText(Float.toString((float)imageBounds.getX()));
        this.yField.setText(Float.toString((float)imageBounds.getY()));
        if (imageBounds.getWidth() > 10.0 && imageBounds.getHeight() > 10.0) {
            this.wField.setText(Float.toString((float)imageBounds.getWidth()));
            this.hField.setText(Float.toString((float)imageBounds.getHeight()));
        }
    }

    protected SVGElement embed(SVGDocument doc, File file) throws IOException {
        String suffix = "unknown";
        String filename = file.getName();
        int indexOf = filename.lastIndexOf(".");
        if (indexOf > 0) {
            suffix = filename.substring(indexOf + 1).toLowerCase();
        }
        if (suffix.equals("svg") || suffix.equals("svgz")) {
            return this.embedAsSVG(doc, file);
        }
        return this.embedAsBase64(doc, file);
    }

    protected SVGElement embedAsSVG(SVGDocument doc, File file) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        SVGDocument imgDoc = f.createSVGDocument(file.toURI().toString());
        SVGSVGElement rootElt = imgDoc.getRootElement();
        SVGElement elt = (SVGElement)doc.importNode((Node)rootElt, true);
        elt.setAttributeNS(null, "width", "100%");
        elt.setAttributeNS(null, "height", "100%");
        return elt;
    }

    protected SVGElement embedAsBase64(SVGDocument doc, File file) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        Base64EncoderStream out = new Base64EncoderStream((OutputStream)os, true);
        while (in.read(data) != -1) {
            out.write(data);
        }
        out.close();
        String suffix = "unknown";
        String filename = file.getName();
        int indexOf = filename.lastIndexOf(".");
        if (indexOf > 0) {
            suffix = filename.substring(indexOf + 1).toLowerCase();
        }
        if (suffix.equals("jpg")) {
            suffix = "jpeg";
        }
        String dataProtocol = "data:image/" + suffix + ";base64," + System.getProperty("line.separator") + os.toString();
        SVGImageElement imgElt = (SVGImageElement)doc.createElementNS("http://www.w3.org/2000/svg", "image");
        imgElt.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", dataProtocol);
        return imgElt;
    }
}

