/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.domeditor;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import kiyut.sketsa.cookies.SVGEditorCookie;
import kiyut.sketsa.loaders.SVGEditorSupport;
import kiyut.sketsa.loaders.event.SVGEditorSupportEvent;
import kiyut.sketsa.loaders.event.SVGEditorSupportListenerAdapter;
import kiyut.sketsa.windows.domeditor.DOMEditor;
import org.openide.awt.UndoRedo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="DOMEditorTopComponent", persistenceType=0)
public final class DOMEditorTopComponent
extends TopComponent {
    private Lookup.Result<SVGEditorCookie> result;
    private LookupListener editorCookieLookupListener;
    private UndoRedo undoRedo;
    private DOMEditor domEditor;

    private DOMEditorTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(DOMEditorTopComponent.class, (String)"CTL_DOMEditorTopComponent"));
        this.setToolTipText(NbBundle.getMessage(DOMEditorTopComponent.class, (String)"HINT_DOMEditorTopComponent"));
        this.initCustomComponents();
        this.editorCookieLookupListener = new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                DOMEditorTopComponent.this.editorCookieLookupListenerResultChanged(lookupEvent);
            }
        };
        SVGEditorSupport.getListenerRegistry().addListener(new SVGEditorSupportListenerAdapter(){

            @Override
            public void documentReplaced(SVGEditorSupportEvent evt) {
                this.lookupListenerResultChanged(evt);
            }

            @Override
            public void documentClosed(SVGEditorSupportEvent evt) {
                this.lookupListenerResultChanged(evt);
            }

            private void lookupListenerResultChanged(SVGEditorSupportEvent evt) {
                TopComponent tc = evt.getTopComponent();
                if (tc != null) {
                    DOMEditorTopComponent.this.editorCookieLookupListenerResultChanged(null);
                }
            }
        });
        this.result = Utilities.actionsGlobalContext().lookupResult(SVGEditorCookie.class);
        this.result.addLookupListener(this.editorCookieLookupListener);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public UndoRedo getUndoRedo() {
        if (this.undoRedo == null) {
            return super.getUndoRedo();
        }
        return this.undoRedo;
    }

    private void initCustomComponents() {
        this.domEditor = new DOMEditor();
        this.add("Center", this.domEditor);
        ActionMap tcActionMap = this.getActionMap();
        ActionMap editorActionMap = this.domEditor.getActionMap();
        tcActionMap.setParent(editorActionMap);
        CallbackSystemAction callDeleteAction = (CallbackSystemAction)SystemAction.get(org.openide.actions.DeleteAction.class);
        editorActionMap.put(callDeleteAction.getActionMapKey(), new DeleteAction());
    }

    private void editorCookieLookupListenerResultChanged(LookupEvent evt) {
        Collection c = this.result.allInstances();
        if (!c.isEmpty()) {
            SVGEditorCookie cookie = (SVGEditorCookie)c.iterator().next();
            if (cookie.isOpened()) {
                this.domEditor.putVectorCanvas(cookie.getVectorCanvas());
                this.undoRedo = cookie.getUndoRedo();
            } else {
                this.domEditor.removeVectorCanvas(cookie.getVectorCanvas());
                this.undoRedo = null;
            }
        }
    }

    public class DeleteAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            DOMEditorTopComponent.this.domEditor.removeSelected();
        }
    }
}

