/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DOMUtilities;
import kiyut.sketsa.windows.properties.AbstractGraphicsProperties;
import kiyut.sketsa.windows.properties.geometry.CircleGeometryProperties;
import kiyut.sketsa.windows.properties.geometry.DefaultElementGeometryProperties;
import kiyut.sketsa.windows.properties.geometry.ElementGeometryProperties;
import kiyut.sketsa.windows.properties.geometry.EllipseGeometryProperties;
import kiyut.sketsa.windows.properties.geometry.ImageGeometryProperties;
import kiyut.sketsa.windows.properties.geometry.LineGeometryProperties;
import kiyut.sketsa.windows.properties.geometry.PathGeometryProperties;
import kiyut.sketsa.windows.properties.geometry.PolygonGeometryProperties;
import kiyut.sketsa.windows.properties.geometry.PolylineGeometryProperties;
import kiyut.sketsa.windows.properties.geometry.RectangleGeometryProperties;
import kiyut.sketsa.windows.properties.geometry.SVGGeometryProperties;
import kiyut.sketsa.windows.properties.geometry.TextGeometryProperties;
import kiyut.sketsa.windows.properties.geometry.UseGeometryProperties;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGStylable;

public class GeometryProperties
extends AbstractGraphicsProperties {
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.windows.properties.GeometryProperties");
    private static final String UNKNOWN_ELEMENT = "unknown_element_geometry";
    protected SVGElement element;
    protected EventListener domListener;
    protected Map<String, ElementGeometryProperties> elementPropertyMap;
    protected boolean refreshing;
    protected boolean editing;
    private JPanel commonPane;
    private JComboBox displayCombo;
    private JPanel elementPane;
    private JTextField idField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JPanel mainPane;
    private JLabel nameLabel;
    private JComboBox visibilityCombo;

    public GeometryProperties() {
        this.initComponents();
        this.initCustomComponents();
        this.domListener = new EventListener(){

            @Override
            public void handleEvent(Event e) {
                GeometryProperties.this.domNodeHandleEvent(e);
            }
        };
        this.refreshing = false;
        this.editing = false;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.mainPane = new JPanel();
        this.nameLabel = new JLabel();
        this.commonPane = new JPanel();
        JLabel jLabel8 = new JLabel();
        this.idField = new JTextField();
        this.jLabel1 = new JLabel();
        this.visibilityCombo = new JComboBox();
        this.jLabel2 = new JLabel();
        this.displayCombo = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.elementPane = new JPanel();
        this.setLayout(new BorderLayout());
        this.mainPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.mainPane.setLayout(new GridBagLayout());
        this.nameLabel.setText("Object");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.mainPane.add((Component)this.nameLabel, gridBagConstraints);
        this.commonPane.setLayout(new GridBagLayout());
        jLabel8.setText(bundle.getString("CTL_ID.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.commonPane.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.commonPane.add((Component)this.idField, gridBagConstraints);
        this.jLabel1.setText(bundle.getString("CTL_Visibility.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.commonPane.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.commonPane.add((Component)this.visibilityCombo, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("CTL_Display.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.commonPane.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.commonPane.add((Component)this.displayCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.mainPane.add((Component)this.commonPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.mainPane.add((Component)this.jSeparator1, gridBagConstraints);
        this.elementPane.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.mainPane.add((Component)this.elementPane, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.mainPane);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void initCustomComponents() {
        this.elementPropertyMap = new HashMap<String, ElementGeometryProperties>();
        this.elementPropertyMap.put("rect", new RectangleGeometryProperties());
        this.elementPropertyMap.put("circle", new CircleGeometryProperties());
        this.elementPropertyMap.put("ellipse", new EllipseGeometryProperties());
        this.elementPropertyMap.put("line", new LineGeometryProperties());
        this.elementPropertyMap.put("polyline", new PolylineGeometryProperties());
        this.elementPropertyMap.put("polygon", new PolygonGeometryProperties());
        this.elementPropertyMap.put("path", new PathGeometryProperties());
        this.elementPropertyMap.put("image", new ImageGeometryProperties());
        this.elementPropertyMap.put("use", new UseGeometryProperties());
        this.elementPropertyMap.put("svg", new SVGGeometryProperties());
        this.elementPropertyMap.put("text", new TextGeometryProperties());
        this.elementPropertyMap.put(UNKNOWN_ELEMENT, new DefaultElementGeometryProperties());
        this.visibilityCombo.addItem("visible");
        this.visibilityCombo.addItem("hidden");
        this.visibilityCombo.addItem("collapse");
        this.visibilityCombo.addItem("inherit");
        this.displayCombo.addItem("inline");
        this.displayCombo.addItem("block");
        this.displayCombo.addItem("run-in");
        this.displayCombo.addItem("compact");
        this.displayCombo.addItem("marker");
        this.displayCombo.addItem("table");
        this.displayCombo.addItem("inline-table");
        this.displayCombo.addItem("table-row-group");
        this.displayCombo.addItem("table-header-group");
        this.displayCombo.addItem("table-footer-group");
        this.displayCombo.addItem("table-row");
        this.displayCombo.addItem("table-column-group");
        this.displayCombo.addItem("table-column");
        this.displayCombo.addItem("table-cell");
        this.displayCombo.addItem("table-caption");
        this.displayCombo.addItem("none");
        this.displayCombo.addItem("inherit");
        this.idField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeometryProperties.this.idFieldActionPerformed(evt);
            }
        });
        this.visibilityCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GeometryProperties.this.visibilityComboItemStateChanged(evt);
            }
        });
        this.displayCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GeometryProperties.this.displayComboItemStateChanged(evt);
            }
        });
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        super.setVectorCanvas(canvas);
        for (ElementGeometryProperties elementProperty : this.elementPropertyMap.values()) {
            elementProperty.setVectorCanvas(canvas);
            elementProperty.setSVGElement(null);
        }
    }

    @Override
    public void setSelectionList(List selectionList) {
        SVGElement old = this.element;
        if (old != null) {
            ((EventTarget)old).removeEventListener("DOMAttrModified", this.domListener, false);
        }
        if (selectionList.size() == 1) {
            Node node = (Node)selectionList.get(0);
            if (node instanceof SVGElement) {
                this.element = (SVGElement)node;
                if (this.element != null) {
                    ((EventTarget)this.element).addEventListener("DOMAttrModified", this.domListener, false);
                }
            } else {
                this.element = null;
            }
        } else {
            this.element = null;
        }
        ElementGeometryProperties elementProperty = null;
        if (this.element != null) {
            this.idField.setEnabled(true);
            this.nameLabel.setText("<" + this.element.getNodeName() + ">");
            SVGSVGElement root = this.canvas.getSVGDocument().getRootElement();
            if (this.element.equals(root)) {
                this.displayCombo.setEnabled(false);
            } else {
                elementProperty = this.elementPropertyMap.get(this.element.getNodeName());
                if (elementProperty != null) {
                    elementProperty.setSVGElement(this.element);
                }
                this.displayCombo.setEnabled(true);
            }
        } else {
            this.idField.setEnabled(false);
            this.idField.setText("");
            int size = selectionList.size();
            this.nameLabel.setText(size + " " + bundle.getString("MSG_ObjectsSelected.Text"));
            this.displayCombo.setEnabled(true);
        }
        if (elementProperty == null) {
            elementProperty = this.elementPropertyMap.get(UNKNOWN_ELEMENT);
        }
        this.elementPane.removeAll();
        this.elementPane.add("Center", elementProperty);
        super.setSelectionList(selectionList);
    }

    @Override
    public void refresh() {
        if (this.editing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (this.selectionList == null) {
            return;
        }
        this.refreshing = true;
        if (this.element != null) {
            this.idField.setText(this.element.getId());
        }
        String display = null;
        String visibility = null;
        boolean multiDisplay = false;
        boolean multiVisibility = false;
        for (int i = 0; i < this.selectionList.size(); ++i) {
            String str;
            SVGElement elt;
            Node node = (Node)this.selectionList.get(i);
            if (!(node instanceof SVGElement) || !((elt = (SVGElement)node) instanceof SVGStylable)) continue;
            ViewCSS viewCSS = (ViewCSS)((Object)elt.getOwnerDocument().getDocumentElement());
            CSSStyleDeclaration computedStyle = viewCSS.getComputedStyle((Element)elt, null);
            if (!multiDisplay) {
                try {
                    str = computedStyle.getPropertyValue("display");
                    if (display == null) {
                        display = str;
                    }
                    if (!display.equals(str)) {
                        multiDisplay = true;
                    }
                }
                catch (DOMException dex) {
                    multiDisplay = true;
                }
            }
            if (multiVisibility) continue;
            try {
                str = computedStyle.getPropertyValue("visibility");
                if (visibility == null) {
                    visibility = str;
                }
                if (visibility.equals(str)) continue;
                multiVisibility = true;
                continue;
            }
            catch (DOMException dex) {
                multiVisibility = true;
            }
        }
        if (!multiDisplay && display != null) {
            this.displayCombo.setSelectedItem(display);
        } else {
            this.displayCombo.setSelectedIndex(-1);
        }
        if (!multiVisibility && visibility != null) {
            this.visibilityCombo.setSelectedItem(visibility);
        } else {
            this.visibilityCombo.setSelectedIndex(-1);
        }
        ElementGeometryProperties elementProperty = (ElementGeometryProperties)this.elementPane.getComponent(0);
        elementProperty.refreshProperties();
        this.refreshing = false;
    }

    private void domNodeHandleEvent(Event evt) {
        if (evt.getType().equalsIgnoreCase("DOMAttrModified")) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void idFieldActionPerformed(ActionEvent evt) {
        String id = this.idField.getText().trim();
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Element Id");
        try {
            if (id.length() > 0) {
                this.element.setId(id);
            } else {
                this.element.removeAttributeNS(null, "id");
            }
        }
        catch (Exception ex) {
            this.refresh();
        }
        finally {
            undoManager.end();
            this.editing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visibilityComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        JComboBox combo = (JComboBox)evt.getSource();
        String value = (String)combo.getSelectedItem();
        String attr = "visibility";
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Visibility Property");
        try {
            for (int i = 0; i < this.selectionList.size(); ++i) {
                Node node = (Node)this.selectionList.get(i);
                if (!(node instanceof SVGStylable)) continue;
                if (value.equals("inherit")) {
                    DOMUtilities.updateProperty((SVGStylable)node, null, attr, null);
                    continue;
                }
                DOMUtilities.updateProperty((SVGStylable)node, null, attr, value);
            }
        }
        catch (Exception ex) {
            this.editing = false;
            this.refresh();
        }
        finally {
            undoManager.end();
            this.editing = false;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GeometryProperties.this.canvas.refresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        JComboBox combo = (JComboBox)evt.getSource();
        String value = (String)combo.getSelectedItem();
        String attr = "display";
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Display Property");
        try {
            for (int i = 0; i < this.selectionList.size(); ++i) {
                Node node = (Node)this.selectionList.get(i);
                if (!(node instanceof SVGStylable)) continue;
                if (value.equals("inherit")) {
                    DOMUtilities.updateProperty((SVGStylable)node, null, attr, null);
                    continue;
                }
                DOMUtilities.updateProperty((SVGStylable)node, null, attr, value);
            }
        }
        catch (Exception ex) {
            this.editing = false;
            this.refresh();
        }
        finally {
            undoManager.end();
            this.editing = false;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GeometryProperties.this.canvas.refresh();
            }
        });
    }
}

