/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.properties.geometry;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.windows.properties.geometry.ElementGeometryProperties;
import org.w3c.dom.svg.SVGEllipseElement;

public class EllipseGeometryProperties
extends ElementGeometryProperties {
    private boolean editing;
    private JPanel attributePane;
    private JTextField cxField;
    private JTextField cyField;
    private JTextField rxField;
    private JTextField ryField;

    public EllipseGeometryProperties() {
        this.initComponents();
        this.initCustomComponents();
        this.editing = false;
    }

    private void initComponents() {
        this.attributePane = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.cxField = new JTextField();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        this.cyField = new JTextField();
        this.rxField = new JTextField();
        this.ryField = new JTextField();
        this.setLayout(new BorderLayout());
        this.attributePane.setLayout(new GridBagLayout());
        jLabel2.setText("cx");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.attributePane.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.attributePane.add((Component)this.cxField, gridBagConstraints);
        jLabel3.setText("cy");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText("rx");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel4, gridBagConstraints);
        jLabel5.setText("ry");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.cyField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.rxField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.ryField, gridBagConstraints);
        this.add((Component)this.attributePane, "North");
    }

    private void initCustomComponents() {
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EllipseGeometryProperties.this.fieldActionPerformed(e);
            }
        };
        this.cxField.addActionListener(fieldActionHandler);
        this.cyField.addActionListener(fieldActionHandler);
        this.rxField.addActionListener(fieldActionHandler);
        this.ryField.addActionListener(fieldActionHandler);
    }

    @Override
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        SVGEllipseElement ellipseElement = (SVGEllipseElement)this.element;
        try {
            this.cxField.setText(ellipseElement.getAttributeNS(null, "cx"));
        }
        catch (Exception ex) {
            this.cxField.setText("");
        }
        try {
            this.cyField.setText(ellipseElement.getAttributeNS(null, "cy"));
        }
        catch (Exception ex) {
            this.cyField.setText("");
        }
        try {
            this.rxField.setText(ellipseElement.getAttributeNS(null, "rx"));
        }
        catch (Exception ex) {
            this.rxField.setText("");
        }
        try {
            this.ryField.setText(ellipseElement.getAttributeNS(null, "ry"));
        }
        catch (Exception ex) {
            this.ryField.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fieldActionPerformed(ActionEvent e) {
        SVGEllipseElement elt = (SVGEllipseElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Ellipse geometry attributes");
        try {
            String attrName = "cx";
            String str = this.cxField.getText().trim();
            DataTypeUtilities.validateLength(str);
            elt.setAttributeNS(null, attrName, str);
            attrName = "cy";
            str = this.cyField.getText().trim();
            DataTypeUtilities.validateLength(str);
            elt.setAttributeNS(null, attrName, str);
            attrName = "rx";
            str = this.rxField.getText().trim();
            Number number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException(bundle.getString("MSG_NegativeRX.Text"));
            }
            elt.setAttributeNS(null, attrName, str);
            attrName = "ry";
            str = this.ryField.getText().trim();
            number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException(bundle.getString("MSG_NegativeRY.Text"));
            }
            elt.setAttributeNS(null, attrName, str);
        }
        catch (Exception ex) {
            this.refreshProperties();
            JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
        }
        if (this.canvas != null) {
            this.canvas.refresh();
        }
    }
}

