/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.properties.geometry;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.windows.properties.geometry.ElementGeometryProperties;
import org.w3c.dom.svg.SVGLineElement;

public class LineGeometryProperties
extends ElementGeometryProperties {
    private boolean editing;
    private JPanel attributePane;
    private JTextField x1Field;
    private JTextField x2Field;
    private JTextField y1Field;
    private JTextField y2Field;

    public LineGeometryProperties() {
        this.initComponents();
        this.initCustomComponents();
        this.editing = false;
    }

    private void initComponents() {
        this.attributePane = new JPanel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        this.x1Field = new JTextField();
        this.y1Field = new JTextField();
        this.x2Field = new JTextField();
        this.y2Field = new JTextField();
        this.setLayout(new BorderLayout());
        this.attributePane.setLayout(new GridBagLayout());
        jLabel2.setText("x1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.attributePane.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText("y1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText("x2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel4, gridBagConstraints);
        jLabel5.setText("y2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.attributePane.add((Component)this.x1Field, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.y1Field, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.x2Field, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.y2Field, gridBagConstraints);
        this.add((Component)this.attributePane, "First");
    }

    private void initCustomComponents() {
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LineGeometryProperties.this.fieldActionPerformed(e);
            }
        };
        this.x1Field.addActionListener(fieldActionHandler);
        this.y1Field.addActionListener(fieldActionHandler);
        this.x2Field.addActionListener(fieldActionHandler);
        this.y2Field.addActionListener(fieldActionHandler);
    }

    @Override
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        try {
            this.x1Field.setText(this.element.getAttributeNS(null, "x1"));
        }
        catch (Exception ex) {
            this.x1Field.setText("");
        }
        try {
            this.y1Field.setText(this.element.getAttributeNS(null, "y1"));
        }
        catch (Exception ex) {
            this.y1Field.setText("");
        }
        try {
            this.x2Field.setText(this.element.getAttributeNS(null, "x2"));
        }
        catch (Exception ex) {
            this.x2Field.setText("");
        }
        try {
            this.y2Field.setText(this.element.getAttributeNS(null, "y2"));
        }
        catch (Exception ex) {
            this.y2Field.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fieldActionPerformed(ActionEvent e) {
        SVGLineElement elt = (SVGLineElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Line attributes");
        try {
            String attrName = "x1";
            String str = this.x1Field.getText().trim();
            DataTypeUtilities.validateLength(str);
            elt.setAttributeNS(null, attrName, str);
            attrName = "y1";
            str = this.y1Field.getText().trim();
            DataTypeUtilities.validateLength(str);
            elt.setAttributeNS(null, attrName, str);
            attrName = "x2";
            str = this.x2Field.getText().trim();
            DataTypeUtilities.validateLength(str);
            elt.setAttributeNS(null, attrName, str);
            attrName = "y2";
            str = this.y2Field.getText().trim();
            DataTypeUtilities.validateLength(str);
            elt.setAttributeNS(null, attrName, str);
        }
        catch (Exception ex) {
            this.refreshProperties();
            JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
        }
        if (this.canvas != null) {
            this.canvas.refresh();
        }
    }
}

