/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.properties.geometry;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.GeomUtilities;
import kiyut.sketsa.windows.properties.geometry.ElementGeometryProperties;
import kiyut.swing.combo.SeparatorComboBox;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPathSegArcRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothRel;
import org.w3c.dom.svg.SVGPathSegLinetoAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalRel;
import org.w3c.dom.svg.SVGPathSegLinetoRel;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalRel;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPathSegMovetoRel;

public class PathGeometryProperties
extends ElementGeometryProperties {
    private boolean refreshing;
    private boolean editing;
    private JTextField angleField;
    private JPanel attributePane;
    private JTextField cpx1Field;
    private JTextField cpx2Field;
    private JTextField cpy1Field;
    private JTextField cpy2Field;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JCheckBox largeArcCheck;
    private JPanel mainPane;
    private JTable pointTable;
    private JTextField rxField;
    private JTextField ryField;
    private JCheckBox sweepCheck;
    private JComboBox typeCombo;
    private JTextField xField;
    private JTextField yField;

    public PathGeometryProperties() {
        this.initComponents();
        this.initCustomComponents();
        this.editing = false;
        this.refreshing = false;
    }

    private void initComponents() {
        this.mainPane = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.pointTable = new JTable();
        this.attributePane = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.xField = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.yField = new JTextField();
        JLabel jLabel4 = new JLabel();
        this.cpx1Field = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.cpx2Field = new JTextField();
        JLabel jLabel6 = new JLabel();
        this.rxField = new JTextField();
        JLabel jLabel7 = new JLabel();
        this.angleField = new JTextField();
        JLabel jLabel8 = new JLabel();
        this.cpy1Field = new JTextField();
        JLabel jLabel9 = new JLabel();
        this.cpy2Field = new JTextField();
        JLabel jLabel10 = new JLabel();
        this.ryField = new JTextField();
        this.largeArcCheck = new JCheckBox();
        this.sweepCheck = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.typeCombo = new SeparatorComboBox();
        this.setLayout(new BorderLayout());
        this.mainPane.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(100, 60));
        this.pointTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Point", "Value"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.pointTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.mainPane.add((Component)this.jScrollPane1, gridBagConstraints);
        this.attributePane.setLayout(new GridBagLayout());
        jLabel2.setText("x");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.xField, gridBagConstraints);
        jLabel3.setText("y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.attributePane.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.yField, gridBagConstraints);
        jLabel4.setText("x1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.cpx1Field, gridBagConstraints);
        jLabel5.setText("x2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.cpx2Field, gridBagConstraints);
        jLabel6.setText("rx");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.rxField, gridBagConstraints);
        jLabel7.setText("angle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.angleField, gridBagConstraints);
        jLabel8.setText("y1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.attributePane.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.cpy1Field, gridBagConstraints);
        jLabel9.setText("y2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.attributePane.add((Component)jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.cpy2Field, gridBagConstraints);
        jLabel10.setText("ry");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.attributePane.add((Component)jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.ryField, gridBagConstraints);
        this.largeArcCheck.setText("Large arc");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.largeArcCheck, gridBagConstraints);
        this.sweepCheck.setText("Sweep");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.attributePane.add((Component)this.sweepCheck, gridBagConstraints);
        this.jLabel1.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.attributePane.add((Component)this.jLabel1, gridBagConstraints);
        this.typeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"M (moveto)", "L (lineto)", "H (horizontal lineto)", "V (vertical lineto)", "C (curveto)", "S (smooth curveto)", "Q (quadratic B\u00e9zier)", "T (smooth quadratic B\u00e9zier)", "A (elliptical arc)", "Z (closepath)", "--", "m (moveto)", "l (lineto)", "h (horizontal lineto)", "v (vertical lineto)", "c (curveto)", "s (smooth curveto)", "q (quadratic B\u00e9zier)", "t (smooth quadratic B\u00e9zier)", "a (elliptical arc)", "z (closepath)"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.attributePane.add((Component)this.typeCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.mainPane.add((Component)this.attributePane, gridBagConstraints);
        this.add((Component)this.mainPane, "Center");
    }

    private void initCustomComponents() {
        PointTableModel pointTableModel = new PointTableModel();
        this.pointTable.setModel(pointTableModel);
        TableColumn tableColumn = this.pointTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(34);
        tableColumn.setMaxWidth(100);
        this.pointTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PathGeometryProperties.this.selectionValueChanged(e);
            }
        });
        this.typeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PathGeometryProperties.this.typeComboItemStateChanged(evt);
            }
        });
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathGeometryProperties.this.fieldActionPerformed(e);
            }
        };
        this.xField.addActionListener(fieldActionHandler);
        this.yField.addActionListener(fieldActionHandler);
        this.cpx1Field.addActionListener(fieldActionHandler);
        this.cpy1Field.addActionListener(fieldActionHandler);
        this.cpx2Field.addActionListener(fieldActionHandler);
        this.cpy2Field.addActionListener(fieldActionHandler);
        this.rxField.addActionListener(fieldActionHandler);
        this.ryField.addActionListener(fieldActionHandler);
        this.angleField.addActionListener(fieldActionHandler);
        ItemListener itemHandler = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PathGeometryProperties.this.arcCheckBoxItemStateChanged(e);
            }
        };
        this.largeArcCheck.addItemListener(itemHandler);
        this.sweepCheck.addItemListener(itemHandler);
    }

    @Override
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        this.refreshing = true;
        SVGPathElement pathElt = (SVGPathElement)this.element;
        SVGPathSegList svgPathSegList = pathElt.getPathSegList();
        PointTableModel model = (PointTableModel)this.pointTable.getModel();
        model.setSVGPathSegList(svgPathSegList);
        int index = this.pointTable.getSelectedRow();
        if (index < 0) {
            this.disableField();
        }
        this.refreshing = false;
    }

    private void disableField() {
        this.typeCombo.setEnabled(false);
        this.xField.setEnabled(false);
        this.yField.setEnabled(false);
        this.cpx1Field.setEnabled(false);
        this.cpy1Field.setEnabled(false);
        this.cpx2Field.setEnabled(false);
        this.cpy2Field.setEnabled(false);
        this.rxField.setEnabled(false);
        this.ryField.setEnabled(false);
        this.angleField.setEnabled(false);
        this.largeArcCheck.setEnabled(false);
        this.sweepCheck.setEnabled(false);
        this.typeCombo.setSelectedIndex(-1);
        this.xField.setText("");
        this.yField.setText("");
        this.cpx1Field.setText("");
        this.cpy1Field.setText("");
        this.cpx2Field.setText("");
        this.cpy2Field.setText("");
        this.rxField.setText("");
        this.ryField.setText("");
        this.angleField.setText("");
    }

    private SVGPathSeg createPathSeq(int type, int index, float x, float y) {
        SVGPathSegMovetoAbs pathSeg = null;
        if (this.element == null) {
            return pathSeg;
        }
        Point2D absPoint = null;
        if (index > 0) {
            PointTableModel model = (PointTableModel)this.pointTable.getModel();
            absPoint = model.getAbsolutePoint(index - 1);
        } else {
            absPoint = new Point2D.Double(0.0, 0.0);
        }
        SVGPathElement svgPath = (SVGPathElement)this.element;
        if (type == 2) {
            pathSeg = svgPath.createSVGPathSegMovetoAbs(x, y);
        } else if (type == 3) {
            pathSeg = svgPath.createSVGPathSegMovetoRel(x -= (float)absPoint.getX(), y -= (float)absPoint.getY());
        } else if (type == 1) {
            pathSeg = svgPath.createSVGPathSegClosePath();
        } else if (type == 10) {
            pathSeg = svgPath.createSVGPathSegArcAbs(x, y, 0.0f, 0.0f, 0.0f, true, false);
        } else if (type == 11) {
            pathSeg = svgPath.createSVGPathSegArcRel(x -= (float)absPoint.getX(), y -= (float)absPoint.getY(), 0.0f, 0.0f, 0.0f, true, false);
        } else if (type == 4) {
            pathSeg = svgPath.createSVGPathSegLinetoAbs(x, y);
        } else if (type == 5) {
            pathSeg = svgPath.createSVGPathSegLinetoRel(x -= (float)absPoint.getX(), y -= (float)absPoint.getY());
        } else if (type == 12) {
            pathSeg = svgPath.createSVGPathSegLinetoHorizontalAbs(x);
        } else if (type == 13) {
            pathSeg = svgPath.createSVGPathSegLinetoHorizontalRel(x -= (float)absPoint.getX());
        } else if (type == 14) {
            pathSeg = svgPath.createSVGPathSegLinetoVerticalAbs(y);
        } else if (type == 15) {
            pathSeg = svgPath.createSVGPathSegLinetoVerticalRel(y -= (float)absPoint.getY());
        } else if (type == 6) {
            pathSeg = svgPath.createSVGPathSegCurvetoCubicAbs(x, y, x, y, x, y);
        } else if (type == 7) {
            pathSeg = svgPath.createSVGPathSegCurvetoCubicRel(x -= (float)absPoint.getX(), y -= (float)absPoint.getY(), x, y, x, y);
        } else if (type == 16) {
            pathSeg = svgPath.createSVGPathSegCurvetoCubicSmoothAbs(x, y, x, y);
        } else if (type == 17) {
            pathSeg = svgPath.createSVGPathSegCurvetoCubicSmoothAbs(x -= (float)absPoint.getX(), y -= (float)absPoint.getY(), x, y);
        } else if (type == 8) {
            pathSeg = svgPath.createSVGPathSegCurvetoQuadraticAbs(x, y, x, y);
        } else if (type == 9) {
            pathSeg = svgPath.createSVGPathSegCurvetoQuadraticRel(x -= (float)absPoint.getX(), y -= (float)absPoint.getY(), x, y);
        } else if (type == 18) {
            pathSeg = svgPath.createSVGPathSegCurvetoQuadraticSmoothAbs(x, y);
        } else if (type == 19) {
            pathSeg = svgPath.createSVGPathSegCurvetoQuadraticSmoothRel(x -= (float)absPoint.getX(), y -= (float)absPoint.getY());
        }
        return pathSeg;
    }

    private void selectionValueChanged(ListSelectionEvent evt) {
        SVGPathSegMovetoAbs tempSeg;
        this.refreshing = true;
        this.disableField();
        if (evt.getValueIsAdjusting()) {
            return;
        }
        int index = this.pointTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        PointTableModel model = (PointTableModel)this.pointTable.getModel();
        SVGPathSegList segList = model.getSVGPathSegList();
        SVGPathSeg seg = segList.getItem(index);
        String typeAsLetter = seg.getPathSegTypeAsLetter();
        ComboBoxModel typeComboModel = this.typeCombo.getModel();
        for (int i = 0; i < typeComboModel.getSize(); ++i) {
            String str = typeComboModel.getElementAt(i).toString();
            if (!str.startsWith(typeAsLetter)) continue;
            this.typeCombo.setSelectedIndex(i);
            break;
        }
        this.typeCombo.setEnabled(true);
        short type = seg.getPathSegType();
        if (type == 2) {
            tempSeg = (SVGPathSegMovetoAbs)seg;
            this.xField.setEnabled(true);
            this.yField.setEnabled(true);
            this.xField.setText(tempSeg.getX() + "");
            this.yField.setText(tempSeg.getY() + "");
        } else if (type == 3) {
            tempSeg = (SVGPathSegMovetoRel)seg;
            this.xField.setEnabled(true);
            this.yField.setEnabled(true);
            this.xField.setText(tempSeg.getX() + "");
            this.yField.setText(tempSeg.getY() + "");
        } else if (type != 1) {
            if (type == 10) {
                tempSeg = (SVGPathSegArcAbs)seg;
                this.xField.setEnabled(true);
                this.yField.setEnabled(true);
                this.rxField.setEnabled(true);
                this.ryField.setEnabled(true);
                this.angleField.setEnabled(true);
                this.largeArcCheck.setEnabled(true);
                this.sweepCheck.setEnabled(true);
                this.xField.setText(tempSeg.getX() + "");
                this.yField.setText(tempSeg.getY() + "");
                this.rxField.setText(tempSeg.getR1() + "");
                this.ryField.setText(tempSeg.getR2() + "");
                this.angleField.setText(tempSeg.getAngle() + "");
                this.largeArcCheck.setSelected(tempSeg.getLargeArcFlag());
                this.sweepCheck.setSelected(tempSeg.getSweepFlag());
            } else if (type == 11) {
                tempSeg = (SVGPathSegArcRel)seg;
                this.xField.setEnabled(true);
                this.yField.setEnabled(true);
                this.rxField.setEnabled(true);
                this.ryField.setEnabled(true);
                this.angleField.setEnabled(true);
                this.largeArcCheck.setEnabled(true);
                this.sweepCheck.setEnabled(true);
                this.xField.setText(tempSeg.getX() + "");
                this.yField.setText(tempSeg.getY() + "");
                this.rxField.setText(tempSeg.getR1() + "");
                this.ryField.setText(tempSeg.getR2() + "");
                this.angleField.setText(tempSeg.getAngle() + "");
                this.largeArcCheck.setSelected(tempSeg.getLargeArcFlag());
                this.sweepCheck.setSelected(tempSeg.getSweepFlag());
            } else if (type == 4) {
                tempSeg = (SVGPathSegLinetoAbs)seg;
                this.xField.setEnabled(true);
                this.yField.setEnabled(true);
                this.xField.setText(tempSeg.getX() + "");
                this.yField.setText(tempSeg.getY() + "");
            } else if (type == 5) {
                tempSeg = (SVGPathSegLinetoRel)seg;
                this.xField.setEnabled(true);
                this.yField.setEnabled(true);
                this.xField.setText(tempSeg.getX() + "");
                this.yField.setText(tempSeg.getY() + "");
            } else if (type == 12) {
                tempSeg = (SVGPathSegLinetoHorizontalAbs)seg;
                this.xField.setEnabled(true);
                this.xField.setText(tempSeg.getX() + "");
            } else if (type == 13) {
                tempSeg = (SVGPathSegLinetoHorizontalRel)seg;
                this.xField.setEnabled(true);
                this.xField.setText(tempSeg.getX() + "");
            } else if (type == 14) {
                tempSeg = (SVGPathSegLinetoVerticalAbs)seg;
                this.yField.setEnabled(true);
                this.yField.setText(tempSeg.getY() + "");
            } else if (type == 15) {
                tempSeg = (SVGPathSegLinetoVerticalRel)seg;
                this.yField.setEnabled(true);
                this.yField.setText(tempSeg.getY() + "");
            } else if (type == 6) {
                tempSeg = (SVGPathSegCurvetoCubicAbs)seg;
                this.xField.setEnabled(true);
                this.yField.setEnabled(true);
                this.cpx1Field.setEnabled(true);
                this.cpy1Field.setEnabled(true);
                this.cpx2Field.setEnabled(true);
                this.cpy2Field.setEnabled(true);
                this.xField.setText(tempSeg.getX() + "");
                this.yField.setText(tempSeg.getY() + "");
                this.cpx1Field.setText(tempSeg.getX1() + "");
                this.cpy1Field.setText(tempSeg.getY1() + "");
                this.cpx2Field.setText(tempSeg.getX2() + "");
                this.cpy2Field.setText(tempSeg.getY2() + "");
            } else if (type == 7) {
                tempSeg = (SVGPathSegCurvetoCubicRel)seg;
                this.xField.setEnabled(true);
                this.yField.setEnabled(true);
                this.cpx1Field.setEnabled(true);
                this.cpy1Field.setEnabled(true);
                this.cpx2Field.setEnabled(true);
                this.cpy2Field.setEnabled(true);
                this.xField.setText(tempSeg.getX() + "");
                this.yField.setText(tempSeg.getY() + "");
                this.cpx1Field.setText(tempSeg.getX1() + "");
                this.cpy1Field.setText(tempSeg.getY1() + "");
                this.cpx2Field.setText(tempSeg.getX2() + "");
                this.cpy2Field.setText(tempSeg.getY2() + "");
            } else if (type == 16) {
                tempSeg = (SVGPathSegCurvetoCubicSmoothAbs)seg;
                this.xField.setEnabled(true);
                this.yField.setEnabled(true);
                this.cpx2Field.setEnabled(true);
                this.cpy2Field.setEnabled(true);
                this.xField.setText(tempSeg.getX() + "");
                this.yField.setText(tempSeg.getY() + "");
                this.cpx2Field.setText(tempSeg.getX2() + "");
                this.cpy2Field.setText(tempSeg.getY2() + "");
            } else if (type == 17) {
                tempSeg = (SVGPathSegCurvetoCubicSmoothRel)seg;
                this.xField.setEnabled(true);
                this.yField.setEnabled(true);
                this.cpx2Field.setEnabled(true);
                this.cpy2Field.setEnabled(true);
                this.xField.setText(tempSeg.getX() + "");
                this.yField.setText(tempSeg.getY() + "");
                this.cpx2Field.setText(tempSeg.getX2() + "");
                this.cpy2Field.setText(tempSeg.getY2() + "");
            } else if (type == 8) {
                tempSeg = (SVGPathSegCurvetoQuadraticAbs)seg;
                this.xField.setEnabled(true);
                this.yField.setEnabled(true);
                this.cpx1Field.setEnabled(true);
                this.cpy1Field.setEnabled(true);
                this.xField.setText(tempSeg.getX() + "");
                this.yField.setText(tempSeg.getY() + "");
                this.cpx1Field.setText(tempSeg.getX1() + "");
                this.cpy1Field.setText(tempSeg.getY1() + "");
            } else if (type == 9) {
                tempSeg = (SVGPathSegCurvetoQuadraticRel)seg;
                this.xField.setEnabled(true);
                this.yField.setEnabled(true);
                this.cpx1Field.setEnabled(true);
                this.cpy1Field.setEnabled(true);
                this.xField.setText(tempSeg.getX() + "");
                this.yField.setText(tempSeg.getY() + "");
                this.cpx1Field.setText(tempSeg.getX1() + "");
                this.cpy1Field.setText(tempSeg.getY1() + "");
            } else if (type == 18) {
                tempSeg = (SVGPathSegCurvetoQuadraticSmoothAbs)seg;
                this.xField.setEnabled(true);
                this.yField.setEnabled(true);
                this.xField.setText(tempSeg.getX() + "");
                this.yField.setText(tempSeg.getY() + "");
            } else if (type == 19) {
                tempSeg = (SVGPathSegCurvetoQuadraticSmoothRel)seg;
                this.xField.setEnabled(true);
                this.yField.setEnabled(true);
                this.xField.setText(tempSeg.getX() + "");
                this.yField.setText(tempSeg.getY() + "");
            }
        }
        this.refreshing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void typeComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        int index = this.pointTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        PointTableModel model = (PointTableModel)this.pointTable.getModel();
        SVGPathSegList segList = model.getSVGPathSegList();
        String str = this.typeCombo.getSelectedItem().toString().substring(0, 1);
        if (str.equals("-")) {
            return;
        }
        int newType = GeomUtilities.getPathSegType(str);
        float x = 0.0f;
        float y = 0.0f;
        Point2D absPoint = null;
        absPoint = index > 0 ? model.getAbsolutePoint(index - 1) : new Point2D.Double(0.0, 0.0);
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Path Segment type");
        try {
            SVGPathSegMovetoAbs tempSeg;
            SVGPathSeg seg = segList.getItem(index);
            short type = seg.getPathSegType();
            if (type == 2) {
                tempSeg = (SVGPathSegMovetoAbs)seg;
                x = tempSeg.getX();
                y = tempSeg.getY();
            } else if (type == 3) {
                tempSeg = (SVGPathSegMovetoRel)seg;
                x = tempSeg.getX() + (float)absPoint.getX();
                y = tempSeg.getY() + (float)absPoint.getY();
            } else if (type == 1) {
                x = 0.0f;
                y = 0.0f;
            } else if (type == 10) {
                tempSeg = (SVGPathSegArcAbs)seg;
                x = tempSeg.getX();
                y = tempSeg.getY();
            } else if (type == 11) {
                tempSeg = (SVGPathSegArcRel)seg;
                x = tempSeg.getX() + (float)absPoint.getX();
                y = tempSeg.getY() + (float)absPoint.getY();
            } else if (type == 4) {
                tempSeg = (SVGPathSegLinetoAbs)seg;
                x = tempSeg.getX();
                y = tempSeg.getY();
            } else if (type == 5) {
                tempSeg = (SVGPathSegLinetoRel)seg;
                x = tempSeg.getX() + (float)absPoint.getX();
                y = tempSeg.getY() + (float)absPoint.getY();
            } else if (type == 12) {
                tempSeg = (SVGPathSegLinetoHorizontalAbs)seg;
                x = tempSeg.getX();
                y = (float)absPoint.getY();
            } else if (type == 13) {
                tempSeg = (SVGPathSegLinetoHorizontalRel)seg;
                x = tempSeg.getX() + (float)absPoint.getX();
                y = (float)absPoint.getY();
            } else if (type == 14) {
                tempSeg = (SVGPathSegLinetoVerticalAbs)seg;
                x = (float)absPoint.getX();
                y = tempSeg.getY();
            } else if (type == 15) {
                tempSeg = (SVGPathSegLinetoVerticalRel)seg;
                x = (float)absPoint.getX();
                y = tempSeg.getY() + (float)absPoint.getY();
            } else if (type == 6) {
                tempSeg = (SVGPathSegCurvetoCubicAbs)seg;
                x = tempSeg.getX();
                y = tempSeg.getY();
            } else if (type == 7) {
                tempSeg = (SVGPathSegCurvetoCubicRel)seg;
                x = tempSeg.getX() + (float)absPoint.getX();
                y = tempSeg.getY() + (float)absPoint.getY();
            } else if (type == 16) {
                tempSeg = (SVGPathSegCurvetoCubicSmoothAbs)seg;
                x = tempSeg.getX();
                y = tempSeg.getY();
            } else if (type == 17) {
                tempSeg = (SVGPathSegCurvetoCubicSmoothRel)seg;
                x = tempSeg.getX() + (float)absPoint.getX();
                y = tempSeg.getY() + (float)absPoint.getY();
            } else if (type == 8) {
                tempSeg = (SVGPathSegCurvetoQuadraticAbs)seg;
                x = tempSeg.getX();
                y = tempSeg.getY();
            } else if (type == 9) {
                tempSeg = (SVGPathSegCurvetoQuadraticRel)seg;
                x = tempSeg.getX() + (float)absPoint.getX();
                y = tempSeg.getY() + (float)absPoint.getY();
            } else if (type == 18) {
                tempSeg = (SVGPathSegCurvetoQuadraticSmoothAbs)seg;
                x = tempSeg.getX();
                y = tempSeg.getY();
            } else if (type == 19) {
                tempSeg = (SVGPathSegCurvetoQuadraticSmoothRel)seg;
                x = tempSeg.getX() + (float)absPoint.getX();
                y = tempSeg.getY() + (float)absPoint.getY();
            }
            SVGPathSeg newSeg = this.createPathSeq(newType, index, x, y);
            if (newSeg != null) {
                segList.insertItemBefore(newSeg, index);
                segList.removeItem(index + 1);
            }
        }
        catch (Exception ex) {
        }
        finally {
            undoManager.end();
            this.editing = false;
        }
        this.refreshProperties();
        if (this.canvas != null) {
            this.canvas.refresh();
        }
        this.pointTable.getSelectionModel().setSelectionInterval(index, index);
    }

    private void fieldActionPerformed(ActionEvent e) {
        if (this.refreshing) {
            return;
        }
        int index = this.pointTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        PointTableModel model = (PointTableModel)this.pointTable.getModel();
        SVGPathSegList segList = model.getSVGPathSegList();
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Path points");
        SVGPathSeg seg = segList.getItem(index);
        short type = seg.getPathSegType();
        if (type == 2) {
            float f;
            SVGPathSegMovetoAbs tempSeg = (SVGPathSegMovetoAbs)seg;
            try {
                f = Float.parseFloat(this.xField.getText());
                tempSeg.setX(f);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            try {
                f = Float.parseFloat(this.yField.getText());
                tempSeg.setY(f);
            }
            catch (NumberFormatException ex) {}
        } else if (type == 3) {
            SVGPathSegMovetoAbs tempSeg = (SVGPathSegMovetoAbs)seg;
            try {
                float f = Float.parseFloat(this.xField.getText());
                tempSeg.setX(f);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            try {
                float f = Float.parseFloat(this.yField.getText());
                tempSeg.setY(f);
            }
            catch (NumberFormatException ex) {}
        } else if (type != 1) {
            if (type == 10) {
                SVGPathSegArcAbs tempSeg = (SVGPathSegArcAbs)seg;
                try {
                    float f = Float.parseFloat(this.xField.getText());
                    tempSeg.setX(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.yField.getText());
                    tempSeg.setY(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.rxField.getText());
                    tempSeg.setR1(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.ryField.getText());
                    tempSeg.setR2(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.angleField.getText());
                    tempSeg.setAngle(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 11) {
                SVGPathSegArcRel tempSeg = (SVGPathSegArcRel)seg;
                try {
                    float f = Float.parseFloat(this.xField.getText());
                    tempSeg.setX(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.yField.getText());
                    tempSeg.setY(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.rxField.getText());
                    tempSeg.setR1(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.ryField.getText());
                    tempSeg.setR2(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.angleField.getText());
                    tempSeg.setAngle(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 4) {
                SVGPathSegLinetoAbs tempSeg = (SVGPathSegLinetoAbs)seg;
                try {
                    float f = Float.parseFloat(this.xField.getText());
                    tempSeg.setX(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.yField.getText());
                    tempSeg.setY(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 5) {
                SVGPathSegLinetoRel tempSeg = (SVGPathSegLinetoRel)seg;
                try {
                    float f = Float.parseFloat(this.xField.getText());
                    tempSeg.setX(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.yField.getText());
                    tempSeg.setY(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 12) {
                SVGPathSegLinetoHorizontalAbs tempSeg = (SVGPathSegLinetoHorizontalAbs)seg;
                try {
                    float f = Float.parseFloat(this.xField.getText());
                    tempSeg.setX(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 13) {
                SVGPathSegLinetoHorizontalRel tempSeg = (SVGPathSegLinetoHorizontalRel)seg;
                try {
                    float f = Float.parseFloat(this.xField.getText());
                    tempSeg.setX(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 14) {
                SVGPathSegLinetoVerticalAbs tempSeg = (SVGPathSegLinetoVerticalAbs)seg;
                try {
                    float f = Float.parseFloat(this.yField.getText());
                    tempSeg.setY(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 15) {
                SVGPathSegLinetoVerticalRel tempSeg = (SVGPathSegLinetoVerticalRel)seg;
                try {
                    float f = Float.parseFloat(this.yField.getText());
                    tempSeg.setY(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 6) {
                SVGPathSegCurvetoCubicAbs tempSeg = (SVGPathSegCurvetoCubicAbs)seg;
                try {
                    float f = Float.parseFloat(this.xField.getText());
                    tempSeg.setX(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.yField.getText());
                    tempSeg.setY(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpx1Field.getText());
                    tempSeg.setX1(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpy1Field.getText());
                    tempSeg.setY1(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpx2Field.getText());
                    tempSeg.setX2(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpy2Field.getText());
                    tempSeg.setY2(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 7) {
                SVGPathSegCurvetoCubicRel tempSeg = (SVGPathSegCurvetoCubicRel)seg;
                try {
                    float f = Float.parseFloat(this.xField.getText());
                    tempSeg.setX(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.yField.getText());
                    tempSeg.setY(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpx1Field.getText());
                    tempSeg.setX1(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpy1Field.getText());
                    tempSeg.setY1(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpx2Field.getText());
                    tempSeg.setX2(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpy2Field.getText());
                    tempSeg.setY2(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 16) {
                SVGPathSegCurvetoCubicSmoothAbs tempSeg = (SVGPathSegCurvetoCubicSmoothAbs)seg;
                try {
                    float f = Float.parseFloat(this.xField.getText());
                    tempSeg.setX(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.yField.getText());
                    tempSeg.setY(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpx2Field.getText());
                    tempSeg.setX2(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpy2Field.getText());
                    tempSeg.setY2(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 17) {
                SVGPathSegCurvetoCubicSmoothRel tempSeg = (SVGPathSegCurvetoCubicSmoothRel)seg;
                try {
                    float f = Float.parseFloat(this.xField.getText());
                    tempSeg.setX(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.yField.getText());
                    tempSeg.setY(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpx2Field.getText());
                    tempSeg.setX2(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpy2Field.getText());
                    tempSeg.setY2(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 8) {
                SVGPathSegCurvetoQuadraticAbs tempSeg = (SVGPathSegCurvetoQuadraticAbs)seg;
                try {
                    float f = Float.parseFloat(this.xField.getText());
                    tempSeg.setX(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.yField.getText());
                    tempSeg.setY(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpx1Field.getText());
                    tempSeg.setX1(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpy1Field.getText());
                    tempSeg.setY1(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 9) {
                SVGPathSegCurvetoQuadraticRel tempSeg = (SVGPathSegCurvetoQuadraticRel)seg;
                try {
                    float f = Float.parseFloat(this.xField.getText());
                    tempSeg.setX(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.yField.getText());
                    tempSeg.setY(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpx1Field.getText());
                    tempSeg.setX1(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.cpy1Field.getText());
                    tempSeg.setY1(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 18) {
                SVGPathSegCurvetoQuadraticSmoothAbs tempSeg = (SVGPathSegCurvetoQuadraticSmoothAbs)seg;
                try {
                    float f = Float.parseFloat(this.xField.getText());
                    tempSeg.setX(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.yField.getText());
                    tempSeg.setY(f);
                }
                catch (NumberFormatException ex) {}
            } else if (type == 19) {
                SVGPathSegCurvetoQuadraticSmoothRel tempSeg = (SVGPathSegCurvetoQuadraticSmoothRel)seg;
                try {
                    float f = Float.parseFloat(this.xField.getText());
                    tempSeg.setX(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                try {
                    float f = Float.parseFloat(this.yField.getText());
                    tempSeg.setY(f);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        undoManager.end();
        this.editing = false;
        this.refreshProperties();
        if (this.canvas != null) {
            this.canvas.refresh();
        }
        this.pointTable.getSelectionModel().setSelectionInterval(index, index);
    }

    private void arcCheckBoxItemStateChanged(ItemEvent e) {
        if (this.refreshing) {
            return;
        }
        int index = this.pointTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        PointTableModel model = (PointTableModel)this.pointTable.getModel();
        SVGPathSegList segList = model.getSVGPathSegList();
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Path Points");
        SVGPathSeg seg = segList.getItem(index);
        short type = seg.getPathSegType();
        if (type == 10) {
            SVGPathSegArcAbs tempSeg = (SVGPathSegArcAbs)seg;
            try {
                tempSeg.setLargeArcFlag(this.largeArcCheck.isSelected());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                tempSeg.setSweepFlag(this.sweepCheck.isSelected());
            }
            catch (Exception ex) {}
        } else if (type == 11) {
            SVGPathSegArcRel tempSeg = (SVGPathSegArcRel)seg;
            try {
                tempSeg.setLargeArcFlag(this.largeArcCheck.isSelected());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                tempSeg.setSweepFlag(this.sweepCheck.isSelected());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        undoManager.end();
        this.editing = false;
        this.refreshProperties();
        if (this.canvas != null) {
            this.canvas.refresh();
        }
        this.pointTable.getSelectionModel().setSelectionInterval(index, index);
    }

    private class PointTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Point", "Value"};
        private SVGPathSegList svgPathSegList;
        private List<Point2D> absolutePointList;

        public void setSVGPathSegList(SVGPathSegList svgPathSegList) {
            this.svgPathSegList = svgPathSegList;
            if (this.absolutePointList == null) {
                this.absolutePointList = new ArrayList<Point2D>();
            } else {
                this.absolutePointList.clear();
            }
            this.generateAbsolutePointList();
            this.fireTableDataChanged();
        }

        public SVGPathSegList getSVGPathSegList() {
            return this.svgPathSegList;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.svgPathSegList == null) {
                return 0;
            }
            return this.svgPathSegList.getNumberOfItems();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.svgPathSegList == null) {
                return null;
            }
            if (columnIndex == 0) {
                return new Integer(rowIndex);
            }
            String separator = ";";
            String strType = "";
            String str = "";
            SVGPathSeg seg = this.svgPathSegList.getItem(rowIndex);
            short type = seg.getPathSegType();
            if (type == 2) {
                SVGPathSegMovetoAbs tempSeg = (SVGPathSegMovetoAbs)seg;
                strType = "M";
                str = tempSeg.getX() + separator + tempSeg.getY();
            } else if (type == 3) {
                SVGPathSegMovetoRel tempSeg = (SVGPathSegMovetoRel)seg;
                strType = "m";
                str = tempSeg.getX() + separator + tempSeg.getY();
            } else if (type == 1) {
                strType = "Z";
                str = "close";
            } else if (type == 10) {
                SVGPathSegArcAbs tempSeg = (SVGPathSegArcAbs)seg;
                strType = "A";
                str = tempSeg.getX() + separator + tempSeg.getY();
            } else if (type == 11) {
                SVGPathSegArcRel tempSeg = (SVGPathSegArcRel)seg;
                strType = "a";
                str = tempSeg.getX() + separator + tempSeg.getY();
            } else if (type == 4) {
                SVGPathSegLinetoAbs tempSeg = (SVGPathSegLinetoAbs)seg;
                strType = "L";
                str = tempSeg.getX() + separator + tempSeg.getY();
            } else if (type == 5) {
                SVGPathSegLinetoRel tempSeg = (SVGPathSegLinetoRel)seg;
                strType = "l";
                str = tempSeg.getX() + separator + tempSeg.getY();
            } else if (type == 12) {
                SVGPathSegLinetoHorizontalAbs tempSeg = (SVGPathSegLinetoHorizontalAbs)seg;
                strType = "H";
                str = tempSeg.getX() + "";
            } else if (type == 13) {
                SVGPathSegLinetoHorizontalRel tempSeg = (SVGPathSegLinetoHorizontalRel)seg;
                strType = "h";
                str = tempSeg.getX() + "";
            } else if (type == 14) {
                SVGPathSegLinetoVerticalAbs tempSeg = (SVGPathSegLinetoVerticalAbs)seg;
                strType = "V";
                str = tempSeg.getY() + "";
            } else if (type == 15) {
                SVGPathSegLinetoVerticalRel tempSeg = (SVGPathSegLinetoVerticalRel)seg;
                strType = "v";
                str = tempSeg.getY() + "";
            } else if (type == 6) {
                SVGPathSegCurvetoCubicAbs tempSeg = (SVGPathSegCurvetoCubicAbs)seg;
                strType = "C";
                str = tempSeg.getX() + separator + tempSeg.getY();
            } else if (type == 7) {
                SVGPathSegCurvetoCubicRel tempSeg = (SVGPathSegCurvetoCubicRel)seg;
                strType = "c";
                str = tempSeg.getX() + separator + tempSeg.getY();
            } else if (type == 16) {
                SVGPathSegCurvetoCubicSmoothAbs tempSeg = (SVGPathSegCurvetoCubicSmoothAbs)seg;
                strType = "S";
                str = tempSeg.getX() + separator + tempSeg.getY();
            } else if (type == 17) {
                SVGPathSegCurvetoCubicSmoothRel tempSeg = (SVGPathSegCurvetoCubicSmoothRel)seg;
                strType = "s";
                str = tempSeg.getX() + separator + tempSeg.getY();
            } else if (type == 8) {
                SVGPathSegCurvetoQuadraticAbs tempSeg = (SVGPathSegCurvetoQuadraticAbs)seg;
                strType = "Q";
                str = tempSeg.getX() + separator + tempSeg.getY();
            } else if (type == 9) {
                SVGPathSegCurvetoQuadraticRel tempSeg = (SVGPathSegCurvetoQuadraticRel)seg;
                strType = "q";
                str = tempSeg.getX() + separator + tempSeg.getY();
            } else if (type == 18) {
                SVGPathSegCurvetoQuadraticSmoothAbs tempSeg = (SVGPathSegCurvetoQuadraticSmoothAbs)seg;
                strType = "T";
                str = tempSeg.getX() + separator + tempSeg.getY();
            } else if (type == 19) {
                SVGPathSegCurvetoQuadraticSmoothRel tempSeg = (SVGPathSegCurvetoQuadraticSmoothRel)seg;
                strType = "t";
                str = tempSeg.getX() + separator + tempSeg.getY();
            }
            return strType + " [" + str + "]";
        }

        public Point2D getAbsolutePoint(int rowIndex) {
            Point2D p = null;
            if (this.absolutePointList == null) {
                return p;
            }
            p = this.absolutePointList.get(rowIndex);
            return p;
        }

        private void generateAbsolutePointList() {
            if (this.svgPathSegList == null) {
                return;
            }
            if (PathGeometryProperties.this.canvas == null) {
                return;
            }
            SVGPathSegList segList = this.svgPathSegList;
            double[] srcPts = new double[2];
            double[] dstPts = new double[2];
            double[] lastPts = new double[]{0.0, 0.0};
            srcPts[0] = 0.0;
            srcPts[1] = 0.0;
            AffineTransform at = new AffineTransform();
            GraphicsNode gn = PathGeometryProperties.this.canvas.getModel().getGraphicsNode(PathGeometryProperties.this.element);
            if (gn != null && gn instanceof ShapeNode) {
                ShapeNode shapeNode = (ShapeNode)gn;
                at.concatenate(shapeNode.getGlobalTransform());
            }
            for (int j = 0; j < segList.getNumberOfItems(); ++j) {
                SVGPathSegLinetoAbs line;
                SVGPathSegCurvetoQuadraticAbs quad;
                SVGPathSegCurvetoCubicAbs cubic;
                SVGPathSegArcAbs arc;
                Point2D.Double point;
                SVGPathSegMovetoAbs moveTo;
                SVGPathSeg pathSeg = segList.getItem(j);
                short type = pathSeg.getPathSegType();
                if (type == 2) {
                    moveTo = (SVGPathSegMovetoAbs)pathSeg;
                    srcPts[0] = moveTo.getX();
                    srcPts[1] = moveTo.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 3) {
                    moveTo = (SVGPathSegMovetoRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)moveTo.getX();
                    srcPts[1] = lastPts[1] + (double)moveTo.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 10) {
                    arc = (SVGPathSegArcAbs)pathSeg;
                    srcPts[0] = arc.getX();
                    srcPts[1] = arc.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 11) {
                    arc = (SVGPathSegArcRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)arc.getX();
                    srcPts[1] = lastPts[1] + (double)arc.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 6) {
                    cubic = (SVGPathSegCurvetoCubicAbs)pathSeg;
                    srcPts[0] = cubic.getX();
                    srcPts[1] = cubic.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 7) {
                    cubic = (SVGPathSegCurvetoCubicRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)cubic.getX();
                    srcPts[1] = lastPts[1] + (double)cubic.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 16) {
                    cubic = (SVGPathSegCurvetoCubicSmoothAbs)pathSeg;
                    srcPts[0] = cubic.getX();
                    srcPts[1] = cubic.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 17) {
                    cubic = (SVGPathSegCurvetoCubicSmoothRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)cubic.getX();
                    srcPts[1] = lastPts[1] + (double)cubic.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 8) {
                    quad = (SVGPathSegCurvetoQuadraticAbs)pathSeg;
                    srcPts[0] = quad.getX();
                    srcPts[1] = quad.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 9) {
                    quad = (SVGPathSegCurvetoQuadraticRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)quad.getX();
                    srcPts[1] = lastPts[1] + (double)quad.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 18) {
                    quad = (SVGPathSegCurvetoQuadraticSmoothAbs)pathSeg;
                    srcPts[0] = quad.getX();
                    srcPts[1] = quad.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 19) {
                    quad = (SVGPathSegCurvetoQuadraticSmoothRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)quad.getX();
                    srcPts[1] = lastPts[1] + (double)quad.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 4) {
                    line = (SVGPathSegLinetoAbs)pathSeg;
                    srcPts[0] = line.getX();
                    srcPts[1] = line.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 12) {
                    line = (SVGPathSegLinetoHorizontalAbs)pathSeg;
                    srcPts[0] = line.getX();
                    lastPts[0] = srcPts[0];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 13) {
                    line = (SVGPathSegLinetoHorizontalRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)line.getX();
                    lastPts[0] = srcPts[0];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 5) {
                    line = (SVGPathSegLinetoRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)line.getX();
                    srcPts[1] = lastPts[1] + (double)line.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type == 14) {
                    line = (SVGPathSegLinetoVerticalAbs)pathSeg;
                    srcPts[1] = line.getY();
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new Point2D.Double(dstPts[0], dstPts[1]);
                    this.absolutePointList.add(point);
                    continue;
                }
                if (type != 15) continue;
                line = (SVGPathSegLinetoVerticalAbs)pathSeg;
                srcPts[1] = lastPts[1] + (double)line.getY();
                lastPts[1] = srcPts[1];
                at.transform(srcPts, 0, dstPts, 0, 1);
                point = new Point2D.Double(dstPts[0], dstPts[1]);
                this.absolutePointList.add(point);
            }
        }
    }
}

