/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.textstyle;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kiyut.sketsa.options.FontSetOptions;

public class FontChooserPane
extends JPanel {
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.windows.textstyle.FontChooserPane");
    private List<List<String>> fontSetListData;
    private JButton addChoosenFontButton;
    private JButton addFontSetButton;
    private JTextField availableFontField;
    private JList availableFontList;
    private JList choosenFontList;
    private JList fontSetList;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JButton moveDownFontSetButton;
    private JButton moveUpFontSetButton;
    private JButton removeChoosenFontButton;
    private JButton removeFontSetButton;

    public FontChooserPane() {
        this((List<List<String>>)null);
    }

    public FontChooserPane(List<List<String>> fontSetListData) {
        this.fontSetListData = fontSetListData;
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.choosenFontList = new JList();
        this.jToolBar1 = new JToolBar();
        this.addChoosenFontButton = new JButton();
        this.removeChoosenFontButton = new JButton();
        this.jPanel2 = new JPanel();
        this.availableFontField = new JTextField();
        this.jScrollPane3 = new JScrollPane();
        this.availableFontList = new JList();
        JLabel jLabel3 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jPanel3 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.jToolBar2 = new JToolBar();
        this.addFontSetButton = new JButton();
        this.moveUpFontSetButton = new JButton();
        this.moveDownFontSetButton = new JButton();
        this.removeFontSetButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.fontSetList = new JList();
        this.setPreferredSize(new Dimension(560, 460));
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        jLabel2.setText(bundle.getString("CTL_ChoosenFonts.Text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)jLabel2, gridBagConstraints);
        this.choosenFontList.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.choosenFontList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel1.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setOrientation(1);
        this.jToolBar1.setRollover(true);
        this.addChoosenFontButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/textstyle/left.png")));
        this.addChoosenFontButton.setToolTipText(bundle.getString("CTL_AddChoosenFontList.Tooltip"));
        this.addChoosenFontButton.setFocusPainted(false);
        this.addChoosenFontButton.setMargin(new Insets(1, 1, 1, 1));
        this.jToolBar1.add(this.addChoosenFontButton);
        this.removeChoosenFontButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/textstyle/right.png")));
        this.removeChoosenFontButton.setToolTipText(bundle.getString("CTL_RemoveChoosenFontList.Tooltip"));
        this.removeChoosenFontButton.setFocusPainted(false);
        this.removeChoosenFontButton.setMargin(new Insets(1, 1, 1, 1));
        this.jToolBar1.add(this.removeChoosenFontButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel2.add((Component)this.availableFontField, gridBagConstraints);
        this.availableFontList.setSelectionMode(0);
        this.jScrollPane3.setViewportView(this.availableFontList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel2.add((Component)this.jScrollPane3, gridBagConstraints);
        jLabel3.setText(bundle.getString("CTL_AvailableFonts.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.4;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        jLabel1.setHorizontalAlignment(2);
        jLabel1.setText(bundle.getString("CTL_FontSetList.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)jLabel1, gridBagConstraints);
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setRollover(true);
        this.addFontSetButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/actions/new.png")));
        this.addFontSetButton.setToolTipText(bundle.getString("CTL_AddFontSet.Tooltip"));
        this.addFontSetButton.setFocusPainted(false);
        this.addFontSetButton.setMargin(new Insets(1, 1, 1, 1));
        this.jToolBar2.add(this.addFontSetButton);
        this.moveUpFontSetButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/domeditor/up.png")));
        this.moveUpFontSetButton.setToolTipText(bundle.getString("CTL_MoveUpFontSet.Tooltip"));
        this.moveUpFontSetButton.setFocusPainted(false);
        this.moveUpFontSetButton.setMargin(new Insets(1, 1, 1, 1));
        this.jToolBar2.add(this.moveUpFontSetButton);
        this.moveDownFontSetButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/domeditor/down.png")));
        this.moveDownFontSetButton.setToolTipText(bundle.getString("CTL_MoveDownFontSet.Tooltip"));
        this.moveDownFontSetButton.setFocusPainted(false);
        this.moveDownFontSetButton.setMargin(new Insets(1, 1, 1, 1));
        this.jToolBar2.add(this.moveDownFontSetButton);
        this.removeFontSetButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/domeditor/delete.png")));
        this.removeFontSetButton.setToolTipText(bundle.getString("CTL_RemoveFontSet.Tooltip"));
        this.removeFontSetButton.setFocusPainted(false);
        this.removeFontSetButton.setMargin(new Insets(1, 1, 1, 1));
        this.jToolBar2.add(this.removeFontSetButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jToolBar2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel6.add((Component)this.jPanel3, gridBagConstraints);
        this.fontSetList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.fontSetList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel6.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jPanel6, gridBagConstraints);
    }

    private void initCustomComponents() {
        DefaultListModel availableFontListModel = new DefaultListModel();
        DefaultListModel choosenFontListModel = new DefaultListModel();
        DefaultListModel fontSetListModel = new DefaultListModel();
        this.availableFontList.setModel(availableFontListModel);
        this.choosenFontList.setModel(choosenFontListModel);
        this.fontSetList.setModel(fontSetListModel);
        this.availableFontList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontChooserPane.this.availableFontListValueChanged(evt);
            }
        });
        this.choosenFontList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontChooserPane.this.choosenFontListValueChanged(evt);
            }
        });
        this.fontSetList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontChooserPane.this.fontSetListValueChanged(evt);
            }
        });
        this.addChoosenFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooserPane.this.addChoosenFontButtonActionPerformed(evt);
            }
        });
        this.removeChoosenFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooserPane.this.removeChoosenFontButtonActionPerformed(evt);
            }
        });
        this.addFontSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooserPane.this.addFontSetButtonActionPerformed(evt);
            }
        });
        this.removeFontSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooserPane.this.removeFontSetButtonActionPerformed(evt);
            }
        });
        this.moveUpFontSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooserPane.this.moveUpFontSetButtonActionPerformed(evt);
            }
        });
        this.moveDownFontSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooserPane.this.moveDownFontSetButtonActionPerformed(evt);
            }
        });
        this.refreshAvailableFontList();
        this.loadFontSetList();
        this.addChoosenFontButton.setEnabled(false);
        this.removeChoosenFontButton.setEnabled(false);
        if (fontSetListModel.size() > 0) {
            this.fontSetList.setSelectedIndex(0);
        }
    }

    private void loadFontSetList() {
        DefaultListModel fontSetListModel = (DefaultListModel)this.fontSetList.getModel();
        fontSetListModel.clear();
        if (this.fontSetListData != null) {
            for (int i = 0; i < this.fontSetListData.size(); ++i) {
                List<String> subList = this.fontSetListData.get(i);
                String str = this.listToString(subList);
                fontSetListModel.addElement(str);
            }
        }
    }

    public void refreshAvailableFontList() {
        DefaultListModel availableFontListModel = (DefaultListModel)this.availableFontList.getModel();
        availableFontListModel.clear();
        String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fontList.length; ++i) {
            availableFontListModel.add(i, fontList[i]);
        }
        availableFontListModel.addElement("serif");
        availableFontListModel.addElement("sans-serif");
        availableFontListModel.addElement("monospace");
        availableFontListModel.addElement("cursive");
        availableFontListModel.addElement("fantasy");
    }

    private void updateFontSetFromChoosenFontList() {
        int index = this.fontSetList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        ListModel choosenFontListModel = this.choosenFontList.getModel();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < choosenFontListModel.getSize(); ++i) {
            list.add((String)choosenFontListModel.getElementAt(i));
        }
        String str = this.listToString(list);
        DefaultListModel fontSetListModel = (DefaultListModel)this.fontSetList.getModel();
        fontSetListModel.set(index, str);
    }

    private List<String> stringToList(String text) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(text, ",");
        while (st.hasMoreTokens()) {
            String str = st.nextToken().trim();
            if (str.length() <= 0) continue;
            list.add(str);
        }
        return list;
    }

    private String listToString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String obj = list.get(i);
            sb.append(", ").append((Object)obj);
        }
        if (sb.length() > 0) {
            sb.delete(0, 2);
        } else {
            sb.append(" ");
        }
        return sb.toString();
    }

    public List<List<String>> generateFontSetList() {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        ListModel listModel = this.fontSetList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            String fonts = (String)this.fontSetList.getModel().getElementAt(i);
            List<String> subList = this.stringToList(fonts);
            if (subList.size() <= 0) continue;
            list.add(subList);
        }
        return list;
    }

    public static int showDialog(Component parentComponent, List<List<String>> fontSetList, boolean updateList) {
        FontChooserPane fontChooserPane = new FontChooserPane(fontSetList);
        int choice = JOptionPane.showConfirmDialog(parentComponent, fontChooserPane, bundle.getString("CTL_Title.Text"), 2, -1);
        if (choice == 0 && updateList) {
            FontSetOptions opts = FontSetOptions.getInstance();
            List<List<String>> list = fontChooserPane.generateFontSetList();
            opts.setFontSetList(list);
        }
        return choice;
    }

    private void availableFontListValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        int index = this.availableFontList.getSelectedIndex();
        if (index < 0) {
            this.addChoosenFontButton.setEnabled(false);
            return;
        }
        this.addChoosenFontButton.setEnabled(true);
        ListModel model = this.availableFontList.getModel();
        String str = (String)model.getElementAt(index);
        this.availableFontField.setText(str);
        ListModel choosenFontListModel = this.choosenFontList.getModel();
        for (int i = 0; i < choosenFontListModel.getSize(); ++i) {
            String choosenFont = (String)choosenFontListModel.getElementAt(i);
            if (!str.equalsIgnoreCase(choosenFont)) continue;
            this.addChoosenFontButton.setEnabled(false);
            break;
        }
    }

    private void choosenFontListValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        int index = this.choosenFontList.getSelectedIndex();
        if (index < 0) {
            this.removeChoosenFontButton.setEnabled(false);
        } else {
            this.removeChoosenFontButton.setEnabled(true);
        }
    }

    private void fontSetListValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        DefaultListModel choosenFontListModel = (DefaultListModel)this.choosenFontList.getModel();
        int index = this.fontSetList.getSelectedIndex();
        if (index < 0) {
            choosenFontListModel.clear();
            this.removeFontSetButton.setEnabled(false);
            this.moveUpFontSetButton.setEnabled(false);
            this.moveDownFontSetButton.setEnabled(false);
            return;
        }
        this.removeFontSetButton.setEnabled(true);
        this.moveUpFontSetButton.setEnabled(true);
        this.moveDownFontSetButton.setEnabled(true);
        choosenFontListModel.clear();
        String fontString = (String)this.fontSetList.getModel().getElementAt(index);
        List<String> list = this.stringToList(fontString);
        for (int i = 0; i < list.size(); ++i) {
            choosenFontListModel.addElement(list.get(i));
        }
    }

    private void addChoosenFontButtonActionPerformed(ActionEvent evt) {
        String str = this.availableFontField.getText().trim();
        if (str.length() <= 0) {
            return;
        }
        ((DefaultListModel)this.choosenFontList.getModel()).addElement(str);
        this.updateFontSetFromChoosenFontList();
        this.addChoosenFontButton.setEnabled(false);
    }

    private void removeChoosenFontButtonActionPerformed(ActionEvent evt) {
        int i = this.choosenFontList.getSelectedIndex();
        if (i < 0) {
            return;
        }
        DefaultListModel listModel = (DefaultListModel)this.choosenFontList.getModel();
        listModel.remove(i);
        int size = listModel.size();
        if (i == size && size > 0) {
            this.choosenFontList.setSelectedIndex(i - 1);
        } else if (i < size && size > 0) {
            this.choosenFontList.setSelectedIndex(i);
        }
        this.updateFontSetFromChoosenFontList();
    }

    private void addFontSetButtonActionPerformed(ActionEvent evt) {
        DefaultListModel listModel = (DefaultListModel)this.fontSetList.getModel();
        listModel.addElement(" ");
        this.fontSetList.setSelectedIndex(listModel.getSize() - 1);
    }

    private void removeFontSetButtonActionPerformed(ActionEvent evt) {
        int i = this.fontSetList.getSelectedIndex();
        if (i < 0) {
            return;
        }
        DefaultListModel listModel = (DefaultListModel)this.fontSetList.getModel();
        listModel.remove(i);
        int size = listModel.size();
        if (i == size && size > 0) {
            this.fontSetList.setSelectedIndex(i - 1);
        } else if (i < size && size > 0) {
            this.fontSetList.setSelectedIndex(i);
        }
    }

    private void moveUpFontSetButtonActionPerformed(ActionEvent evt) {
        int i = this.fontSetList.getSelectedIndex();
        if (i <= 0) {
            return;
        }
        DefaultListModel listModel = (DefaultListModel)this.fontSetList.getModel();
        Object obj = listModel.remove(i);
        listModel.add(i - 1, obj);
        this.fontSetList.setSelectedIndex(i - 1);
    }

    private void moveDownFontSetButtonActionPerformed(ActionEvent evt) {
        int i = this.fontSetList.getSelectedIndex();
        DefaultListModel listModel = (DefaultListModel)this.fontSetList.getModel();
        if (i < 0 || i >= listModel.size() - 1) {
            return;
        }
        Object obj = listModel.remove(i);
        listModel.add(i + 1, obj);
        this.fontSetList.setSelectedIndex(i + 1);
    }
}

