/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.toolbox;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.Tool;
import kiyut.sketsa.cookies.SVGEditorCookie;
import org.openide.util.HelpCtx;
import org.openide.util.actions.BooleanStateAction;

public abstract class AbstractToolAction
extends BooleanStateAction {
    protected SVGEditorCookie editorCookie;
    protected Tool tool;

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void setSVGEditorCookie(SVGEditorCookie editorCookie) {
        SVGEditorCookie oldEditorCookie = this.editorCookie;
        this.editorCookie = editorCookie;
        if (oldEditorCookie != null) {
            VectorCanvas canvas = oldEditorCookie.getVectorCanvas();
            canvas.setTool(null);
        } else if (this.tool != null) {
            this.tool.endTool();
        }
    }

    protected Tool getTool() {
        return this.tool;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.editorCookie == null) {
            return;
        }
        if (this.tool == null) {
            Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
            logger.log(Level.WARNING, "Tool can't be null");
            return;
        }
        VectorCanvas canvas = this.editorCookie.getVectorCanvas();
        canvas.setTool(this.tool);
    }
}

