/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.xmleditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.options.SourceEditorOptions;
import kiyut.sketsa.xmleditor.SourceEditorPane;
import org.w3c.dom.svg.SVGDocument;

public class SourceEditorWindow
extends JDialog {
    private static ResourceBundle bundle = ResourceBundle.getBundle(SourceEditorWindow.class.getName());
    private SourceEditorPane editorPane;

    public SourceEditorWindow(Frame owner, boolean modal) {
        super(owner, modal);
        this.setDefaultCloseOperation(0);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        SourceEditorOptions opts = SourceEditorOptions.getInstance();
        Rectangle bounds = opts.getBounds();
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        if (x < 0 || y < 0) {
            this.setSize(width, height);
            this.setLocationRelativeTo(owner);
        } else {
            this.setBounds(x, y, width, height);
        }
        this.editorPane = new SourceEditorPane();
        contentPane.add((Component)this.editorPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SourceEditorWindow.this.onWindowClosing(evt);
            }
        });
        this.editorPane.setFindTextHistory(opts.getFindList());
        this.editorPane.setReplaceTextHistory(opts.getReplaceList());
    }

    public void setVectorCanvas(VectorCanvas canvas) {
        this.editorPane.setVectorCanvas(canvas);
    }

    private void saveSettings() {
        Rectangle rv = this.getBounds();
        SourceEditorOptions opts = SourceEditorOptions.getInstance();
        opts.setBounds(rv);
        opts.setFindReplaceList(this.editorPane.getFindTextHistory(), this.editorPane.getReplaceTextHistory());
    }

    private void onWindowClosing(WindowEvent e) {
        boolean close = true;
        if (this.editorPane.isModified()) {
            Object[] options = new Object[]{bundle.getString("MSG_ConfirmSourceModified.ApplyOption.Text"), bundle.getString("MSG_ConfirmSourceModified.DiscardOption.Text"), bundle.getString("MSG_ConfirmSourceModified.CancelOption.Text")};
            int choice = JOptionPane.showOptionDialog(this, bundle.getString("MSG_ConfirmSourceModified.Text"), bundle.getString("MSG_ConfirmSourceModified.Title"), -1, 3, null, options, options[0]);
            if (choice == 0) {
                SVGDocument doc = this.editorPane.apply();
                if (doc == null) {
                    close = false;
                }
            } else if (choice == 1) {
                close = true;
            } else if (choice == 2) {
                close = false;
            }
        }
        if (close) {
            this.saveSettings();
            this.setVisible(false);
            this.editorPane = null;
            this.dispose();
        }
    }
}

