/*
 * Decompiled with CFR 0.152.
 */
package kiyut.swing.text.xml;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import kiyut.swing.text.xml.XMLContext;
import kiyut.swing.text.xml.XMLDocument;
import kiyut.swing.text.xml.XMLScanner;
import kiyut.swing.text.xml.XMLToken;

public class XMLView
extends PlainView {
    protected XMLContext context = null;
    protected XMLScanner lexer = new XMLScanner();

    public XMLView(XMLContext context, Element elem) {
        super(elem);
        this.context = context;
    }

    @Override
    public int getTabSize() {
        return this.context.getTabWidth();
    }

    @Override
    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        Segment text;
        int ctx;
        XMLDocument doc = (XMLDocument)this.getDocument();
        XMLToken token = doc.getScannerStart(p0);
        String str = doc.getText(token.getStartOffset(), p1 - token.getStartOffset() + 1);
        this.lexer.setString(str);
        this.lexer.reset();
        int pos = token.getStartOffset();
        int lastCtx = ctx = token.getContext();
        while (pos < p0) {
            pos = this.lexer.scan(ctx) + token.getStartOffset();
            lastCtx = ctx;
            ctx = this.lexer.getScanValue();
        }
        int mark = p0;
        while (pos < p1) {
            if (lastCtx != ctx) {
                g.setColor(this.context.getSyntaxForeground(lastCtx));
                g.setFont(this.context.getSyntaxFont(lastCtx));
                text = this.getLineBuffer();
                doc.getText(mark, pos - mark, text);
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, mark);
                mark = pos;
            }
            pos = this.lexer.scan(ctx) + token.getStartOffset();
            lastCtx = ctx;
            ctx = this.lexer.getScanValue();
        }
        g.setColor(this.context.getSyntaxForeground(lastCtx));
        g.setFont(this.context.getSyntaxFont(lastCtx));
        text = this.getLineBuffer();
        doc.getText(mark, p1 - mark, text);
        x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, mark);
        return x;
    }

    @Override
    protected void damageLineRange(int line0, int line1, Shape a, Component host) {
        if (a != null) {
            host.repaint();
        }
    }
}

