/*
 * Decompiled with CFR 0.152.
 */
package kiyut.swing.tree.dom;

import java.awt.Component;
import java.awt.Font;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import kiyut.swing.tree.dom.DOMTree;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.swing.tree.dom.DOMTreeCellRenderer");
    private static final String iconSuffix = ".Icon";
    protected int columns = 80;
    protected Pattern linePattern;
    protected Icon nodeIcon;
    protected Icon documentIcon;
    protected Icon commentIcon;
    protected Icon elementIcon;
    protected Icon textIcon;
    protected Icon cdataIcon;
    protected Icon procInsIcon;
    private Icon curIcon;

    public DOMTreeCellRenderer() {
        try {
            this.nodeIcon = new ImageIcon(this.getClass().getResource(bundle.getString("Node.Icon")));
            this.documentIcon = new ImageIcon(this.getClass().getResource(bundle.getString("Document.Icon")));
            this.commentIcon = new ImageIcon(this.getClass().getResource(bundle.getString("Comment.Icon")));
            this.elementIcon = new ImageIcon(this.getClass().getResource(bundle.getString("Element.Icon")));
            this.textIcon = new ImageIcon(this.getClass().getResource(bundle.getString("Text.Icon")));
            this.cdataIcon = new ImageIcon(this.getClass().getResource(bundle.getString("CDATA.Icon")));
            this.procInsIcon = new ImageIcon(this.getClass().getResource(bundle.getString("ProcessingInstruction.Icon")));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.setFont(new Font("Monospaced", 0, 12));
        String patternStr = "\r\n|\n|\r|\u0085|\u2028|\u2029";
        this.linePattern = Pattern.compile(patternStr);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String text;
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
        Node domNode = (Node)treeNode.getUserObject();
        switch (domNode.getNodeType()) {
            case 9: {
                this.curIcon = this.documentIcon;
                text = domNode.getNodeName();
                break;
            }
            case 1: {
                this.curIcon = this.elementIcon;
                if (((DOMTree)tree).isIdVisible()) {
                    String id = ((Element)domNode).getAttribute("id");
                    if (id.length() != 0) {
                        text = domNode.getNodeName() + " id=\"" + id + "\"";
                        break;
                    }
                    text = domNode.getNodeName();
                    break;
                }
                text = domNode.getNodeName();
                break;
            }
            case 8: {
                this.curIcon = this.commentIcon;
                text = this.formatString(domNode.getNodeValue());
                break;
            }
            case 7: {
                this.curIcon = this.procInsIcon;
                text = domNode.getNodeName();
                break;
            }
            case 3: {
                this.curIcon = this.textIcon;
                text = this.formatString(domNode.getNodeValue());
                break;
            }
            case 4: {
                this.curIcon = this.cdataIcon;
                text = domNode.getNodeName();
                break;
            }
            default: {
                this.curIcon = this.nodeIcon;
                text = domNode.getNodeName();
            }
        }
        super.getTreeCellRendererComponent(tree, text, sel, expanded, leaf, row, hasFocus);
        this.setIcon(this.curIcon);
        return this;
    }

    protected String formatString(String text) {
        String str;
        if (text.length() <= this.columns) {
            str = text;
        } else {
            String[] strs = this.linePattern.split(text, 2);
            str = strs[0];
            if (str.length() > this.columns) {
                str = text.substring(0, this.columns - 3) + "...";
            }
        }
        int count = this.columns - str.length();
        StringBuilder sb = new StringBuilder(str);
        for (int i = 0; i < count; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

