/*
 * Decompiled with CFR 0.152.
 */
package kiyut.swing.tree.dom;

import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class DOMTreeModel
extends DefaultTreeModel {
    protected Document doc;
    protected EventListener domListener;
    protected Map<TreeNode, Node> treeNodeMap = new HashMap<TreeNode, Node>();
    protected Map<Node, TreeNode> domNodeMap = new HashMap<Node, TreeNode>();
    protected NodeFilter nodeFilter;

    public DOMTreeModel() {
        super(null);
        this.domListener = new EventListener(){

            @Override
            public void handleEvent(Event evt) {
                DOMTreeModel.this.domNodeHandleEvent(evt);
            }
        };
    }

    public void setDocument(Document doc) {
        Document oldDoc = this.doc;
        if (oldDoc != null) {
            EventTarget old = (EventTarget)((Object)oldDoc.getDocumentElement());
            old.removeEventListener("DOMNodeInserted", this.domListener, false);
            old.removeEventListener("DOMNodeRemoved", this.domListener, false);
            old.removeEventListener("DOMAttrModified", this.domListener, false);
        }
        this.doc = doc;
        this.treeNodeMap.clear();
        this.domNodeMap.clear();
        if (doc == null) {
            return;
        }
        DocumentTraversal travelsal = (DocumentTraversal)((Object)doc);
        TreeWalker tw = travelsal.createTreeWalker(doc, -1, this.nodeFilter, false);
        MutableTreeNode rootNode = this.buildTree(tw);
        this.setRoot(rootNode);
        EventTarget et = (EventTarget)((Object)this.doc.getDocumentElement());
        et.addEventListener("DOMNodeInserted", this.domListener, false);
        et.addEventListener("DOMNodeRemoved", this.domListener, false);
        et.addEventListener("DOMAttrModified", this.domListener, false);
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setNodeFilter(NodeFilter nodeFilter) {
        this.nodeFilter = nodeFilter;
        this.setDocument(this.getDocument());
    }

    public NodeFilter getNodeFilter() {
        return this.nodeFilter;
    }

    protected MutableTreeNode buildTree(TreeWalker tw) {
        Node n = tw.getCurrentNode();
        DefaultMutableTreeNode result = new DefaultMutableTreeNode(n);
        this.treeNodeMap.put(result, n);
        this.domNodeMap.put(n, result);
        Node child = tw.firstChild();
        while (child != null) {
            MutableTreeNode treeNode = this.buildTree(tw);
            if (treeNode != null) {
                result.add(treeNode);
            }
            child = tw.nextSibling();
        }
        tw.setCurrentNode(n);
        return result;
    }

    @Override
    public boolean isLeaf(Object node) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        Node domNode = (Node)treeNode.getUserObject();
        return !domNode.hasChildNodes();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void reload(TreeNode node) {
        if (node == null) {
            return;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        Node domNode = (Node)treeNode.getUserObject();
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)treeNode.getChildAt(i);
            Node dn = (Node)tn.getUserObject();
            this.treeNodeMap.remove(tn);
            this.domNodeMap.remove(dn);
        }
        treeNode.removeAllChildren();
        Document ownerDoc = domNode.getOwnerDocument();
        DocumentTraversal travelsal = (DocumentTraversal)((Object)ownerDoc);
        TreeWalker tw = travelsal.createTreeWalker(domNode, -1, null, false);
        Node child = tw.firstChild();
        while (child != null) {
            tw.setCurrentNode(child);
            MutableTreeNode newChild = this.buildTree(tw);
            if (newChild != null) {
                treeNode.add(newChild);
            }
            child = tw.nextSibling();
        }
        super.reload(node);
    }

    public TreeNode getTreeNode(Node domNode) {
        return this.domNodeMap.get(domNode);
    }

    public Node getDOMNode(TreeNode treeNode) {
        return this.treeNodeMap.get(treeNode);
    }

    public void moveNodeUp(TreeNode node) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        Node domNode = (Node)treeNode.getUserObject();
        Node parentNode = domNode.getParentNode();
        DocumentTraversal travelsal = (DocumentTraversal)((Object)this.doc);
        TreeWalker tw = travelsal.createTreeWalker(parentNode, -1, this.nodeFilter, false);
        tw.setCurrentNode(domNode);
        Node prevNode = tw.previousSibling();
        if (parentNode != null && prevNode != null) {
            parentNode.insertBefore(domNode, prevNode);
        }
    }

    public void moveNodeDown(TreeNode node) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        Node domNode = (Node)treeNode.getUserObject();
        Node parentNode = domNode.getParentNode();
        DocumentTraversal travelsal = (DocumentTraversal)((Object)this.doc);
        TreeWalker tw = travelsal.createTreeWalker(parentNode, -1, this.nodeFilter, false);
        tw.setCurrentNode(domNode);
        Node nextNode = tw.nextSibling();
        if (parentNode != null && nextNode != null) {
            nextNode = tw.nextSibling();
            if (nextNode != null) {
                parentNode.insertBefore(domNode, nextNode);
            } else {
                parentNode.removeChild(domNode);
                parentNode.appendChild(domNode);
            }
        }
    }

    public void removeNode(TreeNode node) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        Node domNode = (Node)treeNode.getUserObject();
        Node parentNode = domNode.getParentNode();
        if (parentNode != null) {
            parentNode.removeChild(domNode);
        }
    }

    protected void domNodeHandleEvent(Event evt) {
        Node domNode;
        TreeNode treeNode;
        Attr attr;
        if (evt.getType().equalsIgnoreCase("DOMNodeInserted")) {
            EventTarget et = evt.getTarget();
            if (et instanceof Node) {
                Node domNode2 = (Node)((Object)et);
                Node parentDomNode = domNode2.getParentNode();
                DefaultMutableTreeNode parentTreeNode = (DefaultMutableTreeNode)this.domNodeMap.get(parentDomNode);
                DefaultMutableTreeNode treeNode2 = new DefaultMutableTreeNode(domNode2);
                int index = 0;
                boolean found = false;
                DocumentTraversal travelsal = (DocumentTraversal)((Object)this.doc);
                TreeWalker tw = travelsal.createTreeWalker(parentDomNode, -1, this.nodeFilter, false);
                Node child = tw.firstChild();
                while (child != null) {
                    if (child.equals(domNode2)) {
                        found = true;
                        break;
                    }
                    ++index;
                    child = tw.nextSibling();
                }
                if (!found) {
                    index = 0;
                }
                if (treeNode2 != null && parentTreeNode != null) {
                    this.treeNodeMap.put(treeNode2, domNode2);
                    this.domNodeMap.put(domNode2, treeNode2);
                    this.insertNodeInto(treeNode2, parentTreeNode, index);
                    this.reload(treeNode2);
                }
            }
        } else if (evt.getType().equalsIgnoreCase("DOMNodeRemoved")) {
            EventTarget et = evt.getTarget();
            if (et instanceof Node) {
                Node domNode3 = (Node)((Object)et);
                DefaultMutableTreeNode treeNode3 = (DefaultMutableTreeNode)this.domNodeMap.get(domNode3);
                if (treeNode3 != null) {
                    this.removeNodeFromParent(treeNode3);
                }
                this.domNodeMap.remove(domNode3);
                this.treeNodeMap.remove(treeNode3);
            }
        } else if (evt.getType().equalsIgnoreCase("DOMAttrModified") && (attr = (Attr)((MutationEvent)evt).getRelatedNode()).getName().equals("id") && (treeNode = this.domNodeMap.get(domNode = (Node)((Object)evt.getTarget()))) != null) {
            this.nodeChanged(treeNode);
        }
    }
}

