/*
 * Decompiled with CFR 0.152.
 */
package kiyut.swing.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class MenuFactory {
    private static final String TYPE_MENU = "MENU";
    private static final String TYPE_ITEM = "ITEM";
    private static final String TYPE_RADIO = "RADIO";
    private static final String TYPE_CHECK = "CHECK";
    private static final String SEPARATOR = "-";
    private static final String MENU_TYPE = "MenuType";
    private static final String MENU_ICON = "MenuIcon";
    private static final String ACTION = "Action";
    private static final String SELECTED = "Selected";
    private static final String ENABLED = "Enabled";
    protected ResourceBundle bundle;
    protected Map<String, Action> actionMap;

    public MenuFactory(ResourceBundle bundle, Map<String, Action> actionMap) {
        this.bundle = bundle;
        this.actionMap = actionMap;
    }

    public static void configureActionMap(ResourceBundle bundle, Map<String, Action> actionMap) {
        for (String name : actionMap.keySet()) {
            String str;
            Action action = actionMap.get(name);
            name = name + ".";
            try {
                action.putValue("Name", bundle.getString(name + "Name"));
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                String url = bundle.getString(name + "SmallIcon");
                ImageIcon icon = new ImageIcon(action.getClass().getResource(url));
                action.putValue("SmallIcon", icon);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                action.putValue("ShortDescription", bundle.getString(name + "ShortDescription"));
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                str = bundle.getString(name + "MnemonicKey");
                if (str.length() == 1) {
                    action.putValue("MnemonicKey", new Integer(str.charAt(0)));
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                str = bundle.getString(name + "AcceleratorKey");
                KeyStroke ks = KeyStroke.getKeyStroke(str);
                if (ks == null) continue;
                action.putValue("AcceleratorKey", ks);
            }
            catch (MissingResourceException e) {}
        }
    }

    public static JMenuBar createMenuBar(ResourceBundle bundle, Map<String, Action> actionMap) {
        MenuFactory factory = new MenuFactory(bundle, actionMap);
        JMenuBar menuBar = factory.createMenuBar();
        return menuBar;
    }

    public static JPopupMenu createPopupMenu(ResourceBundle bundle, Map<String, Action> actionMap, String name) {
        MenuFactory factory = new MenuFactory(bundle, actionMap);
        JPopupMenu popupMenu = factory.createPopupMenu(name);
        return popupMenu;
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        String menu = this.bundle.getString("MenuBar");
        List<String> menuList = this.convertToList(menu);
        Iterator<String> it = menuList.iterator();
        while (it.hasNext()) {
            menuBar.add(this.createMenuComponent(it.next()));
        }
        return menuBar;
    }

    public JPopupMenu createPopupMenu(String name) {
        JPopupMenu popupMenu = new JPopupMenu();
        String menu = this.bundle.getString(name);
        List<String> menuList = this.convertToList(menu);
        Iterator<String> it = menuList.iterator();
        while (it.hasNext()) {
            popupMenu.add(this.createMenuComponent(it.next()));
        }
        return popupMenu;
    }

    protected List<String> convertToList(String str) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    protected JComponent createMenuComponent(String name) {
        JMenuItem comp;
        if (name.equals(SEPARATOR)) {
            return new JSeparator();
        }
        String type = this.bundle.getString(name + "." + MENU_TYPE);
        if (type.equalsIgnoreCase(TYPE_MENU)) {
            comp = this.createJMenu(name);
        } else if (type.equalsIgnoreCase(TYPE_ITEM)) {
            comp = this.createJMenuItem(name);
        } else if (type.equalsIgnoreCase(TYPE_CHECK)) {
            comp = this.createJCheckBoxMenuItem(name);
        } else {
            throw new MissingResourceException("Malformed resource " + name + MENU_TYPE, this.bundle.getClass().getName(), name + MENU_TYPE);
        }
        return comp;
    }

    protected JMenu createJMenu(String name) {
        JMenu menu = new JMenu();
        this.configureMenuItem(menu, name);
        String str = null;
        try {
            str = this.bundle.getString(name);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (str == null) {
            return menu;
        }
        List<String> menuList = this.convertToList(str);
        Iterator<String> it = menuList.iterator();
        while (it.hasNext()) {
            menu.add(this.createMenuComponent(it.next()));
        }
        return menu;
    }

    protected JMenuItem createJMenuItem(String name) {
        JMenuItem menuItem = new JMenuItem();
        this.configureMenuItem(menuItem, name);
        return menuItem;
    }

    protected JCheckBoxMenuItem createJCheckBoxMenuItem(String name) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem();
        this.configureMenuItem(menuItem, name);
        return menuItem;
    }

    protected void configureMenuItem(JMenuItem item, String name) {
        String str;
        Action action = null;
        name = name + ".";
        try {
            String actionStr = this.bundle.getString(name + ACTION);
            action = this.actionMap.get(actionStr);
            if (action == null) {
                throw new NullPointerException("Missing actionListener " + name + ACTION);
            }
            item.setAction(action);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            if (action == null) {
                item.setText(this.bundle.getString(name + "Name"));
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            String url = this.bundle.getString(name + MENU_ICON);
            ImageIcon icon = new ImageIcon(this.getClass().getResource(url));
            item.setIcon(icon);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            str = this.bundle.getString(name + "MnemonicKey");
            if (str.length() == 1 && action == null) {
                item.setMnemonic(str.charAt(0));
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            str = this.bundle.getString(name + "AcceleratorKey");
            KeyStroke ks = KeyStroke.getKeyStroke(str);
            if (ks != null && action == null) {
                item.setAccelerator(ks);
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
    }
}

